/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.c14n;

import com.verisign.c14n.Canonicalizer;
import com.verisign.c14n.ExclusiveCanonicalizer;
import com.verisign.c14n.NormalCanonicalizer;
import com.verisign.c14n.StreamCanonicalizer;

public class CanonicalizerFactory {
    public static final boolean USE_OLD_IMPL = System.getProperty("OLDC14N") != null;

    public static Canonicalizer getInstance(String namespaceUri) {
        if (USE_OLD_IMPL) {
            return CanonicalizerFactory.getOldImplementation(namespaceUri);
        }
        boolean includeComments = namespaceUri.endsWith("WithComments");
        if (namespaceUri.equals("http://www.w3.org/TR/2001/REC-xml-c14n-20010315") || namespaceUri.equals("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments")) {
            return new StreamCanonicalizer(false, includeComments);
        }
        if (namespaceUri.equals(Canonicalizer.EXCLUSIVE) || namespaceUri.equals(Canonicalizer.EXCLUSIVE_WITH_COMMENTS)) {
            return new StreamCanonicalizer(true, includeComments);
        }
        throw new UnsupportedOperationException(namespaceUri + " has no associated canonicalizer");
    }

    public static Canonicalizer getOldImplementation(String namespaceUri) {
        boolean includeComments = namespaceUri.endsWith("WithComments");
        if (namespaceUri.equals("http://www.w3.org/TR/2001/REC-xml-c14n-20010315") || namespaceUri.equals("http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments")) {
            return new NormalCanonicalizer(includeComments);
        }
        if (namespaceUri.equals(Canonicalizer.EXCLUSIVE) || namespaceUri.equals(Canonicalizer.EXCLUSIVE_WITH_COMMENTS)) {
            return new ExclusiveCanonicalizer(includeComments);
        }
        throw new UnsupportedOperationException(namespaceUri + " has no associated canonicalizer");
    }
}

