/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.c14n;

import com.verisign.c14n.Canonicalizer;
import com.verisign.c14n.CanonicalizerFactory;
import com.verisign.domutil.DOMCursor;
import com.verisign.domutil.DOMWriteCursor;
import com.verisign.resource.ResourceFactory;
import com.verisign.resource.XMLResource;
import com.verisign.xpath.XPath;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class CanonXML {
    static final int INIT_COUNT = 20;
    static final int REPEAT_COUNT = 10;
    static XMLResource xmlres;

    public static void main(String[] args) throws Exception {
        Document doc;
        boolean old = CanonicalizerFactory.USE_OLD_IMPL;
        if (old) {
            System.err.println("Using old implementation");
        }
        Node source = doc = xmlres.parseXML(System.in, false);
        String xpath = CanonXML.findValue("-xpath", args, null);
        if (xpath != null) {
            DOMCursor c = new DOMCursor(doc);
            if (!c.moveToXPath(new XPath(xpath))) {
                throw new Exception("xpath not found");
            }
            source = c.getElement();
        }
        boolean exclusive = CanonXML.findFlag("-exclusive", args);
        boolean comments = CanonXML.findFlag("-comments", args);
        String alg = exclusive ? (comments ? Canonicalizer.EXCLUSIVE : Canonicalizer.EXCLUSIVE_WITH_COMMENTS) : (comments ? "http://www.w3.org/TR/2001/REC-xml-c14n-20010315" : "http://www.w3.org/TR/2001/REC-xml-c14n-20010315#WithComments");
        boolean time = CanonXML.findFlag("-time", args);
        if (time) {
            int i = 0;
            while (i < 20) {
                CanonXML.runOnce(source, old, alg);
                ++i;
            }
            long start = System.currentTimeMillis();
            int i2 = 0;
            while (i2 < 10) {
                CanonXML.runOnce(source, old, alg);
                ++i2;
            }
            long end = System.currentTimeMillis();
            System.err.println("Average Millis: " + (end - start) / 10L);
        }
        System.out.println(new String(CanonXML.runOnce(source, old, alg)));
    }

    static byte[] runOnce(Node source, boolean old, String alg) {
        Canonicalizer c14n = old ? CanonicalizerFactory.getOldImplementation(alg) : CanonicalizerFactory.getInstance(alg);
        if (old) {
            DOMWriteCursor c = new DOMWriteCursor();
            c.copyUnder(new DOMCursor(source));
            source = c.getElement();
        }
        return c14n.canonicalize(source, null);
    }

    static String findValue(String toFind, String[] argv) {
        String val = CanonXML.findValue(toFind, argv, null);
        if (val == null) {
            throw new IllegalArgumentException("'" + toFind + "' argument missing in input");
        }
        return val;
    }

    static String findValue(String toFind, String[] argv, String defaultVal) {
        int i = 0;
        while (i < argv.length) {
            if (argv[i].equals(toFind)) {
                if (++i >= argv.length || argv[i] == null || argv[i].startsWith("-")) break;
                return argv[i];
            }
            ++i;
        }
        return defaultVal;
    }

    static boolean findFlag(String toFind, String[] argv) {
        int i = 0;
        while (i < argv.length) {
            if (argv[i].equals(toFind)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    static {
        INIT_COUNT = 20;
        REPEAT_COUNT = 10;
        xmlres = ResourceFactory.getXMLResource();
    }
}

