/*
 * Decompiled with CFR 0.152.
 */
package com.nanobiz.xpath.evaluator;

import com.nanobiz.xpath.Context;
import com.nanobiz.xpath.evaluator.ExprEvaluator;
import com.nanobiz.xpath.util.Coerce;

public class UnaryMinusExprEvaluator
extends ExprEvaluator {
    ExprEvaluator operand;

    public UnaryMinusExprEvaluator(ExprEvaluator operand) {
        this.operand = operand;
    }

    public Object evaluate(Context context) {
        return new Double(-Coerce.toNumber(this.operand.evaluate(context)).doubleValue());
    }

    public int getPrecedence() {
        return 70;
    }

    public boolean isConstant() {
        return this.operand.isConstant();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.operand.getPrecedence() < this.getPrecedence()) {
            sb.append("-(");
            sb.append(this.operand.toString());
            sb.append(")");
        } else {
            sb.append("-");
            sb.append(this.operand.toString());
        }
        return sb.toString();
    }
}

