/*
 * Decompiled with CFR 0.152.
 */
package com.nanobiz.xpath.evaluator;

import com.nanobiz.xpath.evaluator.InvocationContext;
import com.nanobiz.xpath.evaluator.NodeTestEvaluator;
import com.nanobiz.xpath.util.NodeArray;
import com.nanobiz.xpath.util.QualifiedName;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class QualifiedNameNodeTestEvaluator
extends NodeTestEvaluator {
    private String prefix;
    private String localName;
    boolean wildcard;

    static Node parent(Node n) {
        if (n.getNodeType() == 2) {
            return ((Attr)n).getOwnerElement();
        }
        return n.getParentNode();
    }

    static String getLocalName(String name) {
        int colonPos = name.lastIndexOf(58);
        if (colonPos == -1) {
            return name;
        }
        return name.substring(colonPos + 1, name.length());
    }

    static String getLocalName(Node n) {
        switch (n.getNodeType()) {
            case 1: 
            case 2: {
                String name = n.getLocalName();
                if (name != null) {
                    return name;
                }
                return QualifiedNameNodeTestEvaluator.getLocalName(n.getNodeName());
            }
        }
        return null;
    }

    static String getPrefix(String name) {
        int colonPos = name.lastIndexOf(58);
        if (colonPos == -1) {
            return null;
        }
        return name.substring(0, colonPos);
    }

    static String getPrefix(Node n) {
        switch (n.getNodeType()) {
            case 1: 
            case 2: {
                return QualifiedNameNodeTestEvaluator.getPrefix(n.getNodeName());
            }
        }
        return null;
    }

    static String resolvePrefix(String prefix, Node n) {
        while (n != null) {
            if (n.getNodeType() == 1) {
                Element e = (Element)n;
                Attr a = prefix == null ? e.getAttributeNode("xmlns") : e.getAttributeNode("xmlns:" + prefix);
                if (a != null) {
                    String x = a.getValue();
                    if ("".equals(x)) {
                        return null;
                    }
                    return x;
                }
            }
            n = QualifiedNameNodeTestEvaluator.parent(n);
        }
        return null;
    }

    static String getNamespaceURI(Node n) {
        switch (n.getNodeType()) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                return null;
            }
        }
        if (QualifiedNameNodeTestEvaluator.getPrefix(n) == null && n.getNodeType() == 2) {
            return null;
        }
        return QualifiedNameNodeTestEvaluator.resolvePrefix(QualifiedNameNodeTestEvaluator.getPrefix(n), n);
    }

    public QualifiedNameNodeTestEvaluator(QualifiedName name) {
        this.prefix = name.getPrefix();
        this.localName = name.getLocalName();
        if (this.localName == null) {
            this.localName = "*";
        }
        this.wildcard = this.localName.equals("*");
    }

    public void filter(InvocationContext invocationContext, NodeArray na, short principalNodeType) {
        String namespaceURI = this.prefix == null ? null : invocationContext.getBindingContext().getNamespaceURI(this.prefix);
        int j = 0;
        int i = 0;
        int l = na.len;
        while (i < l) {
            Node node = na.nodes[i];
            if (node.getNodeType() == principalNodeType) {
                String nodeNamespaceURI = QualifiedNameNodeTestEvaluator.getNamespaceURI(node);
                String nodeLocalName = QualifiedNameNodeTestEvaluator.getLocalName(node);
                if ((this.wildcard || this.localName != null && this.localName.equals(nodeLocalName)) && (this.wildcard && namespaceURI == null || namespaceURI == null && nodeNamespaceURI == null || namespaceURI != null && namespaceURI.equals(nodeNamespaceURI))) {
                    na.nodes[j++] = node;
                }
            }
            ++i;
        }
        na.truncate(j);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.prefix != null) {
            sb.append("{");
            sb.append(this.prefix);
            sb.append("}:");
        }
        sb.append(this.localName);
        return sb.toString();
    }
}

