/*
 * Decompiled with CFR 0.152.
 */
package com.nanobiz.xpath.evaluator;

import com.nanobiz.xpath.Context;
import com.nanobiz.xpath.evaluator.ContextImpl;
import com.nanobiz.xpath.evaluator.ExprEvaluator;
import com.nanobiz.xpath.util.Coerce;
import com.nanobiz.xpath.util.NodeSet;
import java.util.Iterator;
import org.w3c.dom.Node;

public class PredicateExprEvaluator
extends ExprEvaluator {
    private ExprEvaluator sourceExpr;
    private ExprEvaluator predicateExpr;

    public PredicateExprEvaluator(ExprEvaluator sourceExpr, ExprEvaluator predicateExpr) {
        this.sourceExpr = sourceExpr;
        this.predicateExpr = predicateExpr;
    }

    public int getPrecedence() {
        return 100;
    }

    public boolean isConstant() {
        return this.sourceExpr.isConstant() && this.predicateExpr.isConstant();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.sourceExpr.getPrecedence() < this.getPrecedence()) {
            sb.append("(");
            sb.append(this.sourceExpr.toString());
            sb.append(")");
        } else {
            sb.append(this.sourceExpr.toString());
        }
        sb.append("[");
        sb.append(this.predicateExpr);
        sb.append("]");
        return sb.toString();
    }

    public Object evaluate(Context context) {
        int l;
        Object source = this.sourceExpr.evaluate(context);
        NodeSet ns = (NodeSet)source;
        NodeSet nns = new NodeSet();
        ContextImpl predicateContext = new ContextImpl((ContextImpl)context);
        predicateContext.size = l = ns.size();
        Iterator it = ns.iterator();
        predicateContext.position = 0;
        while (it.hasNext()) {
            predicateContext.node = (Node)it.next();
            ++predicateContext.position;
            Object predicateValue = this.predicateExpr.evaluate(predicateContext);
            if (predicateValue instanceof Number) {
                predicateValue = new Boolean(((Number)predicateValue).doubleValue() == (double)predicateContext.position);
            }
            if (!Coerce.toBoolean(predicateValue).booleanValue()) continue;
            nns.add(predicateContext.node);
        }
        return nns;
    }
}

