/*
 * Decompiled with CFR 0.152.
 */
package com.nanobiz.xpath.evaluator;

import com.nanobiz.xpath.evaluator.ContextImpl;
import com.nanobiz.xpath.evaluator.Evaluator;
import com.nanobiz.xpath.evaluator.ExprEvaluator;
import com.nanobiz.xpath.evaluator.InvocationContext;
import com.nanobiz.xpath.util.Coerce;
import com.nanobiz.xpath.util.NodeArray;

public class PredicateEvaluator
extends Evaluator {
    private ExprEvaluator predicate;

    public PredicateEvaluator(ExprEvaluator predicate) {
        this.predicate = predicate;
    }

    public void filter(InvocationContext invocationContext, NodeArray na, boolean isReverseAxis) {
        ContextImpl predicateContext = new ContextImpl();
        predicateContext.size = na.len;
        predicateContext.invocation = invocationContext;
        int j = 0;
        int i = 0;
        int l = na.len;
        while (i < l) {
            predicateContext.position = isReverseAxis ? l - i : i + 1;
            predicateContext.node = na.nodes[i];
            Object predicateValue = this.predicate.evaluate(predicateContext);
            if (predicateValue instanceof Number) {
                predicateValue = new Boolean(((Number)predicateValue).doubleValue() == (double)predicateContext.position);
            }
            if (Coerce.toBoolean(predicateValue).booleanValue()) {
                na.nodes[j++] = predicateContext.node;
            }
            ++i;
        }
        na.truncate(j);
    }

    public String toString() {
        return "[" + this.predicate.toString() + "]";
    }
}

