/*
 * Decompiled with CFR 0.152.
 */
package com.nanobiz.xpath.evaluator;

import com.nanobiz.xpath.evaluator.InvocationContext;
import com.nanobiz.xpath.evaluator.NodeTestEvaluator;
import com.nanobiz.xpath.util.ExpandedName;
import com.nanobiz.xpath.util.NodeArray;
import org.w3c.dom.Node;

public class ExpandedNameNodeTestEvaluator
extends NodeTestEvaluator {
    private String namespaceURI;
    private String localName;
    boolean wildcard;

    public ExpandedNameNodeTestEvaluator(ExpandedName name) {
        this.namespaceURI = name.getNamespaceURI();
        this.localName = name.getLocalName();
        if (this.localName == null) {
            this.localName = "*";
        }
        this.wildcard = this.localName.equals("*");
    }

    public void filter(InvocationContext invocationContext, NodeArray na, short principalNodeType) {
        int j = 0;
        int i = 0;
        int l = na.len;
        while (i < l) {
            Node node = na.nodes[i];
            if (node.getNodeType() == principalNodeType) {
                String nodeNamespaceURI = node.getNamespaceURI();
                String nodeLocalName = node.getLocalName();
                if ((this.wildcard || this.localName != null && this.localName.equals(nodeLocalName)) && (this.namespaceURI == null && nodeNamespaceURI == null || this.namespaceURI != null && this.namespaceURI.equals(nodeNamespaceURI))) {
                    na.nodes[j++] = node;
                }
            }
            ++i;
        }
        na.truncate(j);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.namespaceURI != null) {
            sb.append("\"");
            sb.append(this.namespaceURI);
            sb.append("\":");
        }
        sb.append(this.localName);
        return sb.toString();
    }
}

