/*
 * Decompiled with CFR 0.152.
 */
package com.nanobiz.xpath.evaluator;

import com.nanobiz.xpath.Context;
import com.nanobiz.xpath.evaluator.ExprEvaluator;
import com.nanobiz.xpath.evaluator.InfixExprEvaluator;
import com.nanobiz.xpath.util.Coerce;
import org.w3c.dom.NodeList;

public abstract class ComparisonExprEvaluator
extends InfixExprEvaluator {
    public ComparisonExprEvaluator(ExprEvaluator lhs, ExprEvaluator rhs) {
        super(lhs, rhs);
    }

    public Object evaluateOperator(Context context, Object lhv, Object rhv) {
        if (lhv instanceof NodeList && rhv instanceof NodeList) {
            NodeList lhnl = (NodeList)lhv;
            NodeList rhnl = (NodeList)rhv;
            int i = 0;
            int l = lhnl.getLength();
            while (i < l) {
                int j = 0;
                int m = rhnl.getLength();
                while (j < m) {
                    if (this.evaluateComparison(context, Coerce.stringValueOfNode(lhnl.item(i)), Coerce.stringValueOfNode(rhnl.item(j)))) {
                        return Boolean.TRUE;
                    }
                    ++j;
                }
                ++i;
            }
            return Boolean.FALSE;
        }
        if (lhv instanceof NodeList) {
            if (rhv instanceof Boolean) {
                return new Boolean(this.evaluateComparison(context, Coerce.toBoolean(lhv), rhv));
            }
            NodeList lhnl = (NodeList)lhv;
            int i = 0;
            int l = lhnl.getLength();
            while (i < l) {
                if (this.evaluateComparison(context, Coerce.stringValueOfNode(lhnl.item(i)), rhv)) {
                    return Boolean.TRUE;
                }
                ++i;
            }
            return Boolean.FALSE;
        }
        if (rhv instanceof NodeList) {
            if (lhv instanceof Boolean) {
                return new Boolean(this.evaluateComparison(context, lhv, Coerce.toBoolean(rhv)));
            }
            NodeList rhnl = (NodeList)rhv;
            int i = 0;
            int l = rhnl.getLength();
            while (i < l) {
                if (this.evaluateComparison(context, lhv, Coerce.stringValueOfNode(rhnl.item(i)))) {
                    return Boolean.TRUE;
                }
                ++i;
            }
            return Boolean.FALSE;
        }
        return new Boolean(this.evaluateComparison(context, lhv, rhv));
    }

    public abstract boolean evaluateComparison(Context var1, Object var2, Object var3);
}

