/*
 * Decompiled with CFR 0.152.
 */
package com.nanobiz.xpath.evaluator;

import com.nanobiz.xpath.evaluator.AxisEvaluator;
import com.nanobiz.xpath.util.NodeArray;
import com.nanobiz.xpath.util.NodeListToNamedNodeMapAdapter;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class AxisLibrary {
    static Map cache = Collections.synchronizedMap(new HashMap());
    static /* synthetic */ Class class$org$w3c$dom$Node;
    static /* synthetic */ Class class$com$nanobiz$xpath$evaluator$AxisLibrary;

    private AxisLibrary() {
        throw new Error();
    }

    private static Node parent(Node n) {
        if (n.getNodeType() == 2) {
            return ((Attr)n).getOwnerElement();
        }
        return n.getParentNode();
    }

    public static AxisEvaluator getAxis(String name) {
        AxisEvaluator axis = (AxisEvaluator)cache.get(name);
        if (axis == null) {
            try {
                axis = new AxisEvaluatorImpl(name);
                cache.put(name, axis);
            }
            catch (Exception ex) {
                return null;
            }
        }
        return axis;
    }

    public static NodeArray a_self(Node node) {
        NodeArray na = new NodeArray();
        na.add(node);
        return na;
    }

    public static NodeArray a_child(Node node) {
        return new NodeArray(node.getChildNodes());
    }

    private static void collectDescendants(Node node, NodeArray na) {
        NodeList nl = node.getChildNodes();
        int i = 0;
        int l = nl.getLength();
        while (i < l) {
            Node d = nl.item(i);
            na.add(d);
            AxisLibrary.collectDescendants(d, na);
            ++i;
        }
    }

    public static NodeArray a_descendant(Node node) {
        NodeArray na = new NodeArray();
        AxisLibrary.collectDescendants(node, na);
        return na;
    }

    public static NodeArray a_descendant_or_self(Node node) {
        NodeArray na = new NodeArray();
        na.add(node);
        AxisLibrary.collectDescendants(node, na);
        return na;
    }

    public static NodeArray a_parent(Node node) {
        NodeArray na = new NodeArray();
        Node p = AxisLibrary.parent(node);
        if (p != null) {
            na.add(p);
        }
        return na;
    }

    public static NodeArray a_ancestor_or_self(Node node) {
        NodeArray na;
        if (node != null) {
            na = AxisLibrary.a_ancestor_or_self(AxisLibrary.parent(node));
            na.add(node);
        } else {
            na = new NodeArray();
        }
        return na;
    }

    public static NodeArray a_ancestor(Node node) {
        return AxisLibrary.a_ancestor_or_self(AxisLibrary.parent(node));
    }

    public static NodeArray a_following_sibling(Node node) {
        NodeArray na = new NodeArray();
        while ((node = node.getNextSibling()) != null) {
            na.add(node);
        }
        return na;
    }

    public static NodeArray a_preceding_sibling(Node node) {
        NodeArray na;
        Node sib = node.getPreviousSibling();
        if (sib == null) {
            na = new NodeArray();
        } else {
            na = AxisLibrary.a_preceding_sibling(sib);
            na.add(sib);
        }
        return na;
    }

    public static NodeArray a_following(Node node) {
        NodeArray na = new NodeArray();
        while (node != null) {
            Node sib = node.getNextSibling();
            while (sib != null) {
                na.add(sib);
                AxisLibrary.collectDescendants(sib, na);
                sib = sib.getNextSibling();
            }
            node = AxisLibrary.parent(node);
        }
        return na;
    }

    public static NodeArray a_preceding(Node node) {
        Node p = AxisLibrary.parent(node);
        NodeArray na = p != null ? AxisLibrary.a_preceding(p) : new NodeArray();
        NodeArray nl = AxisLibrary.a_preceding_sibling(p);
        int i = 0;
        int l = nl.getLength();
        while (i < l) {
            Node sib = nl.item(i);
            na.add(sib);
            AxisLibrary.collectDescendants(sib, na);
            ++i;
        }
        return na;
    }

    public static NodeArray a_attribute(Node node) {
        NamedNodeMap nm = node.getAttributes();
        NodeList nl = nm instanceof NodeList ? (NodeList)((Object)nm) : new NodeListToNamedNodeMapAdapter(nm);
        return new NodeArray(nl);
    }

    public static NodeList a_namespace(Node node) {
        NodeArray na = AxisLibrary.a_attribute(node);
        int j = 0;
        int i = 0;
        while (i < na.len) {
            Node x = na.nodes[i];
            if ("xmlns".equals(x.getPrefix())) {
                na.nodes[j++] = x;
            }
            ++i;
        }
        na.truncate(j);
        return na;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class AxisEvaluatorImpl
    extends AxisEvaluator {
        String name;
        short principalNodeType;
        Method method;
        boolean isReverseAxis;

        AxisEvaluatorImpl(String name) throws NoSuchMethodException {
            this.name = name;
            this.method = (class$com$nanobiz$xpath$evaluator$AxisLibrary == null ? (class$com$nanobiz$xpath$evaluator$AxisLibrary = AxisLibrary.class$("com.nanobiz.xpath.evaluator.AxisLibrary")) : class$com$nanobiz$xpath$evaluator$AxisLibrary).getMethod("a_" + name.replace('-', '_'), class$org$w3c$dom$Node == null ? (class$org$w3c$dom$Node = AxisLibrary.class$("org.w3c.dom.Node")) : class$org$w3c$dom$Node);
            this.principalNodeType = name.equals("attribute") || name.equals("namespace") ? (short)2 : (short)1;
            this.isReverseAxis = name.indexOf("preceding") != -1 || name.indexOf("ancestor") != -1 || name.indexOf("parent") != -1;
        }

        public NodeArray evaluate(Node node) {
            try {
                return (NodeArray)this.method.invoke(null, node);
            }
            catch (Exception ex) {
                return new NodeArray();
            }
        }

        public short getPrincipalNodeType() {
            return this.principalNodeType;
        }

        public String toString() {
            return this.name;
        }

        public boolean isReverseAxis() {
            return this.isReverseAxis;
        }
    }
}

