/*
 * Decompiled with CFR 0.152.
 */
package com.nanobiz.xpath;

import com.nanobiz.xpath.BindingContext;
import com.nanobiz.xpath.DefaultBindingContextImpl;
import com.nanobiz.xpath.Expression;
import com.nanobiz.xpath.ExpressionImpl;
import com.nanobiz.xpath.XPathException;
import com.nanobiz.xpath.XPathFactory;
import com.nanobiz.xpath.evaluator.ExprEvaluator;
import com.nanobiz.xpath.parser.XPathParser;
import java.io.StringReader;
import java.util.Collections;
import java.util.Map;
import java.util.WeakHashMap;

public class XPathFactoryImpl
implements XPathFactory {
    Map expressionCache = Collections.synchronizedMap(new WeakHashMap());
    BindingContext defbc = new DefaultBindingContextImpl();

    Expression parseExpression(String expression) throws XPathException {
        try {
            StringReader sr = new StringReader(expression + " ");
            XPathParser parser = new XPathParser(sr);
            ExprEvaluator ev = parser.ExprInput();
            ExpressionImpl exp = new ExpressionImpl(ev);
            return exp;
        }
        catch (Exception ex) {
            throw new XPathException(ex);
        }
    }

    public Expression getExpression(String expression) throws XPathException {
        Expression exp = (Expression)this.expressionCache.get(expression);
        if (exp == null) {
            exp = this.parseExpression(expression);
            this.expressionCache.put(expression, exp);
        }
        return exp;
    }

    public BindingContext getDefaultBindingContext() {
        return this.defbc;
    }
}

