/*
 * Decompiled with CFR 0.152.
 */
package com.nanobiz.xpath;

import com.nanobiz.xpath.BindingContext;
import com.nanobiz.xpath.Context;
import com.nanobiz.xpath.Function;
import com.nanobiz.xpath.SimpleBindingContext;
import com.nanobiz.xpath.util.NodeSet;
import com.verisign.resource.DOMOperations;
import com.verisign.xpath.IDDiscriminator;
import com.verisign.xpath.XPath;
import java.util.List;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XPathBindingContext
extends SimpleBindingContext {
    private static final DOMOperations ops = DOMOperations.getInstance();
    private IDDiscriminator idDiscriminator;
    private IDFunction idFunction;

    public XPathBindingContext(XPath xpath) {
        this(xpath, null);
    }

    public XPathBindingContext(XPath xpath, BindingContext def) {
        super(xpath.getNamespaceMap(), def);
        this.idDiscriminator = xpath.getIDDiscriminator();
    }

    public Function getFunction(String namespaceURI, String localName) {
        if (namespaceURI == null && localName.equals("id")) {
            if (this.idFunction == null) {
                this.idFunction = new IDFunction();
            }
            return this.idFunction;
        }
        return super.getFunction(namespaceURI, localName);
    }

    private class IDFunction
    implements Function {
        private IDFunction() {
        }

        public Object evaluate(Context context, List args) {
            NodeSet set = new NodeSet();
            String id = (String)args.get(0);
            if (id != null && id.length() > 0) {
                Node node = context.getNode();
                Document doc = node instanceof Document ? (Document)node : node.getOwnerDocument();
                Element elem = ops.findID(doc, id, XPathBindingContext.this.idDiscriminator);
                if (elem != null) {
                    set.add(elem);
                }
            }
            return set;
        }
    }
}

