/*
 * Decompiled with CFR 0.152.
 */
package com.nanobiz.xpath;

import com.nanobiz.xpath.Context;
import com.nanobiz.xpath.Function;
import com.nanobiz.xpath.util.Coerce;
import com.nanobiz.xpath.util.NodeSet;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

final class StandardLibrary {
    static Map functions = null;
    static /* synthetic */ Class class$com$nanobiz$xpath$Context;
    static /* synthetic */ Class class$java$util$List;
    static /* synthetic */ Class class$com$nanobiz$xpath$StandardLibrary;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$nanobiz$xpath$util$NodeSet;

    StandardLibrary() {
        throw new Error();
    }

    static Node parent(Node n) {
        if (n.getNodeType() == 2) {
            return ((Attr)n).getOwnerElement();
        }
        return n.getParentNode();
    }

    static String getLocalName(String name) {
        int colonPos = name.lastIndexOf(58);
        if (colonPos == -1) {
            return name;
        }
        return name.substring(colonPos + 1, name.length());
    }

    static String getLocalName(Node n) {
        switch (n.getNodeType()) {
            case 1: 
            case 2: {
                String name = n.getLocalName();
                if (name != null) {
                    return name;
                }
                return StandardLibrary.getLocalName(n.getNodeName());
            }
        }
        return null;
    }

    static String getPrefix(String name) {
        int colonPos = name.lastIndexOf(58);
        if (colonPos == -1) {
            return null;
        }
        return name.substring(0, colonPos);
    }

    static String getPrefix(Node n) {
        switch (n.getNodeType()) {
            case 1: 
            case 2: {
                return StandardLibrary.getPrefix(n.getNodeName());
            }
        }
        return null;
    }

    static String resolvePrefix(String prefix, Node n) {
        while (n != null) {
            if (n.getNodeType() == 1) {
                Element e = (Element)n;
                Attr a = prefix == null ? e.getAttributeNode("xmlns") : e.getAttributeNode("xmlns:" + prefix);
                if (a != null) {
                    return a.getValue();
                }
            }
            n = StandardLibrary.parent(n);
        }
        return null;
    }

    static String getNamespaceURI(Node n) {
        switch (n.getNodeType()) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                return null;
            }
        }
        if (StandardLibrary.getPrefix(n) == null && n.getNodeType() == 2) {
            return null;
        }
        return StandardLibrary.resolvePrefix(StandardLibrary.getPrefix(n), n);
    }

    public static Function getFunction(String name) {
        return (Function)functions.get(name);
    }

    public static int f_last(Context context) {
        return context.getSize();
    }

    public static int f_position(Context context) {
        return context.getPosition();
    }

    public static int f_count(Context context, NodeSet ns) {
        return ns.size();
    }

    public static String f_local_name(Context context, List args) {
        switch (args.size()) {
            case 0: {
                return StandardLibrary.getLocalName(context.getNode());
            }
            case 1: {
                try {
                    Node n = (Node)((NodeSet)args.get(0)).first();
                    return StandardLibrary.getLocalName(n);
                }
                catch (NoSuchElementException ex) {
                    return "";
                }
            }
        }
        throw new IllegalArgumentException("too many arguments");
    }

    public static String f_namespace_uri(Context context, List args) {
        switch (args.size()) {
            case 0: {
                return StandardLibrary.getNamespaceURI(context.getNode());
            }
            case 1: {
                try {
                    Node n = (Node)((NodeSet)args.get(0)).first();
                    return StandardLibrary.getNamespaceURI(n);
                }
                catch (NoSuchElementException ex) {
                    return "";
                }
            }
        }
        throw new IllegalArgumentException("too many arguments");
    }

    public static String f_name(Context context) {
        return context.getNode().getNodeName();
    }

    public static String f_name(Context context, NodeSet ns) {
        try {
            Node n = (Node)ns.first();
            return n.getNodeName();
        }
        catch (NoSuchElementException ex) {
            return "";
        }
    }

    public static Object f_string(Context context, List args) {
        Object arg;
        if (args.size() == 0) {
            NodeSet ns = new NodeSet();
            ns.add(context.getNode());
            arg = ns;
        } else if (args.size() == 1) {
            arg = args.get(0);
        } else {
            throw new IllegalArgumentException("Too many arguments to function string");
        }
        return Coerce.toString(arg);
    }

    public static Object f_concat(Context context, List args) {
        if (args.size() < 2) {
            throw new IllegalArgumentException("Not enough arguments to function concat");
        }
        StringBuffer sb = new StringBuffer();
        Iterator it = args.iterator();
        while (it.hasNext()) {
            sb.append((String)it.next());
        }
        return sb.toString();
    }

    public static boolean f_starts_with(Context context, String s1, String s2) {
        return s1.startsWith(s2);
    }

    public static boolean f_contains(Context context, String s1, String s2) {
        return s1.indexOf(s2) != -1;
    }

    public static String f_substring_before(Context context, String s1, String s2) {
        int i = s1.indexOf(s2);
        if (i == -1) {
            return "";
        }
        return s1.substring(0, i);
    }

    public static String f_substring_after(Context context, String s1, String s2) {
        int i = s1.indexOf(s2);
        if (i == -1) {
            return "";
        }
        return s1.substring(i + s2.length());
    }

    public static String f_substring(Context context, List args) {
        if (args.size() < 2 || args.size() > 3) {
            throw new IllegalArgumentException("Bad number of arguments to function substring");
        }
        String s1 = (String)args.get(0);
        double n2 = Math.round(((Number)args.get(1)).doubleValue()) - 1L;
        int beginIndex = (int)n2;
        if (beginIndex < 0) {
            beginIndex = 0;
        }
        if (args.size() == 2) {
            return s1.substring(beginIndex);
        }
        double n3 = Math.round(((Number)args.get(2)).doubleValue());
        int endIndex = (int)(n2 + n3);
        if (endIndex < beginIndex) {
            endIndex = beginIndex;
        }
        if (endIndex > s1.length()) {
            endIndex = s1.length();
        }
        return s1.substring(beginIndex, endIndex);
    }

    public static int f_string_length(Context context) {
        return StandardLibrary.f_string_length(context, Coerce.stringValueOfNode(context.getNode()));
    }

    public static int f_string_length(Context context, String s) {
        return s.length();
    }

    public static String f_normalize_space(Context context) {
        return StandardLibrary.f_normalize_space(context, Coerce.stringValueOfNode(context.getNode()));
    }

    public static String f_normalize_space(Context context, String s) {
        StringBuffer sb = new StringBuffer(s.length());
        boolean gotSpace = true;
        int i = 0;
        while (i < s.length()) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (gotSpace) break;
                    sb.append(' ');
                    gotSpace = true;
                    break;
                }
                default: {
                    gotSpace = false;
                    sb.append(ch);
                }
            }
            ++i;
        }
        if (gotSpace && sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }

    public static String f_translate(Context context, String s1, String s2, String s3) {
        StringBuffer sb = new StringBuffer(s1.length());
        int i = 0;
        while (i < s1.length()) {
            char ch = s1.charAt(i);
            int x = s2.indexOf(ch);
            if (x < 0) {
                sb.append(ch);
            } else if (x < s3.length()) {
                sb.append(s3.charAt(x));
            }
            ++i;
        }
        return sb.toString();
    }

    public static Object f_boolean(Context context, List args) {
        return Coerce.toBoolean(args.get(0));
    }

    public static boolean f_true(Context context) {
        return true;
    }

    public static boolean f_false(Context context) {
        return false;
    }

    public static boolean f_not(Context context, boolean arg) {
        return !arg;
    }

    public static boolean f_lang(Context context, String s1) {
        String lang = "";
        Node n = context.getNode();
        while (n != null) {
            Element e;
            if (n.getNodeType() == 1 && !"".equals(lang = (e = (Element)n).getAttributeNS("http://www.w3.org/XML/1998/namespace", "lang"))) break;
            n = StandardLibrary.parent(n);
        }
        if (lang.equalsIgnoreCase(s1)) {
            return true;
        }
        return lang.length() > s1.length() && lang.substring(0, s1.length() + 1).equalsIgnoreCase(s1 + "-");
    }

    public static Object f_number(Context context, List args) {
        Object arg;
        if (args.size() == 0) {
            NodeSet ns = new NodeSet();
            ns.add(context.getNode());
            arg = ns;
        } else if (args.size() == 1) {
            arg = args.get(0);
        } else {
            throw new IllegalArgumentException("Too many arguments to function number");
        }
        return Coerce.toNumber(arg);
    }

    public static double f_sum(Context context, NodeSet ns) {
        Iterator it = ns.iterator();
        double s = 0.0;
        while (it.hasNext()) {
            Node n = (Node)it.next();
            s += Coerce.toNumber(Coerce.stringValueOfNode(n)).doubleValue();
        }
        return s;
    }

    public static double f_floor(Context context, double arg) {
        return Math.floor(arg);
    }

    public static double f_ceiling(Context context, double arg) {
        return Math.ceil(arg);
    }

    public static double f_round(Context context, double arg) {
        return Math.round(arg);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        Method[] methods = (class$com$nanobiz$xpath$StandardLibrary == null ? (class$com$nanobiz$xpath$StandardLibrary = StandardLibrary.class$("com.nanobiz.xpath.StandardLibrary")) : class$com$nanobiz$xpath$StandardLibrary).getMethods();
        functions = new HashMap(methods.length);
        int i = 0;
        while (i < methods.length) {
            String funcName;
            String name = methods[i].getName();
            if (name.startsWith("f_") && functions.get(funcName = name.substring(2).replace('_', '-')) == null) {
                functions.put(funcName, new FunctionImpl(funcName, name));
            }
            ++i;
        }
    }

    static class FunctionImpl
    implements Function {
        static final Class[] generalArgTypes = new Class[]{class$com$nanobiz$xpath$Context == null ? (class$com$nanobiz$xpath$Context = StandardLibrary.class$("com.nanobiz.xpath.Context")) : class$com$nanobiz$xpath$Context, class$java$util$List == null ? (class$java$util$List = StandardLibrary.class$("java.util.List")) : class$java$util$List};
        String funcName;
        String methodName;
        Method varMethod;

        FunctionImpl(String funcName, String methodName) {
            this.funcName = funcName;
            this.methodName = methodName;
            this.varMethod = null;
        }

        public Object evaluate(Context context, List args) {
            Method method = null;
            try {
                try {
                    if (this.varMethod == null) {
                        this.varMethod = method = (class$com$nanobiz$xpath$StandardLibrary == null ? (class$com$nanobiz$xpath$StandardLibrary = StandardLibrary.class$("com.nanobiz.xpath.StandardLibrary")) : class$com$nanobiz$xpath$StandardLibrary).getMethod(this.methodName, generalArgTypes);
                    } else {
                        method = this.varMethod;
                    }
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (method != null) {
                    try {
                        return method.invoke(null, context, args);
                    }
                    catch (InvocationTargetException ex) {
                        throw (RuntimeException)ex.getTargetException();
                    }
                }
                Class[] argtypes = new Class[args.size() + 1];
                Object[] argv = new Object[args.size() + 1];
                argtypes[0] = class$com$nanobiz$xpath$Context == null ? (class$com$nanobiz$xpath$Context = StandardLibrary.class$("com.nanobiz.xpath.Context")) : class$com$nanobiz$xpath$Context;
                argv[0] = context;
                int i = 0;
                while (i < args.size()) {
                    Object arg = args.get(i);
                    if (arg instanceof String) {
                        argtypes[i + 1] = class$java$lang$String == null ? StandardLibrary.class$("java.lang.String") : class$java$lang$String;
                        argv[i + 1] = arg;
                    } else if (arg instanceof Number) {
                        argtypes[i + 1] = Double.TYPE;
                        argv[i + 1] = arg instanceof Double ? arg : new Double(((Number)arg).doubleValue());
                    } else if (arg instanceof Boolean) {
                        argtypes[i + 1] = Boolean.TYPE;
                        argv[i + 1] = arg;
                    } else if (arg instanceof NodeSet) {
                        argtypes[i + 1] = class$com$nanobiz$xpath$util$NodeSet == null ? StandardLibrary.class$("com.nanobiz.xpath.util.NodeSet") : class$com$nanobiz$xpath$util$NodeSet;
                        argv[i + 1] = arg;
                    }
                    ++i;
                }
                try {
                    method = (class$com$nanobiz$xpath$StandardLibrary == null ? (class$com$nanobiz$xpath$StandardLibrary = StandardLibrary.class$("com.nanobiz.xpath.StandardLibrary")) : class$com$nanobiz$xpath$StandardLibrary).getMethod(this.methodName, argtypes);
                }
                catch (Exception ex) {
                    // empty catch block
                }
                if (method != null) {
                    try {
                        return method.invoke(null, argv);
                    }
                    catch (InvocationTargetException ex) {
                        throw (RuntimeException)ex.getTargetException();
                    }
                }
                Method[] methods = (class$com$nanobiz$xpath$StandardLibrary == null ? (class$com$nanobiz$xpath$StandardLibrary = StandardLibrary.class$("com.nanobiz.xpath.StandardLibrary")) : class$com$nanobiz$xpath$StandardLibrary).getMethods();
                Class<?>[] paramTypes = null;
                i = 0;
                while (i < methods.length) {
                    if (methods[i].getName().equals(this.methodName) && (paramTypes = methods[i].getParameterTypes()).length == argv.length) {
                        method = methods[i];
                        break;
                    }
                    ++i;
                }
                if (method != null) {
                    i = 1;
                    while (i < paramTypes.length) {
                        if (paramTypes[i] == (class$java$lang$String == null ? StandardLibrary.class$("java.lang.String") : class$java$lang$String)) {
                            argv[i] = Coerce.toString(argv[i]);
                        } else if (paramTypes[i] == Double.TYPE) {
                            argv[i] = new Double(Coerce.toNumber(argv[i]).doubleValue());
                        } else if (paramTypes[i] == Boolean.TYPE) {
                            argv[i] = Coerce.toBoolean(argv[i]);
                        }
                        ++i;
                    }
                    try {
                        return method.invoke(null, argv);
                    }
                    catch (InvocationTargetException ex) {
                        throw (RuntimeException)ex.getTargetException();
                    }
                }
                throw new IllegalArgumentException("Incorrect argument list for function " + this.funcName);
            }
            catch (IllegalAccessException ex) {
                throw new RuntimeException("huh?: " + ex.toString());
            }
        }
    }
}

