/*
 * Decompiled with CFR 0.152.
 */
package com.nanobiz.xml.schema.validator;

import com.nanobiz.xml.schema.AttributeDeclaration;
import com.nanobiz.xml.schema.AttributeGroup;
import com.nanobiz.xml.schema.ComplexType;
import com.nanobiz.xml.schema.DOMOperations;
import com.nanobiz.xml.schema.ElementDeclaration;
import com.nanobiz.xml.schema.Particle;
import com.nanobiz.xml.schema.Schema;
import com.nanobiz.xml.schema.SchemaConstants;
import com.nanobiz.xml.schema.SchemaErrorListener;
import com.nanobiz.xml.schema.SchemaException;
import com.nanobiz.xml.schema.SimpleType;
import com.nanobiz.xml.schema.Term;
import com.nanobiz.xml.schema.Type;
import com.nanobiz.xml.schema.Wildcard;
import com.nanobiz.xml.schema.validator.ContentModelNFA;
import com.nanobiz.xml.schema.validator.Validator;
import java.util.Iterator;
import org.w3c.dom.Attr;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

class ValidatorImpl
implements Validator,
SchemaConstants {
    Schema schema;
    SchemaErrorListener sel;
    static DOMOperations ops = new DOMOperations();

    ValidatorImpl(Schema schema, SchemaErrorListener sel) {
        this.schema = schema;
        this.sel = sel;
    }

    void carp(SchemaException ex) {
        this.sel.schemaError(ex);
    }

    void carp(String rule) {
        this.carp(new SchemaException(rule));
    }

    void carp(String rule, Object o1) {
        this.carp(new SchemaException(rule, new Object[]{o1}));
    }

    void carp(String rule, Object o1, Object o2) {
        this.carp(new SchemaException(rule, new Object[]{o1, o2}));
    }

    void carp(String rule, Object o1, Object o2, Object o3) {
        this.carp(new SchemaException(rule, new Object[]{o1, o2, o3}));
    }

    public void validateDocument(Document doc) {
        Element elt = doc.getDocumentElement();
        this.validateElementAsGlobal(elt, (short)1);
    }

    public boolean isEmpty(Element elt) {
        Node subnode = elt.getFirstChild();
        while (subnode != null) {
            switch (subnode.getNodeType()) {
                case 1: 
                case 3: 
                case 4: {
                    return false;
                }
            }
            subnode = subnode.getNextSibling();
        }
        return true;
    }

    public boolean hasNoCharacterContent(Element elt) {
        Node subnode = elt.getFirstChild();
        while (subnode != null) {
            switch (subnode.getNodeType()) {
                case 3: 
                case 4: {
                    CharacterData cd = (CharacterData)subnode;
                    String s = cd.getData();
                    if ("".equals(s.trim())) break;
                    return false;
                }
            }
            subnode = subnode.getNextSibling();
        }
        return true;
    }

    public boolean hasNoElementContent(Element elt) {
        Node subnode = elt.getFirstChild();
        while (subnode != null) {
            switch (subnode.getNodeType()) {
                case 1: {
                    return false;
                }
            }
            subnode = subnode.getNextSibling();
        }
        return true;
    }

    static boolean streq(String s1, String s2) {
        return s1 == null ? s2 == null : s1.equals(s2);
    }

    public boolean isTypeDerivationOK(Type base, Type derived, Short prohibitedSubstitutions) {
        return true;
    }

    public Type getXsiType(Element elt) {
        Attr attr = elt.getAttributeNodeNS("type", this.schema.getSchemaInstanceNamespace());
        if (attr == null) {
            return null;
        }
        String typeName = attr.getNodeValue();
        String prefix = ops.getPrefix(typeName);
        String localName = ops.getLocalName(typeName);
        String namespaceURI = ops.resolvePrefix(prefix, elt);
        return this.schema.getType(namespaceURI, localName);
    }

    public void validateElementAsGlobal(Element elt, short processContents) {
        switch (processContents) {
            case 2: {
                return;
            }
            case 1: {
                ElementDeclaration decl = this.schema.getElement(ops.getNamespaceURI(elt), ops.getLocalName(elt));
                this.validateElementAsDecl(elt, decl);
                return;
            }
            case 3: {
                ElementDeclaration decl = this.schema.getElement(ops.getNamespaceURI(elt), ops.getLocalName(elt));
                if (decl != null) {
                    this.validateElementAsDecl(elt, decl);
                } else {
                    this.validateElementAsType(elt, this.schema.getType(this.schema.getSchemaNamespace(), "anyType"));
                }
                return;
            }
        }
        throw new RuntimeException();
    }

    public void validateElementAsDecl(Element elt, ElementDeclaration eltdecl) {
        if (eltdecl == null) {
            this.carp("cvc-elt.1.1", elt.getNodeName());
            StringBuffer sb = new StringBuffer();
            Iterator it = this.schema.getAllElements();
            while (it.hasNext()) {
                ElementDeclaration ed = (ElementDeclaration)it.next();
                if (!ops.getLocalName(elt).equalsIgnoreCase(ed.getLocalName())) continue;
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append(ed.getNamespaceURI());
                sb.append(':');
                sb.append(ed.getLocalName());
            }
            if (sb.length() > 0) {
                this.carp("cvc-elt.1.1.x", elt.getNodeName(), sb.toString());
            }
            return;
        }
        Type localType = this.getXsiType(elt);
        Type actualType = eltdecl.getTypeDefinition();
        if (localType != null) {
            actualType = localType;
        }
        this.validateElementAsType(elt, actualType);
    }

    public void validateElementAsType(Element elt, Type type) {
        if (type == null) {
            this.carp("cvc-type.1.1", elt, type);
            return;
        }
        if (!type.isComplexType()) {
            NamedNodeMap nm = elt.getAttributes();
            int i = 0;
            while (i < nm.getLength()) {
                Attr attr = (Attr)nm.item(i);
                String namespaceURI = ops.getNamespaceURI(attr);
                if (!ValidatorImpl.streq(namespaceURI, "http://www.w3.org/2000/xmlns") && !ValidatorImpl.streq(namespaceURI, this.schema.getSchemaInstanceNamespace())) {
                    this.carp("cvc-type.1.2.1.1", elt, type, attr);
                    break;
                }
                ++i;
            }
            if (!this.hasNoElementContent(elt)) {
                this.carp("cvc-type.1.2.1.2", elt, type);
            }
            if (!this.validateStringAsType(ops.stringValueOfNode(elt), (SimpleType)type)) {
                this.carp("cvc-type.1.2.1.3", elt, type);
            }
        } else {
            this.validateElementAsComplexType(elt, (ComplexType)type);
        }
    }

    public boolean validateElementAsComplexType(Element elt, ComplexType type) {
        boolean rv = true;
        if (type.isAbstract()) {
            this.carp("cvc-complex-type.1.1", elt, type);
            rv = false;
        }
        switch (type.getContentMode()) {
            case 1: {
                if (this.isEmpty(elt)) break;
                this.carp("cvc-complex-type.1.2.1", elt, type);
                rv = false;
                break;
            }
            case 2: {
                if (this.hasNoElementContent(elt) && this.validateStringAsType(ops.stringValueOfNode(elt), type.getSimpleContentType())) break;
                this.carp("cvc-complex-type.1.2.2", elt, type);
                rv = false;
                break;
            }
            case 3: {
                if (!this.hasNoCharacterContent(elt)) {
                    this.carp("cvc-complex-type.1.2.3", elt, type);
                    rv = false;
                }
            }
            case 4: {
                this.validateElementSequenceAsParticle(elt, type.getContentParticle());
            }
        }
        NamedNodeMap nm = elt.getAttributes();
        AttributeGroup ag = type.getAttributes();
        int l = nm.getLength();
        Attr[] attrs = new Attr[l];
        int i = 0;
        while (i < l) {
            attrs[i] = (Attr)nm.item(i);
            ++i;
        }
        l = ag.getLength();
        AttributeDeclaration[] decls = new AttributeDeclaration[l];
        boolean[] req = new boolean[l];
        int nreq = 0;
        int nreqfound = 0;
        i = 0;
        while (i < l) {
            decls[i] = ag.getItem(i);
            req[i] = ag.isItemRequired(i);
            if (req[i]) {
                ++nreq;
            }
            ++i;
        }
        Wildcard awc = ag.getWildcard();
        i = 0;
        while (i < attrs.length) {
            String namespaceURI = ops.getNamespaceURI(attrs[i]);
            String localName = ops.getLocalName(attrs[i]);
            if (!ValidatorImpl.streq(namespaceURI, "http://www.w3.org/2000/xmlns") && !ValidatorImpl.streq(namespaceURI, this.schema.getSchemaInstanceNamespace())) {
                int j = 0;
                while (j < decls.length) {
                    if (ValidatorImpl.streq(namespaceURI, decls[j].getNamespaceURI()) && ValidatorImpl.streq(localName, decls[j].getLocalName())) {
                        this.validateAttributeAsDecl(attrs[i], decls[j]);
                        if (!req[j]) break;
                        ++nreqfound;
                        req[j] = false;
                        break;
                    }
                    ++j;
                }
                if (j == decls.length) {
                    boolean ok = false;
                    if (awc != null) {
                        switch (awc.getNamespaceConstraintMode()) {
                            case 1: {
                                ok = true;
                                break;
                            }
                            case 2: {
                                ok = !ValidatorImpl.streq(namespaceURI, awc.getNotNamespaceURI());
                                break;
                            }
                            case 3: {
                                ok = awc.getNamespaceSet().contains(namespaceURI);
                                break;
                            }
                            default: {
                                throw new RuntimeException();
                            }
                        }
                    }
                    if (ok) {
                        this.validateAttributeAsGlobal(attrs[i], awc.getProcessContentsMode());
                    } else {
                        this.carp("cvc-complex-type.1.3", elt, type, attrs[i]);
                        rv = false;
                    }
                }
            }
            ++i;
        }
        if (nreqfound < nreq) {
            rv = false;
            i = 0;
            while (nreq > 0) {
                if (req[i]) {
                    String ns = decls[i].getNamespaceURI();
                    String name = ns == null ? decls[i].getLocalName() : ops.reverseResolvePrefix(ns, elt) + ":" + decls[i].getLocalName();
                    this.carp("cvc-complex-type.1.4", elt, type, name);
                    --nreq;
                }
                ++i;
            }
        }
        return rv;
    }

    boolean validateElementSequenceAsParticle(Element parent, Particle part) {
        ContentModelNFA.Traverser tr = new ContentModelNFA().modelParticle(part).createTraverser();
        int index = 0;
        Element elt = ops.firstElementChild(parent);
        while (elt != null) {
            Term term = tr.followConsumingTransition(ops.getNamespaceURI(elt), ops.getLocalName(elt));
            if (term == null) {
                this.carp("cvc-particle.x.1", parent, elt, new Integer(index));
                return false;
            }
            switch (term.getTermType()) {
                case 3: {
                    this.validateElementAsDecl(elt, (ElementDeclaration)term);
                    break;
                }
                case 2: {
                    Wildcard wc = (Wildcard)term;
                    this.validateElementAsGlobal(elt, wc.getProcessContentsMode());
                    break;
                }
                default: {
                    throw new RuntimeException();
                }
            }
            elt = ops.nextElementSibling(elt);
            ++index;
        }
        if (!tr.isFinished()) {
            this.carp("cvc-particle.x.2", parent);
            return false;
        }
        return true;
    }

    boolean validateAttributeAsGlobal(Attr attr, short processContents) {
        boolean rv = true;
        switch (processContents) {
            case 2: {
                break;
            }
            case 1: {
                AttributeDeclaration decl = this.schema.getAttribute(ops.getNamespaceURI(attr), ops.getLocalName(attr));
                if (this.validateAttributeAsDecl(attr, decl)) break;
                rv = false;
                break;
            }
            case 3: {
                AttributeDeclaration decl = this.schema.getAttribute(ops.getNamespaceURI(attr), ops.getLocalName(attr));
                if (decl == null || this.validateAttributeAsDecl(attr, decl)) break;
                rv = false;
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        return rv;
    }

    boolean validateAttributeAsDecl(Attr attr, AttributeDeclaration decl) {
        boolean rv = true;
        if (decl == null) {
            this.carp("cvc-attribute.1.1", attr);
            return false;
        }
        if (!this.validateStringAsType(attr.getNodeValue(), decl.getTypeDefinition())) {
            this.carp("cvc-attribute.1.2", attr, decl.getTypeDefinition());
            rv = false;
        }
        if (decl.getValueConstraintMode() == 3 && !attr.getNodeValue().equals(decl.getValueConstraintValue())) {
            this.carp("cvc-attribute.1.3", attr);
            rv = false;
        }
        return rv;
    }

    boolean validateStringAsType(String str, SimpleType type) {
        try {
            type.valueOf(str);
            return true;
        }
        catch (SchemaException ex) {
            this.sel.schemaError(ex);
            this.carp("cvc-simple-type", str, type, ex.getMessage());
            return false;
        }
        catch (Exception ex) {
            this.carp("cvc-simple-type", str, type, ex.getMessage());
            return false;
        }
    }
}

