/*
 * Decompiled with CFR 0.152.
 */
package com.nanobiz.xml.schema.validator;

import com.nanobiz.xml.schema.ElementDeclaration;
import com.nanobiz.xml.schema.ModelGroup;
import com.nanobiz.xml.schema.Particle;
import com.nanobiz.xml.schema.SchemaConstants;
import com.nanobiz.xml.schema.Term;
import com.nanobiz.xml.schema.Wildcard;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class ContentModelNFA
implements SchemaConstants {
    ArrayList vertices = new ArrayList();
    ArrayList consumingTransitions = new ArrayList();

    static boolean streq(String s1, String s2) {
        return s1 == null ? s2 == null : s1.equals(s2);
    }

    static Term termMatchesName(Term term, String namespaceURI, String localName) {
        switch (term.getTermType()) {
            case 3: {
                ElementDeclaration decl = (ElementDeclaration)term;
                if (ContentModelNFA.streq(namespaceURI, decl.getNamespaceURI()) && ContentModelNFA.streq(localName, decl.getLocalName())) {
                    return decl;
                }
                Iterator it = decl.getSubstitutionGroupMembers().iterator();
                while (it.hasNext()) {
                    decl = (ElementDeclaration)it.next();
                    if (!ContentModelNFA.streq(namespaceURI, decl.getNamespaceURI()) || !ContentModelNFA.streq(localName, decl.getLocalName())) continue;
                    return decl;
                }
                return null;
            }
            case 2: {
                Wildcard wc = (Wildcard)term;
                switch (wc.getNamespaceConstraintMode()) {
                    case 1: {
                        return wc;
                    }
                    case 2: {
                        return !ContentModelNFA.streq(namespaceURI, wc.getNotNamespaceURI()) ? wc : null;
                    }
                    case 3: {
                        return wc.getNamespaceSet().contains(namespaceURI) ? wc : null;
                    }
                }
                throw new RuntimeException();
            }
            case 1: {
                ModelGroup mg = (ModelGroup)term;
                if (mg.getCompositor() != 3) {
                    throw new RuntimeException();
                }
                int i = 0;
                while (i < mg.getLength()) {
                    Term st = ContentModelNFA.termMatchesName(mg.getItem(i).getTerm(), namespaceURI, localName);
                    if (st != null) {
                        return st;
                    }
                    ++i;
                }
                return null;
            }
        }
        throw new RuntimeException();
    }

    Vertex createVertex() {
        int id = this.vertices.size();
        Vertex v = new Vertex(this, id);
        this.vertices.add(v);
        return v;
    }

    Submachine createNullSubmachine() {
        Vertex v = this.createVertex();
        return new Submachine(v, v);
    }

    Submachine createSubmachine() {
        return new Submachine(this.createVertex(), this.createVertex());
    }

    Submachine modelAtomicTerm(Term t) {
        Submachine sm = this.createSubmachine();
        sm.start.createConsumingTransition(t, sm.finish);
        return sm;
    }

    Submachine modelSequence(ModelGroup mg) {
        if (mg.getLength() == 0) {
            return this.createNullSubmachine();
        }
        Submachine smSeq = this.modelParticle(mg.getItem(0));
        int i = 1;
        while (i < mg.getLength()) {
            Submachine smPart = this.modelParticle(mg.getItem(i));
            smSeq.finish.createEpsilonTransition(smPart.start);
            smSeq.finish = smPart.finish;
            ++i;
        }
        return smSeq;
    }

    Submachine modelChoice(ModelGroup mg) {
        if (mg.getLength() == 0) {
            return this.createNullSubmachine();
        }
        Submachine smChoice = this.createSubmachine();
        int i = 0;
        while (i < mg.getLength()) {
            Submachine smPart = this.modelParticle(mg.getItem(i));
            smChoice.start.createEpsilonTransition(smPart.start);
            smPart.finish.createEpsilonTransition(smChoice.finish);
            ++i;
        }
        return smChoice;
    }

    Submachine modelAll(ModelGroup mg) {
        return this.modelAtomicTerm(mg);
    }

    Submachine modelTerm(Term t) {
        switch (t.getTermType()) {
            case 2: 
            case 3: {
                return this.modelAtomicTerm(t);
            }
            case 1: {
                ModelGroup mg = (ModelGroup)t;
                switch (mg.getCompositor()) {
                    case 1: {
                        return this.modelSequence(mg);
                    }
                    case 2: {
                        return this.modelChoice(mg);
                    }
                    case 3: {
                        return this.modelAll(mg);
                    }
                }
                throw new RuntimeException();
            }
        }
        throw new RuntimeException();
    }

    Submachine modelParticle(Particle p) {
        int minOccurs = p.getMinOccurs();
        int maxOccurs = p.getMaxOccurs();
        if (maxOccurs == 0) {
            return this.createNullSubmachine();
        }
        if (minOccurs == 1 && maxOccurs == 1) {
            return this.modelTerm(p.getTerm());
        }
        Submachine smTerm = this.modelTerm(p.getTerm());
        Submachine smOuter = this.createSubmachine();
        int count = maxOccurs == -1 ? (minOccurs == 0 ? 1 : minOccurs) : maxOccurs;
        Submachine[] smPieces = smTerm.duplicate(count);
        int i = 1;
        while (i < count) {
            smPieces[i - 1].finish.createEpsilonTransition(smPieces[i].start);
            ++i;
        }
        if (minOccurs == 0) {
            smOuter.start.createEpsilonTransition(smOuter.finish);
            minOccurs = 1;
        }
        i = minOccurs;
        while (i < count) {
            smPieces[i].start.createEpsilonTransition(smPieces[count - 1].finish);
            ++i;
        }
        if (maxOccurs == -1) {
            smPieces[count - 1].finish.createEpsilonTransition(smPieces[count - 1].start);
        }
        smOuter.start.createEpsilonTransition(smPieces[0].start);
        smPieces[count - 1].finish.createEpsilonTransition(smOuter.finish);
        return smOuter;
    }

    public static class Traverser {
        Submachine sm;
        Set currentVertices = new HashSet();
        Vertex goal;
        List currentAll = null;

        Traverser() {
        }

        Traverser(Submachine sm) {
            this();
            this.sm = sm;
            this.currentVertices.add(sm.start);
            this.goal = sm.finish;
            this.followEpsilonTransitions();
        }

        void followEpsilonTransitions() {
            LinkedList<Vertex> q = new LinkedList<Vertex>(this.currentVertices);
            while (!q.isEmpty()) {
                Vertex v = (Vertex)q.remove(0);
                Iterator it = v.epsilonTransitions.iterator();
                while (it.hasNext()) {
                    Vertex vPrime = (Vertex)it.next();
                    if (!this.currentVertices.add(vPrime)) continue;
                    q.add(vPrime);
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        Term followConsumingTransition(String namespaceURI, String localName) {
            Term term = null;
            if (this.currentAll != null) {
                term = this.matchAll(namespaceURI, localName);
                if (term != null) return term;
                if (!this.canFinishAll()) return null;
                this.currentAll = null;
            }
            ArrayList lastVertices = new ArrayList(this.currentVertices);
            Iterator itv = lastVertices.iterator();
            this.currentVertices.clear();
            Transition rtx = null;
            while (itv.hasNext()) {
                Vertex v = (Vertex)itv.next();
                Iterator ittx = v.consumingTransitions.iterator();
                while (ittx.hasNext()) {
                    Transition tx = (Transition)ittx.next();
                    Term tt = ContentModelNFA.termMatchesName(tx.term, namespaceURI, localName);
                    if (tt == null || rtx != null && rtx != tx) continue;
                    rtx = tx;
                    term = tt;
                    this.currentVertices.add(tx.dest);
                }
            }
            this.followEpsilonTransitions();
            if (rtx == null) return null;
            if (rtx.term.getTermType() != 1) return term;
            this.initializeAll((ModelGroup)rtx.term);
            term = this.matchAll(namespaceURI, localName);
            if (term != null) return term;
            throw new RuntimeException();
        }

        void initializeAll(ModelGroup mg) {
            int l = mg.getLength();
            this.currentAll = new LinkedList();
            int i = 0;
            while (i < l) {
                this.currentAll.add(mg.getItem(i));
                ++i;
            }
        }

        Term matchAll(String namespaceURI, String localName) {
            if (this.currentAll == null) {
                return null;
            }
            Iterator it = this.currentAll.iterator();
            while (it.hasNext()) {
                Particle p = (Particle)it.next();
                Term t = p.getTerm();
                if ((t = ContentModelNFA.termMatchesName(t, namespaceURI, localName)) == null) continue;
                it.remove();
                return t;
            }
            return null;
        }

        boolean canFinishAll() {
            if (this.currentAll == null) {
                return true;
            }
            Iterator it = this.currentAll.iterator();
            while (it.hasNext()) {
                Particle p = (Particle)it.next();
                if (p.getMinOccurs() == 0) continue;
                return false;
            }
            return true;
        }

        public boolean isFinished() {
            return this.canFinishAll() && this.currentVertices.contains(this.goal);
        }
    }

    public static class Submachine {
        Vertex start;
        Vertex finish;

        Submachine() {
            this.start = null;
            this.finish = null;
        }

        Submachine(Vertex start, Vertex finish) {
            this.start = start;
            this.finish = finish;
        }

        Vertex[] getContents() {
            HashSet<Vertex> contents = new HashSet<Vertex>();
            LinkedList<Vertex> q = new LinkedList<Vertex>();
            q.add(this.start);
            contents.add(this.start);
            contents.add(this.finish);
            while (!q.isEmpty()) {
                Vertex v = (Vertex)q.remove(0);
                Iterator it = v.epsilonTransitions.iterator();
                while (it.hasNext()) {
                    Vertex vPrime = (Vertex)it.next();
                    if (!contents.add(vPrime)) continue;
                    q.add(vPrime);
                }
                it = v.consumingTransitions.iterator();
                while (it.hasNext()) {
                    Transition tx = (Transition)it.next();
                    Vertex vPrime = tx.dest;
                    if (!contents.add(vPrime)) continue;
                    q.add(vPrime);
                }
            }
            return contents.toArray(new Vertex[0]);
        }

        Submachine[] duplicate(int count) {
            ContentModelNFA nfa = this.start.nfa;
            Vertex[] oldContents = this.getContents();
            int l = oldContents.length;
            Vertex[] newContents = new Vertex[l];
            HashMap<Vertex, Vertex> map = new HashMap<Vertex, Vertex>();
            Submachine[] result = new Submachine[count];
            result[0] = this;
            int n = 1;
            while (n < count) {
                map.clear();
                int i = 0;
                while (i < l) {
                    newContents[i] = nfa.createVertex();
                    map.put(oldContents[i], newContents[i]);
                    ++i;
                }
                i = 0;
                while (i < l) {
                    Iterator it = oldContents[i].epsilonTransitions.iterator();
                    while (it.hasNext()) {
                        Vertex v = (Vertex)it.next();
                        newContents[i].createEpsilonTransition((Vertex)map.get(v));
                    }
                    it = oldContents[i].consumingTransitions.iterator();
                    while (it.hasNext()) {
                        Transition tx = (Transition)it.next();
                        newContents[i].createConsumingTransition(tx.term, (Vertex)map.get(tx.dest));
                    }
                    ++i;
                }
                Submachine sm = new Submachine();
                sm.start = (Vertex)map.get(this.start);
                sm.finish = (Vertex)map.get(this.finish);
                result[n] = sm;
                ++n;
            }
            return result;
        }

        public String toString() {
            Vertex[] contents = this.getContents();
            StringBuffer sb = new StringBuffer();
            sb.append("-- begin submachine: start " + this.start.id + ", finish " + this.finish.id + "\n");
            int i = 0;
            while (i < contents.length) {
                sb.append(contents[i].toString());
                sb.append("\n  --------\n");
                ++i;
            }
            sb.append("-- end submachine\n");
            return sb.toString();
        }

        public Traverser createTraverser() {
            return new Traverser(this);
        }
    }

    public static class Vertex {
        ContentModelNFA nfa;
        int id;
        ArrayList epsilonTransitions;
        ArrayList consumingTransitions;

        Vertex(ContentModelNFA nfa, int id) {
            this.nfa = nfa;
            this.id = id;
            this.epsilonTransitions = new ArrayList();
            this.consumingTransitions = new ArrayList();
        }

        void createEpsilonTransition(Vertex dest) {
            this.epsilonTransitions.add(dest);
        }

        void createConsumingTransition(Term term, Vertex dest) {
            Transition tx = new Transition(term, this, dest);
            this.consumingTransitions.add(tx);
            this.nfa.consumingTransitions.add(tx);
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("vertex id ");
            sb.append(this.id);
            sb.append(":\n");
            Iterator it = this.epsilonTransitions.iterator();
            while (it.hasNext()) {
                Vertex v = (Vertex)it.next();
                sb.append("epsilon -> ");
                sb.append(v.id);
                sb.append("\n");
            }
            it = this.consumingTransitions.iterator();
            while (it.hasNext()) {
                Transition tx = (Transition)it.next();
                switch (tx.term.getTermType()) {
                    case 3: {
                        ElementDeclaration ed = (ElementDeclaration)tx.term;
                        sb.append(ed.getNamespaceURI());
                        sb.append(":");
                        sb.append(ed.getLocalName());
                        break;
                    }
                    case 2: {
                        Wildcard wc = (Wildcard)tx.term;
                        switch (wc.getNamespaceConstraintMode()) {
                            case 1: {
                                sb.append("*");
                                break;
                            }
                            case 2: {
                                sb.append("[not ");
                                sb.append(wc.getNotNamespaceURI());
                                sb.append("]:*");
                                break;
                            }
                            case 3: {
                                sb.append(wc.getNamespaceSet().toString());
                                sb.append(":*");
                            }
                        }
                        break;
                    }
                }
                sb.append(" -> ");
                sb.append(tx.dest.id);
                sb.append("\n");
            }
            return sb.toString();
        }
    }

    public static class Transition {
        Term term;
        Vertex origin;
        Vertex dest;

        Transition(Term term, Vertex origin, Vertex dest) {
            this.term = term;
            this.origin = origin;
            this.dest = dest;
        }

        public int hashCode() {
            return this.term.hashCode() ^ this.origin.hashCode() ^ this.dest.hashCode();
        }

        public boolean equals(Object ob) {
            if (ob instanceof Transition) {
                Transition tx = (Transition)ob;
                return this.term.equals(tx.term) && this.origin.equals(tx.origin) && this.dest.equals(tx.dest);
            }
            return false;
        }
    }
}

