/*
 * Decompiled with CFR 0.152.
 */
package com.nanobiz.xml.schema.loader;

import com.nanobiz.xml.schema.Term;
import com.nanobiz.xml.schema.Wildcard;
import com.nanobiz.xml.schema.loader.SchemaComponentBase;
import com.nanobiz.xml.schema.loader.SchemaImpl;
import java.util.HashSet;
import java.util.Set;
import java.util.StringTokenizer;
import org.w3c.dom.Element;

class WildcardImpl
extends SchemaComponentBase
implements Wildcard,
Term {
    private short processContentsMode;
    private short namespaceConstraintMode;
    private String notNamespaceURI;
    private HashSet namespaceSet;

    WildcardImpl(Element declaration, SchemaImpl schema) {
        super(declaration, schema);
    }

    WildcardImpl(SchemaImpl schema) {
        super(null, schema);
        this.processContentsMode = (short)3;
        this.namespaceConstraintMode = 1;
    }

    public short getProcessContentsMode() {
        return this.processContentsMode;
    }

    public short getNamespaceConstraintMode() {
        return this.namespaceConstraintMode;
    }

    public String getNotNamespaceURI() {
        return this.notNamespaceURI;
    }

    public Set getNamespaceSet() {
        return this.namespaceSet;
    }

    public short getTermType() {
        return 2;
    }

    void readDefinition() {
        String attr = this.declaration.getAttribute("processContents");
        this.processContentsMode = attr.equals("skip") ? (short)2 : (attr.equals("lax") ? (short)3 : (short)1);
        String targetNamespace = this.schema.getSchemaAttribute(this.declaration, "targetNamespace");
        attr = this.declaration.getAttribute("namespace");
        if (attr.equals("##any") || attr.length() == 0) {
            this.namespaceConstraintMode = 1;
        } else if (attr.equals("##other")) {
            this.namespaceConstraintMode = (short)2;
            this.notNamespaceURI = targetNamespace;
        } else {
            this.namespaceConstraintMode = (short)3;
            this.namespaceSet = new HashSet();
            StringTokenizer tokens = new StringTokenizer(attr, " \t\n\r");
            while (tokens.hasMoreTokens()) {
                String uri = tokens.nextToken();
                if (uri.equals("##targetNamespace")) {
                    uri = targetNamespace;
                } else if (uri.equals("##local")) {
                    uri = null;
                }
                this.namespaceSet.add(uri);
            }
        }
    }

    void intersectNamespaceConstraint(Wildcard otherWildcard) {
        WildcardImpl other = (WildcardImpl)otherWildcard;
        if (this.namespaceConstraintMode == other.namespaceConstraintMode) {
            switch (this.namespaceConstraintMode) {
                case 1: {
                    return;
                }
                case 3: {
                    this.namespaceSet.removeAll(other.namespaceSet);
                    return;
                }
                case 2: {
                    if (this.notNamespaceURI.equals(other.notNamespaceURI)) {
                        return;
                    }
                    this.error(null, "cannot intersect two ##other namespaces: " + this.notNamespaceURI + ' ' + other.notNamespaceURI);
                }
            }
        }
        if (other.namespaceConstraintMode == 1) {
            return;
        }
        if (this.namespaceConstraintMode == 1) {
            this.namespaceConstraintMode = other.namespaceConstraintMode;
            this.notNamespaceURI = other.notNamespaceURI;
            this.namespaceSet = other.namespaceSet;
            return;
        }
        if (this.namespaceConstraintMode == 3 && other.namespaceConstraintMode == 2) {
            this.namespaceSet.remove(other.notNamespaceURI);
            return;
        }
        if (other.namespaceConstraintMode == 3 && this.namespaceConstraintMode == 2) {
            this.namespaceConstraintMode = (short)3;
            this.namespaceSet = new HashSet();
            this.namespaceSet.addAll(other.namespaceSet);
            this.namespaceSet.remove(this.notNamespaceURI);
            this.notNamespaceURI = null;
            return;
        }
        this.error(null, "cannot intersect namespace constraints: " + this.namespaceConstraintMode + ' ' + other.namespaceConstraintMode);
    }
}

