/*
 * Decompiled with CFR 0.152.
 */
package com.nanobiz.xml.schema.loader;

import com.nanobiz.xml.schema.datatype.BinaryValue;
import com.nanobiz.xml.schema.datatype.RecurringDuration;
import com.nanobiz.xml.schema.datatype.TimeDuration;
import com.nanobiz.xml.schema.loader.MyBigDecimal;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringBufferInputStream;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.List;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

class ValueType {
    static final ValueType STRING = new t_string();
    static final ValueType BOOLEAN = new t_boolean();
    static final ValueType FLOAT = new t_float();
    static final ValueType DOUBLE = new t_double();
    static final ValueType DECIMAL = new t_decimal();
    static final ValueType INTEGER = new t_integer();
    static final ValueType BINARY_HEX = new t_binary_hex();
    static final ValueType BINARY_BASE64 = new t_binary_base64();
    static final ValueType LIST = new t_list();
    static final ValueType URI_REFERENCE = new t_string();
    static final ValueType NCNAME = new t_string();
    static final ValueType QNAME = new t_string();
    static final ValueType NMTOKEN = new t_string();
    static final ValueType NAME = new t_string();
    static final ValueType TIME_DURATION = new t_time_duration();
    static final ValueType TIME_INSTANT = new t_recurring_duration(TimeDuration.ZERO, TimeDuration.ZERO);
    static final ValueType TIME = new t_recurring_duration(TimeDuration.DAY, TimeDuration.ZERO);
    static final ValueType DATE = new t_recurring_duration(TimeDuration.ZERO, TimeDuration.DAY);
    static final ValueType MONTH = new t_recurring_duration(TimeDuration.ZERO, TimeDuration.MONTH);
    static final ValueType YEAR = new t_recurring_duration(TimeDuration.ZERO, TimeDuration.YEAR);
    static final ValueType CENTURY = new t_recurring_duration(TimeDuration.ZERO, TimeDuration.CENTURY);
    static final ValueType RECURRING_DATE = new t_recurring_duration(TimeDuration.YEAR, TimeDuration.DAY);
    static final ValueType RECURRING_DAY = new t_recurring_duration(TimeDuration.MONTH, TimeDuration.DAY);
    static final ValueType RECURRING_MONTH = new t_recurring_duration(TimeDuration.YEAR, TimeDuration.MONTH);

    ValueType() {
    }

    Object valueOf(String data) throws Exception {
        return null;
    }

    String toString(Object value) throws ClassCastException {
        return value.toString();
    }

    long length(Object value) throws ClassCastException {
        return 0L;
    }

    int getScale(Object value) throws ClassCastException {
        return 0;
    }

    boolean exceedsPrecision(Object value, BigInteger maxExclusive) throws ClassCastException {
        return false;
    }

    private static class t_recurring_duration
    extends ValueType {
        private TimeDuration period;
        private TimeDuration duration;

        t_recurring_duration(TimeDuration period, TimeDuration duration) {
            this.period = period;
            this.duration = duration;
        }

        Object valueOf(String data) throws Exception {
            return new RecurringDuration(data, this.period, this.duration);
        }
    }

    private static class t_time_duration
    extends ValueType {
        private t_time_duration() {
        }

        Object valueOf(String data) throws Exception {
            return new TimeDuration(data);
        }
    }

    private static class t_list
    extends ValueType {
        private t_list() {
        }

        long length(Object value) {
            return ((List)value).size();
        }
    }

    private static class t_binary_base64
    extends t_binary_base {
        public static BASE64Encoder encoder64 = null;
        public static BASE64Decoder decoder64 = null;

        private t_binary_base64() {
        }

        Object valueOf(String data) throws Exception {
            if (decoder64 == null) {
                decoder64 = new BASE64Decoder();
            }
            StringBufferInputStream is = new StringBufferInputStream(data);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            decoder64.decodeBuffer((InputStream)is, (OutputStream)baos);
            return new BinaryValue(baos.toByteArray());
        }

        String toString(Object value) {
            if (encoder64 == null) {
                encoder64 = new BASE64Encoder();
            }
            return encoder64.encode(((BinaryValue)value).getValue());
        }
    }

    private static class t_binary_hex
    extends t_binary_base {
        private t_binary_hex() {
        }

        Object valueOf(String data) throws Exception {
            int len = data.length();
            if (len % 2 != 0) {
                throw new Exception("hex length must be even");
            }
            byte[] val = new byte[len / 2];
            int i = 0;
            while (i < len) {
                int c1 = data.charAt(i);
                if (c1 >= 48 && c1 <= 57) {
                    c1 -= 48;
                } else if (c1 >= 97 && c1 <= 102) {
                    c1 = c1 - 97 + 10;
                } else if (c1 >= 65 && c1 <= 70) {
                    c1 = c1 - 65 + 10;
                } else {
                    throw new Exception("invalid hex digit: " + c1);
                }
                int c2 = data.charAt(i + 1);
                if (c2 >= 48 && c2 <= 57) {
                    c2 -= 48;
                } else if (c2 >= 97 && c2 <= 102) {
                    c2 = c2 - 97 + 10;
                } else if (c2 >= 65 && c2 <= 70) {
                    c2 = c2 - 65 + 10;
                } else {
                    throw new Exception("invalid hex digit: " + c2);
                }
                val[i / 2] = (byte)(c1 << 4 | c2);
                i += 2;
            }
            return new BinaryValue(val);
        }

        String toString(Object value) {
            byte[] val = ((BinaryValue)value).getValue();
            char[] chars = new char[val.length * 2];
            int i = 0;
            while (i < chars.length) {
                int c2 = val[i / 2];
                int c1 = c2 >> 4 & 0xF;
                c2 &= 0xF;
                c1 = c1 < 10 ? 48 + c1 : 65 + (c1 - 10);
                c2 = c2 < 10 ? 48 + c2 : 65 + (c2 - 10);
                chars[i] = (char)c1;
                chars[i + 1] = (char)c2;
                i += 2;
            }
            return new String(chars);
        }
    }

    private static class t_binary_base
    extends ValueType {
        private t_binary_base() {
        }

        long length(Object value) {
            return ((BinaryValue)value).getValue().length;
        }
    }

    private static class t_integer
    extends ValueType {
        private t_integer() {
        }

        Object valueOf(String data) throws Exception {
            return new BigInteger(data);
        }

        boolean exceedsPrecision(Object value, BigInteger maxExclusive) {
            BigInteger absValue = ((BigInteger)value).abs();
            return maxExclusive.compareTo(absValue) <= 0;
        }
    }

    private static class t_decimal
    extends ValueType {
        private t_decimal() {
        }

        Object valueOf(String data) throws Exception {
            return new MyBigDecimal(data);
        }

        int getScale(Object value) {
            return ((BigDecimal)value).scale();
        }

        boolean exceedsPrecision(Object value, BigInteger maxExclusive) {
            BigInteger absValue = ((BigDecimal)value).unscaledValue().abs();
            return maxExclusive.compareTo(absValue) <= 0;
        }
    }

    private static class t_double
    extends ValueType {
        private t_double() {
        }

        Object valueOf(String data) throws Exception {
            return Double.valueOf(data);
        }
    }

    private static class t_float
    extends ValueType {
        private t_float() {
        }

        Object valueOf(String data) throws Exception {
            return Float.valueOf(data);
        }
    }

    private static class t_boolean
    extends ValueType {
        private static final String TRUE_STRING = "true";
        private static final String FALSE_STRING = "false";

        private t_boolean() {
        }

        Object valueOf(String data) throws Exception {
            if (TRUE_STRING.equals(data)) {
                return Boolean.TRUE;
            }
            if (FALSE_STRING.equals(data)) {
                return Boolean.FALSE;
            }
            throw new Exception("boolean must be true or false");
        }

        String toString(Object value) {
            return (Boolean)value != false ? TRUE_STRING : FALSE_STRING;
        }

        static {
            TRUE_STRING = TRUE_STRING;
            FALSE_STRING = FALSE_STRING;
        }
    }

    private static class t_string
    extends ValueType {
        private t_string() {
        }

        Object valueOf(String data) throws Exception {
            return data;
        }

        long length(Object value) {
            return ((String)value).length();
        }
    }
}

