/*
 * Decompiled with CFR 0.152.
 */
package com.nanobiz.xml.schema.loader;

import com.nanobiz.xml.schema.Facet;
import com.nanobiz.xml.schema.SimpleType;
import com.nanobiz.xml.schema.Type;
import com.nanobiz.xml.schema.loader.AnyTypeImpl;
import com.nanobiz.xml.schema.loader.FacetImpl;
import com.nanobiz.xml.schema.loader.SchemaComponentBase;
import com.nanobiz.xml.schema.loader.SchemaImpl;
import com.nanobiz.xml.schema.loader.TypeImpl;
import com.nanobiz.xml.schema.loader.ValueType;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import org.w3c.dom.Element;

class SimpleTypeImpl
extends TypeImpl
implements SimpleType {
    private short variety;
    private boolean isOrdered;
    private boolean isBounded;
    private boolean isNumeric;
    private short cardinality;
    private SimpleTypeImpl primitiveType;
    private SimpleTypeImpl itemType;
    private SimpleTypeImpl[] memberTypes;
    private ValueType valueType;
    private List facets;

    SimpleTypeImpl(Element declaration, String namespaceURI, String localName, SchemaImpl schema) {
        super(declaration, namespaceURI, localName, schema);
    }

    SimpleTypeImpl(SchemaImpl schema) {
        super(null, null, null, schema);
    }

    SimpleTypeImpl(String namespaceURI, String localName, SchemaImpl schema, short variety, String baseOrItemTypeName, ValueType valueType, Facet[] facets, boolean isOrdered, boolean isBounded, short cardinality, boolean isNumeric) {
        super(null, namespaceURI, localName, schema);
        this.variety = variety;
        this.valueType = valueType;
        this.isOrdered = isOrdered;
        this.isBounded = isBounded;
        this.cardinality = cardinality;
        this.isNumeric = isNumeric;
        if (facets != null) {
            this.facets = new ArrayList();
            int i = 0;
            while (i < facets.length) {
                this.facets.add(facets[i]);
                ++i;
            }
        }
        if (variety == 2) {
            if (baseOrItemTypeName == null) {
                this.baseType = schema.getAnySimpleType();
                this.primitiveType = this;
            } else {
                SimpleTypeImpl base = this.getBuiltinSimpleType(baseOrItemTypeName);
                this.baseType = base;
                this.primitiveType = base.primitiveType;
                if (this.valueType == null) {
                    this.valueType = base.valueType;
                }
            }
        } else if (variety == 4) {
            this.itemType = this.getBuiltinSimpleType(baseOrItemTypeName);
            this.baseType = schema.getAnySimpleType();
            this.valueType = ValueType.LIST;
        }
    }

    private SimpleTypeImpl getBuiltinSimpleType(String name) {
        Type type = this.schema.getType(this.schema.NS_XS, name);
        if (type == null) {
            throw new Error();
        }
        return (SimpleTypeImpl)type;
    }

    public boolean isSimpleType() {
        return true;
    }

    public short getVariety() {
        return this.variety;
    }

    public SimpleType getPrimitiveTypeDefinition() {
        return this.primitiveType;
    }

    public SimpleType getItemTypeDefinition() {
        return this.itemType;
    }

    public SimpleType[] getMemberTypeDefinitions() {
        return this.memberTypes;
    }

    public boolean isOrdered() {
        return this.isOrdered;
    }

    public boolean isBounded() {
        return this.isBounded;
    }

    public boolean isNumeric() {
        return this.isNumeric;
    }

    public short getCardinality() {
        return this.cardinality;
    }

    ValueType getValueType() {
        return this.valueType;
    }

    public Iterator getFacets() {
        return this.facets != null ? this.facets.iterator() : null;
    }

    public Facet getFacet(short facetType, boolean recurse) {
        if (this.facets != null) {
            int len = this.facets.size();
            int i = 0;
            while (i < len) {
                FacetImpl facet = (FacetImpl)this.facets.get(i);
                if (facet != null && facet.getType() == facetType) {
                    return facet;
                }
                ++i;
            }
        }
        if (recurse && this.baseType != this.schema.getAnySimpleType()) {
            return ((SimpleTypeImpl)this.baseType).getFacet(facetType, true);
        }
        return null;
    }

    public String toString(Object value) {
        return this.valueType.toString(value);
    }

    public Object uncheckedValueOf(String data) throws Exception {
        return this.valueOf(data, false);
    }

    public Object valueOf(String data) throws Exception {
        return this.valueOf(data, true);
    }

    private Object valueOf(String data, boolean validate) throws Exception {
        switch (this.variety) {
            case 2: {
                Facet facet;
                if (this.valueType == null) {
                    this.error(null, "abstract base type cannot be used directly");
                }
                if ((facet = this.getFacet((short)6, true)) != null) {
                    switch (((Number)facet.getValue()).shortValue()) {
                        case 2: {
                            data = SchemaComponentBase.ops.replaceWhiteSpace(data);
                            break;
                        }
                        case 3: {
                            data = SchemaComponentBase.ops.collapseWhiteSpace(data);
                        }
                    }
                }
                Object value = this.valueType.valueOf(data);
                if (validate) {
                    this.validate(data, value);
                }
                return value;
            }
            case 4: {
                StringTokenizer tokens = new StringTokenizer(data, " \t\n\r");
                ArrayList<Object> list = new ArrayList<Object>();
                while (tokens.hasMoreTokens()) {
                    list.add(this.itemType.valueOf(tokens.nextToken(), validate));
                }
                if (validate) {
                    this.validate(data, list);
                }
                return list;
            }
            case 3: {
                Exception lastException = null;
                int i = 0;
                while (i < this.memberTypes.length) {
                    try {
                        Object value = this.memberTypes[i].valueOf(data, validate);
                        if (validate) {
                            this.validate(data, value);
                        }
                        return value;
                    }
                    catch (Exception e) {
                        lastException = e;
                        ++i;
                    }
                }
                throw lastException;
            }
        }
        throw new Error();
    }

    private void validate(String data, Object value) throws Exception {
        if (this.baseType != this.schema.getAnySimpleType()) {
            ((SimpleTypeImpl)this.baseType).validate(data, value);
        }
        if (this.facets != null) {
            int len = this.facets.size();
            int i = 0;
            while (i < len) {
                FacetImpl facet = (FacetImpl)this.facets.get(i);
                facet.validate(data, value);
                ++i;
            }
        }
    }

    void readDefinition() {
        Element e = SchemaComponentBase.ops.firstElementChild(this.declaration);
        if (SchemaComponentBase.ops.matchName(e, this.schema.NS_XS, "annotation")) {
            e = SchemaComponentBase.ops.nextElementSibling(e);
        }
        if (SchemaComponentBase.ops.matchName(e, this.schema.NS_XS, "restriction")) {
            this.parseRestriction(e);
        } else if (SchemaComponentBase.ops.matchName(e, this.schema.NS_XS, "list")) {
            this.parseList(e);
        } else if (SchemaComponentBase.ops.matchName(e, this.schema.NS_XS, "union")) {
            this.parseUnion(e);
        }
    }

    private void parseRestriction(Element e) {
        SimpleTypeImpl sbase = null;
        String typeRef = e.getAttribute("base");
        if (typeRef.length() > 0) {
            sbase = this.getSimpleType(e, typeRef);
        }
        if ((e = SchemaComponentBase.ops.firstElementChild(e)) != null && SchemaComponentBase.ops.matchName(e, this.schema.NS_XS, "annotation")) {
            e = SchemaComponentBase.ops.nextElementSibling(e);
        }
        if (e != null && SchemaComponentBase.ops.matchName(e, this.schema.NS_XS, "simpleType")) {
            if (sbase != null) {
                this.error(null, "simpleType cannot have base and nested simpleType", e);
            }
            sbase = new SimpleTypeImpl(e, null, null, this.schema);
            sbase.readDefinition();
            e = SchemaComponentBase.ops.nextElementSibling(e);
        } else if (sbase == null) {
            this.error(null, "simpleType must have base or nested simpleType", e);
        }
        this.parseRestriction(e, sbase);
    }

    void parseRestriction(Element e, SimpleTypeImpl sbase) {
        boolean needEncoding;
        this.baseType = sbase;
        this.variety = sbase.variety;
        this.isOrdered = sbase.isOrdered;
        this.isBounded = sbase.isBounded;
        this.isNumeric = sbase.isNumeric;
        this.cardinality = sbase.cardinality;
        this.itemType = sbase.itemType;
        this.memberTypes = sbase.memberTypes;
        this.primitiveType = sbase.primitiveType;
        this.valueType = sbase.valueType;
        boolean bl = needEncoding = sbase.localName != null && sbase.localName.equals("binary") && this.schema.NS_XS.equals(sbase.namespaceURI);
        if (needEncoding) {
            Element e2 = e;
            while (e2 != null) {
                if (SchemaComponentBase.ops.matchName(e, this.schema.NS_XS, "encoding")) {
                    String encoding = e.getAttribute("value");
                    if (encoding.equals("hex")) {
                        this.valueType = ValueType.BINARY_HEX;
                    } else if (encoding.equals("base64")) {
                        this.valueType = ValueType.BINARY_BASE64;
                    } else {
                        this.error(null, "invalid encoding", e, "value");
                    }
                    needEncoding = false;
                    break;
                }
                e2 = SchemaComponentBase.ops.nextElementSibling(e2);
            }
            if (needEncoding) {
                this.error(null, "binary restriction must have encoding facet", e);
            }
        }
        while (e != null) {
            FacetImpl facet;
            if (this.schema.NS_XS.equals(SchemaComponentBase.ops.getNamespaceURI(e)) && (facet = this.parseFacet(e)) != null) {
                if (this.facets == null) {
                    this.facets = new ArrayList();
                }
                this.facets.add(facet);
            }
            e = SchemaComponentBase.ops.nextElementSibling(e);
        }
        if (this.facets != null) {
            int len = this.facets.size();
            int i = 0;
            while (i < len) {
                FacetImpl facet = (FacetImpl)this.facets.get(i);
                facet.bind();
                ++i;
            }
        }
        switch (this.variety) {
            case 2: {
                if (this.getFacet((short)9, true) == null && this.getFacet((short)10, true) == null || this.getFacet((short)7, true) == null && this.getFacet((short)8, true) == null) break;
                this.isBounded = true;
                this.cardinality = 1;
                break;
            }
            case 4: {
                if (this.getFacet((short)1, true) == null && (this.getFacet((short)2, true) == null || this.getFacet((short)3, true) == null)) break;
                this.isBounded = true;
                this.cardinality = 1;
            }
        }
    }

    private void parseList(Element e) {
        String typeRef = e.getAttribute("itemType");
        if (typeRef.length() > 0) {
            this.itemType = this.getSimpleType(e, typeRef);
        }
        if ((e = SchemaComponentBase.ops.firstElementChild(e)) != null && SchemaComponentBase.ops.matchName(e, this.schema.NS_XS, "annotation")) {
            e = SchemaComponentBase.ops.nextElementSibling(e);
        }
        if (e != null && SchemaComponentBase.ops.matchName(e, this.schema.NS_XS, "simpleType")) {
            if (this.itemType != null) {
                this.error(null, "list type cannot have itemType and nested simpleType", e);
            }
            this.itemType = new SimpleTypeImpl(e, null, null, this.schema);
            this.itemType.readDefinition();
        } else if (this.itemType == null) {
            this.error(null, "list type must have itemType or nested simpleType");
        }
        if (this.itemType.variety == 4) {
            this.error(null, "item type of list cannot be list");
        }
        this.baseType = this.schema.getAnySimpleType();
        this.valueType = ValueType.LIST;
        this.variety = (short)4;
        this.cardinality = (short)2;
    }

    private void parseUnion(Element e) {
        ArrayList<SimpleTypeImpl> members = new ArrayList<SimpleTypeImpl>();
        String membersAttr = e.getAttribute("memberTypes");
        if (membersAttr.length() > 0) {
            StringTokenizer memberTokens = new StringTokenizer(membersAttr, " \t\n\r");
            while (memberTokens.hasMoreTokens()) {
                String typeRef = memberTokens.nextToken();
                members.add(this.getSimpleType(e, typeRef));
            }
        }
        if ((e = SchemaComponentBase.ops.firstElementChild(e)) != null && SchemaComponentBase.ops.matchName(e, this.schema.NS_XS, "annotation")) {
            e = SchemaComponentBase.ops.nextElementSibling(e);
        }
        while (e != null) {
            if (SchemaComponentBase.ops.matchName(e, this.schema.NS_XS, "simpleType")) {
                SimpleTypeImpl type = new SimpleTypeImpl(e, null, null, this.schema);
                type.readDefinition();
                members.add(type);
            }
            e = SchemaComponentBase.ops.nextElementSibling(e);
        }
        if (members.size() < 2) {
            this.error(null, "union type must have memberTypes or nested simpleType");
        }
        this.memberTypes = new SimpleTypeImpl[members.size()];
        members.toArray(this.memberTypes);
        this.baseType = this.schema.getAnySimpleType();
        this.variety = (short)3;
        this.cardinality = (short)2;
        Type commonAncestor = this.memberTypes[0];
        boolean allFinite = true;
        boolean allBounded = true;
        boolean allOrdered = true;
        boolean allNumeric = true;
        int i = 0;
        while (i < this.memberTypes.length) {
            SimpleTypeImpl type = this.memberTypes[i];
            if (i > 0 && commonAncestor != null) {
                commonAncestor = this.getCommonAncestor(commonAncestor, type);
            }
            if (type.getCardinality() != 1) {
                allFinite = false;
            }
            if (!type.isBounded()) {
                allBounded = false;
            }
            if (!type.isOrdered()) {
                allOrdered = false;
            }
            if (!type.isNumeric()) {
                allNumeric = false;
            }
            ++i;
        }
        if (allFinite) {
            this.cardinality = 1;
        }
        if (allBounded && commonAncestor != null) {
            this.isBounded = true;
        }
        if (allOrdered && commonAncestor != null) {
            this.isOrdered = true;
        }
        if (allNumeric) {
            this.isNumeric = true;
        }
    }

    private Type getCommonAncestor(Type type1, Type type2) {
        AnyTypeImpl any = this.schema.getAnySimpleType();
        while (type1 != any) {
            Type common = type2;
            while (common != any) {
                if (common == type1) {
                    return common;
                }
                common = common.getBaseType();
            }
            type1 = type1.getBaseType();
        }
        return null;
    }

    private FacetImpl parseFacet(Element e) {
        FacetImpl facet = FacetImpl.newInstance(e, this);
        if (facet == null) {
            return null;
        }
        Facet otherFacet = ((SimpleTypeImpl)this.baseType).getFacet(facet.getType(), true);
        if (otherFacet != null && otherFacet.isFixed()) {
            if (!facet.getValue().equals(otherFacet.getValue())) {
                this.error(null, "cannot override fixed facet", e);
            } else {
                return null;
            }
        }
        return facet;
    }

    private SimpleTypeImpl getSimpleType(Element e, String typeRef) {
        TypeImpl type = this.schema.getType(e, typeRef);
        if (!(type instanceof SimpleTypeImpl)) {
            this.error(null, "must reference simpleType: " + typeRef, e);
        }
        return (SimpleTypeImpl)type;
    }
}

