/*
 * Decompiled with CFR 0.152.
 */
package com.nanobiz.xml.schema.loader;

import com.nanobiz.xml.schema.Schema;
import com.nanobiz.xml.schema.SchemaErrorListener;
import com.nanobiz.xml.schema.SchemaException;
import com.nanobiz.xml.schema.loader.SchemaDocumentLoader;
import com.nanobiz.xml.schema.loader.SchemaImpl;
import com.nanobiz.xml.schema.loader.SchemaLoader;

public class SchemaLoaderFactory {
    private static DefaultErrorListener defaultErrorListener;

    public static SchemaLoader newLoader() {
        if (defaultErrorListener == null) {
            defaultErrorListener = new DefaultErrorListener();
        }
        return new MyLoader(defaultErrorListener);
    }

    public static SchemaLoader newLoader(SchemaErrorListener errorListener) {
        return new MyLoader(errorListener);
    }

    private static class DefaultErrorListener
    implements SchemaErrorListener {
        private DefaultErrorListener() {
        }

        public void schemaError(SchemaException e) {
            throw e;
        }
    }

    private static class MyLoader
    implements SchemaLoader {
        SchemaErrorListener errorListener;

        MyLoader(SchemaErrorListener errorListener) {
            this.errorListener = errorListener;
        }

        public Schema loadSchema(SchemaDocumentLoader docLoader) {
            return new SchemaImpl(docLoader, this.errorListener);
        }
    }
}

