/*
 * Decompiled with CFR 0.152.
 */
package com.nanobiz.xml.schema.loader;

import com.nanobiz.xml.schema.loader.SchemaDocumentLoader;
import com.nanobiz.xml.schema.loader.SchemaImpl;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SchemaDocumentLoaderFactory {
    public static SchemaDocumentLoader newSingleDocumentLoader(Document doc) {
        return new MyLoader(doc);
    }

    public static SchemaDocumentLoader newDocumentArrayLoader(Document[] docs) {
        return new MyLoader(docs);
    }

    private static class MyLoader
    implements SchemaDocumentLoader {
        private Document[] docs;

        MyLoader(Document doc) {
            this.docs = new Document[]{doc};
        }

        MyLoader(Document[] docs) {
            this.docs = docs;
        }

        public Document[] loadRequiredDocuments() {
            return this.getDocuments("");
        }

        public Document[] loadDocumentsByNamespace(String namespaceURI) {
            return this.getDocuments(namespaceURI);
        }

        private Document[] getDocuments(String namespaceURI) {
            ArrayList<Document> list = new ArrayList<Document>();
            int i = 0;
            while (i < this.docs.length) {
                String uri;
                Element root = this.docs[i].getDocumentElement();
                if (root != null && ((uri = root.getAttribute("targetNamespace")).equals(namespaceURI) || namespaceURI.length() == 0 && SchemaImpl.isSomeSchemaNamespace(uri))) {
                    list.add(this.docs[i]);
                }
                ++i;
            }
            if (list.size() > 0) {
                Document[] matches = new Document[list.size()];
                list.toArray(matches);
                return matches;
            }
            return null;
        }
    }
}

