/*
 * Decompiled with CFR 0.152.
 */
package com.nanobiz.xml.schema.loader;

import com.nanobiz.xml.schema.SchemaComponent;
import com.nanobiz.xml.schema.loader.SchemaComponentBase;
import com.nanobiz.xml.schema.loader.SchemaImpl;
import java.util.StringTokenizer;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

public abstract class SchemaComponentImpl
extends SchemaComponentBase
implements SchemaComponent {
    protected String localName;
    protected String namespaceURI;
    protected short componentType;

    SchemaComponentImpl(Element declaration, String namespaceURI, String localName, short componentType, SchemaImpl schema) {
        super(declaration, schema);
        if (declaration != null) {
            if (localName == null) {
                localName = declaration.getAttribute("name");
            }
            if (namespaceURI == null) {
                namespaceURI = schema.getSchemaAttribute(declaration, "targetNamespace");
            }
        }
        if (localName != null && localName.length() == 0) {
            localName = null;
        }
        if (namespaceURI != null && namespaceURI.length() == 0) {
            namespaceURI = null;
        }
        this.localName = localName;
        this.namespaceURI = namespaceURI;
        this.componentType = componentType;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getNamespaceURI() {
        return this.namespaceURI;
    }

    public short getComponentType() {
        return this.componentType;
    }

    boolean nameEquals(SchemaComponentImpl other) {
        return this.localName.equals(other.localName) && (this.namespaceURI == other.namespaceURI || this.namespaceURI.equals(other.namespaceURI));
    }

    short parseDerivationMethods(Element e, String attrName, String defaultAttrName, int allowedMethods) {
        String attr;
        Attr node = e.getAttributeNode(attrName);
        String string = attr = node != null ? node.getValue() : this.schema.getSchemaAttribute(e, defaultAttrName);
        if (attr.length() == 0) {
            return 0;
        }
        if (attr.equals("##all")) {
            return (short)allowedMethods;
        }
        int methods = 0;
        StringTokenizer tokens = new StringTokenizer(attr);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            if (token.equals("extension")) {
                methods = (short)(methods | 1);
                continue;
            }
            if (token.equals("restriction")) {
                methods = (short)(methods | 2);
                continue;
            }
            if (!token.equals("substitution")) continue;
            methods = (short)(methods | 4);
        }
        return (short)(methods & allowedMethods);
    }
}

