/*
 * Decompiled with CFR 0.152.
 */
package com.nanobiz.xml.schema.loader;

import com.nanobiz.xml.schema.DOMOperations;
import com.nanobiz.xml.schema.SchemaConstants;
import com.nanobiz.xml.schema.loader.SchemaImpl;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class SchemaComponentBase
implements SchemaConstants {
    protected Element declaration;
    protected SchemaImpl schema;
    protected boolean hasBeenRead;
    static DOMOperations ops = DOMOperations.getInstance();

    SchemaComponentBase(Element declaration, SchemaImpl schema) {
        this.declaration = declaration;
        this.schema = schema;
        this.hasBeenRead = declaration == null;
    }

    void error(String rule, Throwable e, Node node, String attr, String attrNS) {
        if (node == null) {
            node = this.declaration;
        }
        this.schema.error(rule, e, node, attr, attrNS);
    }

    void error(String rule, String message, Node node, String attr, String attrNS) {
        if (node == null) {
            node = this.declaration;
        }
        this.schema.error(rule, message, node, attr, attrNS);
    }

    void error(String rule, String message, Node node, String attr) {
        this.error(rule, message, node, attr, null);
    }

    void error(String rule, String message, Node node) {
        this.error(rule, message, node, null, null);
    }

    void error(String rule, String message) {
        this.error(rule, message, null, null, null);
    }

    void resolve() {
        if (!this.hasBeenRead) {
            this.hasBeenRead = true;
            this.readDefinition();
        }
    }

    abstract void readDefinition();
}

