/*
 * Decompiled with CFR 0.152.
 */
package com.nanobiz.xml.schema.loader;

import java.lang.ref.WeakReference;
import java.util.LinkedList;
import java.util.ListIterator;

public class ReferenceArrayCache {
    private LinkedList entries = new LinkedList();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Object[] keys, Object value) {
        Entry newEntry = new Entry(keys, value);
        LinkedList linkedList = this.entries;
        synchronized (linkedList) {
            this.entries.add(newEntry);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Object get(Object[] keys) {
        LinkedList linkedList = this.entries;
        synchronized (linkedList) {
            ListIterator i = this.entries.listIterator(0);
            while (i.hasNext()) {
                Entry entry = (Entry)i.next();
                Object val = entry.get(keys);
                if (val != null) {
                    return val;
                }
                if (!entry.isInvalid()) continue;
                i.remove();
            }
            return null;
        }
    }

    private static class Entry {
        private WeakReference[] keyRefs;
        private Object value;
        private boolean isInvalid;

        Entry(Object[] keys, Object value) {
            this.keyRefs = new WeakReference[keys.length];
            int i = 0;
            while (i < keys.length) {
                this.keyRefs[i] = new WeakReference<Object>(keys[i]);
                ++i;
            }
            this.value = value;
        }

        Object get(Object[] keys) {
            boolean found = true;
            if (keys.length != this.keyRefs.length) {
                found = false;
            }
            int i = 0;
            while (i < keys.length) {
                Object ref = this.keyRefs[i].get();
                if (ref != keys[i]) {
                    found = false;
                }
                if (ref == null) {
                    this.isInvalid = true;
                    return null;
                }
                ++i;
            }
            Object val = this.value;
            if (val == null) {
                this.isInvalid = true;
            }
            return found ? val : null;
        }

        boolean isInvalid() {
            return this.isInvalid;
        }
    }
}

