/*
 * Decompiled with CFR 0.152.
 */
package com.nanobiz.xml.schema.loader;

import com.nanobiz.xml.schema.ModelGroup;
import com.nanobiz.xml.schema.Particle;
import com.nanobiz.xml.schema.loader.ParticleImpl;
import com.nanobiz.xml.schema.loader.SchemaComponentBase;
import com.nanobiz.xml.schema.loader.SchemaImpl;
import java.util.ArrayList;
import org.w3c.dom.Element;

class ModelGroupImpl
extends SchemaComponentBase
implements ModelGroup {
    private short compositor;
    private ArrayList particles = new ArrayList();

    ModelGroupImpl(Element declaration, SchemaImpl schema) {
        super(declaration, schema);
    }

    ModelGroupImpl(SchemaImpl schema, short newCompositor) {
        this(null, schema);
        this.compositor = newCompositor;
    }

    public short getTermType() {
        return 1;
    }

    public short getCompositor() {
        return this.compositor;
    }

    public int getLength() {
        return this.particles.size();
    }

    public Particle getItem(int index) {
        return (Particle)this.particles.get(index);
    }

    void addItem(Particle part) {
        this.particles.add(part);
    }

    void readDefinition() {
        if (SchemaComponentBase.ops.matchName(this.declaration, this.schema.NS_XS, "sequence")) {
            this.compositor = 1;
        } else if (SchemaComponentBase.ops.matchName(this.declaration, this.schema.NS_XS, "choice")) {
            this.compositor = (short)2;
        } else if (SchemaComponentBase.ops.matchName(this.declaration, this.schema.NS_XS, "all")) {
            this.compositor = (short)3;
        }
        Element e = SchemaComponentBase.ops.firstElementChild(this.declaration);
        if (e != null && SchemaComponentBase.ops.matchName(e, this.schema.NS_XS, "annotation")) {
            e = SchemaComponentBase.ops.nextElementSibling(e);
        }
        while (e != null) {
            ParticleImpl part = new ParticleImpl(e, this.schema);
            part.readDefinition();
            if (part.getMinOccurs() != 0 || part.getMaxOccurs() != 0) {
                this.particles.add(part);
            }
            e = SchemaComponentBase.ops.nextElementSibling(e);
        }
    }
}

