/*
 * Decompiled with CFR 0.152.
 */
package com.nanobiz.xml.schema.loader;

import com.nanobiz.xml.schema.ElementDeclaration;
import com.nanobiz.xml.schema.Type;
import com.nanobiz.xml.schema.loader.ComplexTypeImpl;
import com.nanobiz.xml.schema.loader.SchemaComponentBase;
import com.nanobiz.xml.schema.loader.SchemaComponentImpl;
import com.nanobiz.xml.schema.loader.SchemaImpl;
import com.nanobiz.xml.schema.loader.TypeImpl;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

class ElementDeclarationImpl
extends SchemaComponentImpl
implements ElementDeclaration {
    private TypeImpl typeDefinition;
    private boolean isAbstract;
    private short disallowedSubstitutions;
    private short substitutionGroupExclusions;
    private HashSet subGroupMembers = new HashSet();
    private HashSet subGroupExpandedMembers;
    private ElementDeclarationImpl subGroupHead;

    ElementDeclarationImpl(Element declaration, String namespaceURI, String localName, SchemaImpl schema) {
        super(declaration, namespaceURI, localName, (short)2, schema);
        this.subGroupMembers.add(this);
    }

    public Type getTypeDefinition() {
        return this.typeDefinition;
    }

    public short getTermType() {
        return 3;
    }

    public boolean isAbstract() {
        return this.isAbstract;
    }

    public boolean isDisallowedSubstitution(short derivationMethod) {
        return (this.disallowedSubstitutions & derivationMethod) != 0;
    }

    public boolean isSubstitutionGroupExclusion(short derivationMethod) {
        return (this.substitutionGroupExclusions & derivationMethod) != 0;
    }

    public ElementDeclaration getSubstitutionGroupHead() {
        return this.subGroupHead;
    }

    public Set getSubstitutionGroupMembers() {
        if (this.subGroupExpandedMembers == null) {
            this.expandSubGroupMembers(this.subGroupMembers.iterator(), this);
            if (this.subGroupExpandedMembers == null) {
                this.subGroupExpandedMembers = this.subGroupMembers;
            }
        }
        return this.subGroupExpandedMembers;
    }

    void expandSubGroupMembers(Iterator members, ElementDeclaration except) {
        while (members.hasNext()) {
            ElementDeclarationImpl next = (ElementDeclarationImpl)members.next();
            if (next == except) continue;
            if (this.subGroupExpandedMembers == null) {
                this.subGroupExpandedMembers = new HashSet();
            }
            this.subGroupExpandedMembers.add(next);
            this.expandSubGroupMembers(next.subGroupMembers.iterator(), next);
        }
    }

    void readDefinition() {
        String ref;
        this.isAbstract = "true".equals(this.declaration.getAttribute("abstract"));
        this.disallowedSubstitutions = this.parseDerivationMethods(this.declaration, "block", "blockDefault", 7);
        this.substitutionGroupExclusions = this.parseDerivationMethods(this.declaration, "final", "finalDefault", 3);
        if (!SchemaImpl.parentIsSchema(this.declaration)) {
            String attr;
            Attr node = this.declaration.getAttributeNode("form");
            String string = attr = node != null ? node.getValue() : this.schema.getSchemaAttribute(this.declaration, "elementFormDefault");
            if (attr.length() == 0 || attr.equals("unqualified")) {
                this.namespaceURI = null;
            }
        }
        if ((ref = this.declaration.getAttribute("substitutionGroup")).length() > 0) {
            this.subGroupHead = this.schema.getElement(this.declaration, ref);
            this.subGroupHead.subGroupMembers.add(this);
        }
        if ((ref = this.declaration.getAttribute("type")).length() > 0) {
            this.typeDefinition = this.schema.getType(this.declaration, ref);
        } else {
            Element e = SchemaComponentBase.ops.firstElementChild(this.declaration);
            if (e != null && SchemaComponentBase.ops.matchName(e, this.schema.NS_XS, "annotation")) {
                e = SchemaComponentBase.ops.nextElementSibling(e);
            }
            if (e == null) {
                this.typeDefinition = this.schema.getAnyType();
            } else if (!SchemaComponentBase.ops.matchName(e, this.schema.NS_XS, "simpleType") && SchemaComponentBase.ops.matchName(e, this.schema.NS_XS, "complexType")) {
                this.typeDefinition = new ComplexTypeImpl(e, null, null, this.schema);
                this.typeDefinition.readDefinition();
            }
        }
        if (this.typeDefinition == null) {
            throw new RuntimeException("xxx");
        }
    }
}

