/*
 * Decompiled with CFR 0.152.
 */
package com.nanobiz.xml.schema.loader;

import com.nanobiz.xml.schema.AttributeDeclaration;
import com.nanobiz.xml.schema.AttributeGroup;
import com.nanobiz.xml.schema.Wildcard;
import com.nanobiz.xml.schema.loader.AttributeDeclarationImpl;
import com.nanobiz.xml.schema.loader.SchemaComponentBase;
import com.nanobiz.xml.schema.loader.SchemaImpl;
import com.nanobiz.xml.schema.loader.WildcardImpl;
import java.util.ArrayList;
import org.w3c.dom.Element;

class AttributeGroupImpl
extends SchemaComponentBase
implements AttributeGroup {
    private ArrayList attributes;
    private WildcardImpl wildcard;

    AttributeGroupImpl(Element declaration, SchemaImpl schema) {
        super(declaration, schema);
        this.attributes = new ArrayList();
    }

    AttributeGroupImpl(SchemaImpl schema, WildcardImpl wildcard) {
        super(null, schema);
        this.attributes = new ArrayList();
        this.wildcard = wildcard;
    }

    private AttributeGroupImpl(SchemaImpl schema, ArrayList attrs) {
        super(null, schema);
        this.attributes = attrs;
    }

    public int getLength() {
        return this.attributes.size();
    }

    public AttributeDeclaration getItem(int index) {
        return (AttributeDeclaration)this.attributes.get(index);
    }

    public boolean isItemRequired(int index) {
        AttributeDeclarationImpl attr = (AttributeDeclarationImpl)this.attributes.get(index);
        return attr != null && attr.isRequired();
    }

    public Wildcard getWildcard() {
        return this.wildcard;
    }

    void setWildcard(Wildcard newWildcard) {
        this.wildcard = (WildcardImpl)newWildcard;
    }

    void subtractProhibitedAttributes() {
        int i = 0;
        while (i < this.attributes.size()) {
            AttributeDeclarationImpl attr = (AttributeDeclarationImpl)this.attributes.get(i);
            if (attr.isProhibited()) {
                this.attributes.remove(i);
            }
            ++i;
        }
    }

    void unionAttributes(AttributeGroup others) {
        ArrayList list = ((AttributeGroupImpl)others).attributes;
        int i = 0;
        while (i < list.size()) {
            AttributeDeclarationImpl attr = (AttributeDeclarationImpl)list.get(i);
            this.addAttribute(attr, true);
            ++i;
        }
    }

    private void addAttribute(AttributeDeclarationImpl attr, boolean allowDuplicates) {
        int i = 0;
        while (i < this.attributes.size()) {
            AttributeDeclarationImpl attr1 = (AttributeDeclarationImpl)this.attributes.get(i);
            if (attr1.nameEquals(attr)) {
                if (allowDuplicates) {
                    return;
                }
                this.error(null, "duplicate attribute (" + attr.localName + ", " + attr.namespaceURI + ")");
            }
            ++i;
        }
        this.attributes.add(attr);
    }

    void readDefinition() {
        AttributeGroupImpl group;
        Element e = this.declaration;
        ArrayList<AttributeGroupImpl> groups = null;
        while (e != null) {
            if (SchemaComponentBase.ops.matchName(e, this.schema.NS_XS, "attribute")) {
                AttributeDeclarationImpl attr;
                String ref = e.getAttribute("ref");
                if (ref.length() > 0) {
                    attr = this.schema.getAttribute(e, ref);
                } else {
                    attr = new AttributeDeclarationImpl(e, null, null, this.schema);
                    attr.readDefinition();
                }
                this.addAttribute(attr, false);
            } else if (SchemaComponentBase.ops.matchName(e, this.schema.NS_XS, "attributeGroup")) {
                String ref = e.getAttribute("ref");
                if (ref.length() == 0) {
                    this.error(null, "ref required on nested attributeGroup");
                }
                group = this.schema.getAttributeGroup(e, ref);
                if (groups == null) {
                    groups = new ArrayList<AttributeGroupImpl>();
                }
                groups.add(group);
            } else if (SchemaComponentBase.ops.matchName(e, this.schema.NS_XS, "anyAttribute")) {
                this.wildcard = new WildcardImpl(e, this.schema);
                this.wildcard.readDefinition();
            }
            e = SchemaComponentBase.ops.nextElementSibling(e);
        }
        if (groups != null) {
            int i = 0;
            while (i < groups.size()) {
                group = (AttributeGroupImpl)groups.get(i);
                this.unionAttributes(group);
                Wildcard groupWildcard = group.getWildcard();
                if (this.wildcard != null && groupWildcard != null) {
                    this.wildcard.intersectNamespaceConstraint(groupWildcard);
                }
                ++i;
            }
        }
    }
}

