/*
 * Decompiled with CFR 0.152.
 */
package com.nanobiz.xml.schema.loader;

import com.nanobiz.xml.schema.AttributeDeclaration;
import com.nanobiz.xml.schema.SimpleType;
import com.nanobiz.xml.schema.loader.SchemaComponentBase;
import com.nanobiz.xml.schema.loader.SchemaComponentImpl;
import com.nanobiz.xml.schema.loader.SchemaImpl;
import com.nanobiz.xml.schema.loader.SimpleTypeImpl;
import com.nanobiz.xml.schema.loader.TypeImpl;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;

class AttributeDeclarationImpl
extends SchemaComponentImpl
implements AttributeDeclaration {
    private SimpleType typeDefinition;
    private short constraintMode;
    private String constraintValue;
    private boolean isRequired;
    private boolean isProhibited;

    AttributeDeclarationImpl(Element declaration, String namespaceURI, String localName, SchemaImpl schema) {
        super(declaration, namespaceURI, localName, (short)3, schema);
    }

    public SimpleType getTypeDefinition() {
        return this.typeDefinition;
    }

    public short getValueConstraintMode() {
        return this.constraintMode;
    }

    public String getValueConstraintValue() {
        return this.constraintValue;
    }

    boolean isRequired() {
        return this.isRequired;
    }

    boolean isProhibited() {
        return this.isProhibited;
    }

    void readDefinition() {
        if (!SchemaImpl.parentIsSchema(this.declaration)) {
            String attr;
            Attr node = this.declaration.getAttributeNode("form");
            String string = attr = node != null ? node.getValue() : this.schema.getSchemaAttribute(this.declaration, "attributeFormDefault");
            if (attr.length() == 0 || attr.equals("unqualified")) {
                this.namespaceURI = null;
            }
        }
        String use = this.declaration.getAttribute("use");
        String value = this.declaration.getAttribute("value");
        if (use.equals("prohibited")) {
            this.isProhibited = true;
        } else if (value.length() == 0) {
            this.constraintMode = 1;
            this.isRequired = use.equals("required");
        } else {
            this.constraintMode = (short)(use.equals("fixed") ? 3 : 2);
            this.constraintValue = value;
        }
        String typeRef = this.declaration.getAttribute("type");
        if (typeRef.length() > 0) {
            TypeImpl type = this.schema.getType(this.declaration, typeRef);
            if (type instanceof SimpleType) {
                this.typeDefinition = (SimpleType)((Object)type);
            } else {
                this.error(null, "attribute type must be simpleType", null, "type");
            }
        } else {
            Element e = SchemaComponentBase.ops.firstElementChild(this.declaration);
            if (e != null && SchemaComponentBase.ops.matchName(e, this.schema.NS_XS, "annotation")) {
                e = SchemaComponentBase.ops.nextElementSibling(e);
            }
            if (e == null) {
                this.typeDefinition = this.schema.getAnySimpleType();
            } else if (SchemaComponentBase.ops.matchName(e, this.schema.NS_XS, "simpleType")) {
                SimpleTypeImpl type = new SimpleTypeImpl(e, null, null, this.schema);
                type.readDefinition();
                this.typeDefinition = type;
            }
        }
    }
}

