/*
 * Decompiled with CFR 0.152.
 */
package com.nanobiz.xml.schema.datatype;

import com.nanobiz.xml.schema.datatype.TextInput;
import java.math.BigDecimal;
import java.text.ParseException;

public class TimeDuration {
    public static final TimeDuration ZERO = new TimeDuration(1, 0, 0, 0, 0, 0, null);
    public static final TimeDuration SECOND = new TimeDuration(1, 0, 0, 0, 0, 0, 1, 0);
    public static final TimeDuration MINUTE = new TimeDuration(1, 0, 0, 0, 0, 1, null);
    public static final TimeDuration HOUR = new TimeDuration(1, 0, 0, 0, 1, 0, null);
    public static final TimeDuration DAY = new TimeDuration(1, 0, 0, 1, 0, 0, null);
    public static final TimeDuration MONTH = new TimeDuration(1, 0, 1, 0, 0, 0, null);
    public static final TimeDuration YEAR = new TimeDuration(1, 1, 0, 0, 0, 0, null);
    public static final TimeDuration CENTURY = new TimeDuration(1, 100, 0, 0, 0, 0, null);
    private static final BigDecimal ZERO_DECIMAL = new BigDecimal(0.0);
    private static final long SECOND_MILLIS = 1000L;
    private static final long MINUTE_MILLIS = 60000L;
    private static final long HOUR_MILLIS = 3600000L;
    private static final long DAY_MILLIS = 86400000L;
    private int sign;
    private int years;
    private int months;
    private int days;
    private int hours;
    private int minutes;
    private BigDecimal seconds;

    public TimeDuration(String fmt) throws ParseException {
        this.parse(fmt);
    }

    public TimeDuration(int sign, int years, int months, int days, int hours, int minutes, int seconds, int millis) {
        this(sign, years, months, days, hours, minutes, BigDecimal.valueOf(seconds * 1000 + millis, 3));
    }

    public TimeDuration(int sign, int years, int months, int days, int hours, int minutes, BigDecimal decimalSeconds) {
        this.sign = sign < 0 ? -1 : 1;
        this.years = years;
        this.months = months;
        this.days = days;
        this.hours = hours;
        this.minutes = minutes;
        this.seconds = decimalSeconds;
        if (this.seconds == null) {
            this.seconds = BigDecimal.valueOf(0L);
        }
    }

    public boolean equals(Object o) {
        TimeDuration other = (TimeDuration)o;
        return this.sign == other.sign && this.years == other.years && this.months == other.months && this.days == other.days && this.hours == other.hours && this.minutes == other.minutes && this.seconds.compareTo(other.seconds) == 0;
    }

    public String toString() {
        return null;
    }

    public int getYears() {
        return this.years;
    }

    public int getMonths() {
        return this.months;
    }

    public int getDays() {
        return this.days;
    }

    public int getHours() {
        return this.hours;
    }

    public int getMinutes() {
        return this.minutes;
    }

    public int getSeconds() {
        return this.seconds.intValue();
    }

    public int getMillis() {
        return this.seconds.movePointRight(3).intValue() % 1000;
    }

    public BigDecimal getDecimalSeconds() {
        return this.seconds;
    }

    private void parse(String fmt) throws ParseException {
        int val;
        TextInput input = new TextInput(fmt);
        boolean gotOne = false;
        this.sign = 1;
        char c = input.current();
        if (c == '+') {
            input.advance();
        } else if (c == '-') {
            this.sign = -1;
            input.advance();
        }
        input.getChar('P');
        boolean gotYears = false;
        boolean gotMonths = false;
        boolean gotDays = false;
        while (!input.eof() && input.current() != 'T') {
            val = input.getInt();
            c = input.current();
            if (c == 'Y') {
                if (gotYears || gotMonths || gotDays) {
                    input.error();
                }
                this.years = val;
                gotYears = true;
            } else if (c == 'M') {
                if (gotMonths || gotDays) {
                    input.error();
                }
                this.months = val;
                gotMonths = true;
            } else if (c == 'D') {
                if (gotDays) {
                    input.error();
                }
                this.days = val;
                gotDays = true;
            } else {
                input.error();
            }
            input.advance();
            gotOne = true;
        }
        if (!input.eof() && input.current() == 'T') {
            gotOne = false;
            boolean gotHours = false;
            boolean gotMinutes = false;
            boolean gotSeconds = false;
            input.advance();
            while (!input.eof()) {
                val = input.getInt();
                c = input.current();
                if (c == '.') {
                    input.advance();
                    c = input.current();
                    StringBuffer decimal = new StringBuffer(20);
                    decimal.append(String.valueOf(val));
                    decimal.append('.');
                    while (c >= '0' && c <= '9') {
                        decimal.append(c);
                        input.advance();
                        c = input.current();
                    }
                    this.seconds = new BigDecimal(decimal.toString());
                    if (c != 'S') {
                        input.error();
                    }
                }
                if (c == 'H') {
                    if (gotHours || gotMinutes || gotSeconds) {
                        input.error();
                    }
                    this.hours = val;
                    gotHours = true;
                } else if (c == 'M') {
                    if (gotMinutes || gotSeconds) {
                        input.error();
                    }
                    this.minutes = val;
                    gotMinutes = true;
                } else if (c == 'S') {
                    if (gotSeconds) {
                        input.error();
                    }
                    if (this.seconds == null) {
                        this.seconds = new BigDecimal((double)val);
                    }
                    gotSeconds = true;
                } else {
                    input.error();
                }
                input.advance();
                gotOne = true;
            }
        }
        if (!gotOne || !input.eof()) {
            input.error();
        }
        if (this.seconds == null) {
            this.seconds = ZERO_DECIMAL;
        }
    }

    public BigDecimal getTotalMillis() {
        BigDecimal val = this.seconds.multiply(new BigDecimal(1000.0));
        val = val.add(new BigDecimal((double)((long)this.days * 86400000L + (long)this.hours * 3600000L + (long)this.minutes * 60000L)));
        return val;
    }

    static {
        SECOND_MILLIS = 1000L;
        MINUTE_MILLIS = 60000L;
        HOUR_MILLIS = 3600000L;
        DAY_MILLIS = 86400000L;
    }
}

