/*
 * Decompiled with CFR 0.152.
 */
package com.nanobiz.xml.schema.datatype;

import java.text.ParseException;

class TextInput {
    private int offset;
    private char[] data;

    TextInput(String fmt) {
        this.data = fmt.toCharArray();
    }

    boolean eof() {
        return this.offset >= this.data.length;
    }

    void advance() {
        ++this.offset;
    }

    char current() throws ParseException {
        if (this.offset == this.data.length) {
            this.error();
        }
        return this.data[this.offset];
    }

    char previous() {
        return this.data[this.offset - 1];
    }

    char getChar(char c) throws ParseException {
        if (c != this.current()) {
            this.error();
        }
        this.advance();
        return c;
    }

    char getDigit() throws ParseException {
        char c = this.current();
        if (c < '0' || c > '9') {
            this.error();
        }
        this.advance();
        return c;
    }

    int getInt() throws ParseException {
        boolean oneDigit = false;
        int val = 0;
        while (true) {
            if (this.eof()) {
                if (!oneDigit) {
                    this.error();
                }
                return val;
            }
            char c = this.current();
            if (c >= '0' && c <= '9') {
                val = val * 10 + (c - 48);
                oneDigit = true;
                this.advance();
                continue;
            }
            if (oneDigit) {
                return val;
            }
            this.error();
        }
    }

    void expectNot(char c) throws ParseException {
        if (c == this.current()) {
            this.error();
        }
    }

    void error() throws ParseException {
        int o = this.offset - 1;
        throw new ParseException("invalid at offset " + o, o);
    }
}

