/*
 * Decompiled with CFR 0.152.
 */
package com.nanobiz.xml.schema;

import com.nanobiz.xml.schema.DOMOperations;
import com.nanobiz.xml.schema.SchemaComponent;
import java.text.FieldPosition;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import org.w3c.dom.Node;

public class SchemaException
extends RuntimeException {
    private String rule;
    private Object[] subst;
    private String message;
    private static ResourceBundle msgs = ResourceBundle.getBundle("com/nanobiz/xml/schema/SchemaExceptions");
    private static DOMOperations ops = new DOMOperations();

    public SchemaException(String rule, Object[] subst) {
        if (rule == null) {
            rule = "null";
        }
        this.rule = rule;
        this.subst = subst;
        this.message = null;
    }

    public SchemaException() {
        this((String)null, (Object[])null);
    }

    public SchemaException(String rule) {
        this(rule, (Object[])null);
    }

    public String getRule() {
        return this.rule;
    }

    public Object[] getSubst() {
        if (this.subst == null) {
            return null;
        }
        return (Object[])this.subst.clone();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getMessage() {
        if (this.message == null) {
            SchemaException schemaException = this;
            synchronized (schemaException) {
                if (this.message == null) {
                    String pat;
                    String baserule;
                    String basepat;
                    int dotPos;
                    StringBuffer sb = new StringBuffer();
                    Object[] s1 = null;
                    if (this.subst != null) {
                        s1 = new Object[this.subst.length];
                        int i = 0;
                        while (i < this.subst.length) {
                            if (this.subst[i] instanceof Node) {
                                s1[i] = ((Node)this.subst[i]).getNodeName();
                            } else if (this.subst[i] instanceof SchemaComponent) {
                                SchemaComponent sc = (SchemaComponent)this.subst[i];
                                s1[i] = sc.getNamespaceURI() + ":" + sc.getLocalName();
                            } else {
                                s1[i] = this.subst[i];
                            }
                            ++i;
                        }
                    }
                    if ((dotPos = this.rule.indexOf(46)) != -1 && (basepat = msgs.getString(baserule = this.rule.substring(0, dotPos))) != null) {
                        new MessageFormat(basepat).format(s1, sb, (FieldPosition)null);
                        sb.append(": ");
                    }
                    if ((pat = msgs.getString(this.rule)) != null) {
                        new MessageFormat(pat).format(s1, sb, (FieldPosition)null);
                    }
                    this.message = sb.toString();
                }
            }
        }
        return this.message;
    }
}

