/*
 * Decompiled with CFR 0.152.
 */
package com.nanobiz.xml.schema;

import com.nanobiz.xml.schema.SchemaConstants;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class DOMOperations
implements SchemaConstants {
    static DOMOperations defaultInstance = new DOMOperations();

    public static DOMOperations getInstance() {
        return defaultInstance;
    }

    public Element firstElementChild(Node p) {
        Node n = p.getFirstChild();
        while (n != null) {
            if (n.getNodeType() == 1) {
                return (Element)n;
            }
            n = n.getNextSibling();
        }
        return null;
    }

    public Element nextElementSibling(Node s) {
        Node n = s.getNextSibling();
        while (n != null) {
            if (n.getNodeType() == 1) {
                return (Element)n;
            }
            n = n.getNextSibling();
        }
        return null;
    }

    public Node parent(Node n) {
        if (n.getNodeType() == 2) {
            return ((Attr)n).getOwnerElement();
        }
        return n.getParentNode();
    }

    public int depth(Node n) {
        int depth = -1;
        while (n != null) {
            n = this.parent(n);
            ++depth;
        }
        return depth;
    }

    public Document document(Node n) {
        if (n.getNodeType() == 9) {
            return (Document)n;
        }
        return n.getOwnerDocument();
    }

    public String getLocalName(String name) {
        int colonPos = name.lastIndexOf(58);
        if (colonPos == -1) {
            return name;
        }
        return name.substring(colonPos + 1, name.length());
    }

    public String getLocalName(Node n) {
        switch (n.getNodeType()) {
            case 1: 
            case 2: {
                String name = n.getLocalName();
                if (name != null) {
                    return name;
                }
                return this.getLocalName(n.getNodeName());
            }
        }
        return null;
    }

    public String getPrefix(String name) {
        int colonPos = name.lastIndexOf(58);
        if (colonPos == -1) {
            return null;
        }
        return name.substring(0, colonPos);
    }

    public String getPrefix(Node n) {
        switch (n.getNodeType()) {
            case 1: 
            case 2: {
                String name = n.getPrefix();
                if (name != null) {
                    return name;
                }
                return this.getPrefix(n.getNodeName());
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public String resolvePrefix(String prefix, Node n) {
        if ("xml".equals(prefix)) {
            return "http://www.w3.org/XML/1998/namespace";
        }
        if (!"xmlns".equals(prefix)) ** GOTO lbl11
        return "http://www.w3.org/2000/xmlns";
lbl-1000:
        // 1 sources

        {
            if (n.getNodeType() == 1) {
                e = (Element)n;
                a = prefix == null ? e.getAttributeNode("xmlns") : e.getAttributeNode("xmlns:" + prefix);
                if (a != null) {
                    return a.getValue();
                }
            }
            n = this.parent(n);
lbl11:
            // 2 sources

            ** while (n != null)
        }
lbl12:
        // 1 sources

        return null;
    }

    /*
     * Unable to fully structure code
     */
    public String reverseResolvePrefix(String namespaceURI, Node n) {
        block7: {
            if (namespaceURI != null) break block7;
            namespaceURI = "";
            ** GOTO lbl24
        }
        if ("http://www.w3.org/XML/1998/namespace".equals(namespaceURI)) {
            return "xml";
        }
        if (!"http://www.w3.org/2000/xmlns".equals(namespaceURI)) ** GOTO lbl24
        return "xmlns";
lbl-1000:
        // 1 sources

        {
            if (n.getNodeType() == 1) {
                e = (Element)n;
                nm = e.getAttributes();
                i = 0;
                while (i < nm.getLength()) {
                    a = (Attr)nm.item(i);
                    if (a.getNodeValue().equals(namespaceURI)) {
                        aname = a.getNodeName();
                        if (aname.equals("xmlns")) {
                            return null;
                        }
                        if (aname.startsWith("xmlns:")) {
                            return aname.substring(6);
                        }
                    }
                    ++i;
                }
            }
            n = this.parent(n);
lbl24:
            // 3 sources

            ** while (n != null)
        }
lbl25:
        // 1 sources

        return "[" + namespaceURI + "]";
    }

    public String getNamespaceURI(Node n) {
        short nodeType = n.getNodeType();
        switch (nodeType) {
            case 1: 
            case 2: {
                break;
            }
            default: {
                return null;
            }
        }
        String name = n.getNodeName();
        if (name.equals("xmlns") || name.startsWith("xmlns:")) {
            return "http://www.w3.org/2000/xmlns";
        }
        if (this.getPrefix(n) == null && n.getNodeType() == 2) {
            return null;
        }
        String prefix = this.getPrefix(n);
        if (nodeType == 2 && prefix == null) {
            return null;
        }
        return this.resolvePrefix(this.getPrefix(n), n);
    }

    public boolean matchName(Node n, String namespaceURI, String localName) {
        String nns = this.getNamespaceURI(n);
        String nln = this.getLocalName(n);
        return (nns == null ? namespaceURI == null : nns.equals(namespaceURI)) && (nln == null ? localName == null : nln.equals(localName));
    }

    public String getNodePath(Node n) {
        switch (n.getNodeType()) {
            case 9: 
            case 11: {
                return "";
            }
            case 2: {
                return this.getNodePath(((Attr)n).getOwnerElement()) + "/@" + n.getNodeName();
            }
            case 1: {
                return this.getNodePath(n.getParentNode()) + "/" + n.getNodeName();
            }
            case 3: 
            case 4: {
                return this.getNodePath(n.getParentNode()) + "/text()";
            }
        }
        throw new IllegalArgumentException();
    }

    private static void collectText(Node node, StringBuffer sb) {
        switch (node.getNodeType()) {
            case 3: 
            case 4: {
                sb.append(node.getNodeValue());
                break;
            }
            default: {
                node = node.getFirstChild();
                while (node != null) {
                    DOMOperations.collectText(node, sb);
                    node = node.getNextSibling();
                }
                break block0;
            }
        }
    }

    public String stringValueOfNode(Node node) {
        if (node == null) {
            return "";
        }
        switch (node.getNodeType()) {
            case 1: 
            case 9: 
            case 11: {
                StringBuffer sb = new StringBuffer();
                DOMOperations.collectText(node, sb);
                return sb.toString();
            }
        }
        return node.getNodeValue();
    }

    public String replaceWhiteSpace(String s) {
        StringBuffer sb = new StringBuffer(s.length());
        int i = 0;
        while (i < s.length()) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': {
                    sb.append(' ');
                    break;
                }
                default: {
                    sb.append(ch);
                }
            }
            ++i;
        }
        return sb.toString();
    }

    public String collapseWhiteSpace(String s) {
        StringBuffer sb = new StringBuffer(s.length());
        boolean gotSpace = true;
        int i = 0;
        while (i < s.length()) {
            char ch = s.charAt(i);
            switch (ch) {
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    if (gotSpace) break;
                    sb.append(' ');
                    gotSpace = true;
                    break;
                }
                default: {
                    gotSpace = false;
                    sb.append(ch);
                }
            }
            ++i;
        }
        if (gotSpace && sb.length() > 0) {
            sb.setLength(sb.length() - 1);
        }
        return sb.toString();
    }
}

