/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.saaj.soap12.bc;

import com.systinet.saaj.soap.SOAPElementImpl;
import com.systinet.saaj.soap.SOAPFaultImpl;
import com.systinet.saaj.soap.bc.FaultImpl;
import com.systinet.saaj.soap.util.ReleaseListener;
import com.systinet.saaj.soap12.common.SOAP12Constants;
import com.systinet.wasp.soap.util.SAAJUtils;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import org.idoox.util.RuntimeWrappedException;
import org.idoox.xmlrpc.Constants;

public class Fault12Impl
extends FaultImpl {
    public Fault12Impl(ReleaseListener listener, SOAPFaultImpl fault, boolean output) {
        super(listener, fault, output);
    }

    public void setFaultCode(QName faultCode) {
        if (this.detailTokenWriter != null) {
            throw new IllegalStateException("setFaultCode must be called before getDetailTokenWriter");
        }
        QName code = faultCode;
        QName subCode = null;
        if (Constants.MUST_UNDERSTAND_FAULT_CODE.equals(code)) {
            code = Constants.MUST_UNDERSTAND_FAULT_CODE_12;
        } else if (Constants.VERSION_MISMATCH_FAULT_CODE.equals(code)) {
            code = Constants.VERSION_MISMATCH_FAULT_CODE_12;
        } else if (Constants.SERVER_FAULT_CODE.equals(code)) {
            code = Constants.RECEIVER_FAULT_CODE_12;
        } else if (Constants.CLIENT_FAULT_CODE.equals(code)) {
            code = Constants.SENDER_FAULT_CODE_12;
        } else if (!(Constants.MUST_UNDERSTAND_FAULT_CODE_12.equals(code) || Constants.VERSION_MISMATCH_FAULT_CODE_12.equals(code) || Constants.RECEIVER_FAULT_CODE_12.equals(code) || Constants.SENDER_FAULT_CODE_12.equals(code) || Constants.DATA_ENCODING_UNKNOWN_FAULT_CODE_12.equals(code))) {
            code = Constants.RECEIVER_FAULT_CODE_12;
            subCode = faultCode;
        }
        super.setFaultCode(code);
        if (subCode != null) {
            this.clearFaultSubcodes();
            this.addFaultSubcode(subCode);
        }
    }

    public List getFaultSubcodes() {
        SOAPElement subCodeEl;
        SOAPFault fault = (SOAPFault)this.getSOAPElement();
        SOAPElement codeEl = SAAJUtils.getChildElement((SOAPElement)fault, (Name)SOAP12Constants.FAULT_CODE);
        if (codeEl == null) {
            return super.getFaultSubcodes();
        }
        LinkedList<QName> result = new LinkedList<QName>();
        while ((subCodeEl = SAAJUtils.getChildElement((SOAPElement)codeEl, (Name)SOAP12Constants.FAULT_SUBCODE)) != null) {
            SOAPElement value = SAAJUtils.getChildElement((SOAPElement)subCodeEl, (Name)SOAP12Constants.FAULT_CODE_VALUE);
            if (value == null) {
                throw new RuntimeException("Subcode " + subCodeEl.getElementName() + " has no value!");
            }
            String qName = SAAJUtils.getElementContent((SOAPElement)value);
            result.add(SAAJUtils.stringToQName((SOAPElement)value, (String)qName.trim()));
            codeEl = subCodeEl;
        }
        return result;
    }

    public void addFaultSubcode(QName subcode) {
        SOAPElement subCodeEl;
        if (this.detailTokenWriter != null) {
            throw new IllegalStateException("setFaultSubcodes must be called before getDetailTokenWriter");
        }
        SOAPFault fault = (SOAPFault)this.getSOAPElement();
        SOAPElement codeEl = SAAJUtils.getChildElement((SOAPElement)fault, (Name)SOAP12Constants.FAULT_CODE);
        if (codeEl == null) {
            try {
                codeEl = fault.addChildElement(SOAP12Constants.FAULT_CODE);
            }
            catch (SOAPException e) {
                throw new RuntimeWrappedException((Throwable)e);
            }
            return;
        }
        while ((subCodeEl = SAAJUtils.getChildElement((SOAPElement)codeEl, (Name)SOAP12Constants.FAULT_SUBCODE)) != null) {
            codeEl = subCodeEl;
        }
        try {
            subCodeEl = codeEl.addChildElement(SOAP12Constants.FAULT_SUBCODE);
            SOAPElementImpl value = (SOAPElementImpl)subCodeEl.addChildElement(SOAP12Constants.FAULT_CODE_VALUE);
            String prefix = value.getPrefixForNamespace(subcode.getNamespaceURI());
            value.addTextNode(prefix + ":" + subcode.getLocalPart());
        }
        catch (SOAPException e) {
            throw new RuntimeWrappedException((Throwable)e);
        }
    }

    public void clearFaultSubcodes() {
        if (this.detailTokenWriter != null) {
            throw new IllegalStateException("setFaultSubcodes must be called before getDetailTokenWriter");
        }
        SOAPFault fault = (SOAPFault)this.getSOAPElement();
        SOAPElement codeEl = SAAJUtils.getChildElement((SOAPElement)fault, (Name)SOAP12Constants.FAULT_CODE);
        if (codeEl == null) {
            try {
                codeEl = fault.addChildElement(SOAP12Constants.FAULT_CODE);
            }
            catch (SOAPException e) {
                throw new RuntimeWrappedException((Throwable)e);
            }
            return;
        }
        SOAPElement subCodeEl = SAAJUtils.getChildElement((SOAPElement)codeEl, (Name)SOAP12Constants.FAULT_SUBCODE);
        if (subCodeEl == null) {
            return;
        }
        subCodeEl.detachNode();
        subCodeEl.recycleNode();
    }

    public String getFaultNode() {
        SOAPElement nodeEl = SAAJUtils.getChildElement((SOAPElement)this.getSOAPElement(), (Name)SOAP12Constants.FAULT_NODE);
        return SAAJUtils.getElementContent((SOAPElement)nodeEl);
    }

    public void setFaultNode(String node) {
        if (this.detailTokenWriter != null) {
            throw new IllegalStateException("setFaultNode must be called before getDetailTokenWriter");
        }
        SOAPElement nodeEl = SAAJUtils.getChildElement((SOAPElement)this.getSOAPElement(), (Name)SOAP12Constants.FAULT_NODE);
        SAAJUtils.removeAllChildren((SOAPElement)nodeEl);
        try {
            nodeEl.addTextNode(node);
        }
        catch (SOAPException e) {
            throw new RuntimeWrappedException((Throwable)e);
        }
    }
}

