/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.saaj.soap12;

import com.systinet.saaj.soap.SOAPElementImpl;
import com.systinet.saaj.soap12.common.SOAP12Constants;
import com.systinet.saaj.soap12.pools.SAAJNodePool;
import com.systinet.wasp.soap.util.SAAJUtils;
import javax.xml.namespace.QName;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.idoox.xmlrpc.Constants;

public class SOAPFaultImpl
extends com.systinet.saaj.soap.SOAPFaultImpl {
    protected Name getFaultCodeName() {
        return SOAP12Constants.FAULT_CODE;
    }

    protected Name getFaultStringName() {
        return SOAP12Constants.FAULT_REASON;
    }

    protected Name getFaultActorName() {
        return SOAP12Constants.FAULT_ROLE;
    }

    protected Name getDetailName() {
        return SOAP12Constants.DETAIL;
    }

    protected SOAPElementImpl newDetail() {
        return (SOAPElementImpl)SAAJNodePool.getNode(1205);
    }

    protected Name getEncodingStyleName() {
        return SOAP12Constants.ENCODING_STYLE;
    }

    protected SOAPElementImpl newElement() {
        return (SOAPElementImpl)SAAJNodePool.getNode(1209);
    }

    public void setFaultCode(String faultCode) throws SOAPException {
        SOAPElement faultCodeElement = this.getFaultCodeElement();
        if (faultCodeElement == null) {
            faultCodeElement = this;
        }
        QName code = SAAJUtils.stringToQName((SOAPElement)faultCodeElement, (String)faultCode);
        String subcode = null;
        if (Constants.MUST_UNDERSTAND_FAULT_CODE.equals(code)) {
            code = Constants.MUST_UNDERSTAND_FAULT_CODE_12;
        } else if (Constants.VERSION_MISMATCH_FAULT_CODE.equals(code)) {
            code = Constants.VERSION_MISMATCH_FAULT_CODE_12;
        } else if (Constants.SERVER_FAULT_CODE.equals(code)) {
            code = Constants.RECEIVER_FAULT_CODE_12;
        } else if (Constants.CLIENT_FAULT_CODE.equals(code)) {
            code = Constants.SENDER_FAULT_CODE_12;
        } else if (!(Constants.MUST_UNDERSTAND_FAULT_CODE_12.equals(code) || Constants.VERSION_MISMATCH_FAULT_CODE_12.equals(code) || Constants.RECEIVER_FAULT_CODE_12.equals(code) || Constants.SENDER_FAULT_CODE_12.equals(code) || Constants.DATA_ENCODING_UNKNOWN_FAULT_CODE_12.equals(code))) {
            code = Constants.RECEIVER_FAULT_CODE_12;
            subcode = faultCode;
        }
        SOAPElement faultCodeEl = SAAJUtils.getChildElement((SOAPElement)this, (Name)SOAP12Constants.FAULT_CODE);
        if (faultCodeEl == null) {
            faultCodeEl = this.addChildElement(SOAP12Constants.FAULT_CODE);
        } else {
            SAAJUtils.removeAllChildren((SOAPElement)faultCodeEl);
        }
        this.setCodeValue(faultCodeEl, faultCode);
        if (subcode != null) {
            SOAPElement subCodeEl = faultCodeEl.addChildElement(SOAP12Constants.FAULT_SUBCODE);
            this.setCodeValue(subCodeEl, subcode);
        }
    }

    private void setCodeValue(SOAPElement faultCodeEl, String faultCode) throws SOAPException {
        SOAPElement valueEl = SAAJUtils.getChildElement((SOAPElement)faultCodeEl, (Name)SOAP12Constants.FAULT_CODE_VALUE);
        if (valueEl == null) {
            valueEl = faultCodeEl.addChildElement(SOAP12Constants.FAULT_CODE_VALUE);
        } else {
            SAAJUtils.removeAllChildren((SOAPElement)valueEl);
        }
        valueEl.addTextNode(faultCode);
    }

    public String getFaultCode() {
        SOAPElement faultCodeEl = SAAJUtils.getChildElement((SOAPElement)this, (Name)SOAP12Constants.FAULT_CODE);
        if (faultCodeEl == null) {
            return null;
        }
        SOAPElement value = SAAJUtils.getChildElement((SOAPElement)faultCodeEl, (Name)SOAP12Constants.FAULT_CODE_VALUE);
        return SAAJUtils.getElementContent((SOAPElement)value);
    }

    public void setFaultString(String faultString) throws SOAPException {
        SOAPElement faultStringEl = SAAJUtils.getChildElement((SOAPElement)this, (Name)SOAP12Constants.FAULT_REASON);
        if (faultStringEl == null) {
            faultStringEl = this.addChildElement(SOAP12Constants.FAULT_REASON);
        } else {
            SAAJUtils.removeAllChildren((SOAPElement)faultStringEl);
        }
        SOAPElement text = faultStringEl.addChildElement(SOAP12Constants.FAULT_REASON_TEXT);
        text.addTextNode(faultString);
        text.addAttribute(SOAP12Constants.XML_LANG, "en");
    }

    public String getFaultString() {
        SOAPElement faultStringEl = SAAJUtils.getChildElement((SOAPElement)this, (Name)this.getFaultStringName());
        if (faultStringEl == null) {
            return null;
        }
        SOAPElement text = SAAJUtils.getChildElement((SOAPElement)faultStringEl, (Name)SOAP12Constants.FAULT_REASON_TEXT);
        return SAAJUtils.getElementContent((SOAPElement)text);
    }

    public QName getFaultCodeQName() {
        SOAPElement faultCodeEl = SAAJUtils.getChildElement((SOAPElement)this, (Name)SOAP12Constants.FAULT_CODE);
        SOAPElement value = SAAJUtils.getChildElement((SOAPElement)faultCodeEl, (Name)SOAP12Constants.FAULT_CODE_VALUE);
        return SAAJUtils.stringToQName((SOAPElement)value, (String)value.getValue());
    }
}

