/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.saaj.soap.bc;

import com.systinet.saaj.soap.SOAPElementImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import org.idoox.util.RuntimeWrappedException;
import org.idoox.xml.Attribute;
import org.idoox.xml.Token;
import org.idoox.xml.TokenWriter;
import org.idoox.xml.Tokenizer;
import org.idoox.xml.TokenizerException;
import org.idoox.xmlrpc.Constants;
import org.systinet.wasp.soap.FirstElementSkippingTokenizer;

public final class XmlRPCUtils {
    public static final Tokenizer setupElementStartingTokenWriter(TokenWriter writer, Tokenizer tokenizer, SOAPElementImpl element) throws IOException {
        try {
            writer.enter(element.getElementName().getURI(), "PAD");
            Iterator it = element.getNamespacePrefixes();
            while (it.hasNext()) {
                String prefix = (String)it.next();
                writer.setPrefixForNamespace(prefix, element.getNamespaceURI(prefix));
            }
            tokenizer.next();
            return new FirstElementSkippingTokenizer(tokenizer);
        }
        catch (TokenizerException e) {
            throw new RuntimeWrappedException((Throwable)e);
        }
    }

    public static final void propertyNameToQName(QName property, String value, String[] qname, String actorNextURI) {
        String propertyNS = property.getNamespaceURI();
        String propertyName = property.getLocalPart();
        if (!"urn:xmlrpc-protocol-properties".equals(propertyNS)) {
            qname[0] = propertyNS;
            qname[1] = propertyName;
            return;
        }
        if (Constants.MUST_UNDERSTAND_PROPERTY.equals(propertyName)) {
            if (value.equals("1")) {
                qname[0] = "http://schemas.xmlsoap.org/wsdl/soap/";
                qname[1] = "mustUnderstand";
            }
        } else if (Constants.ACTOR_PROPERTY.equals(propertyName)) {
            if (value != null && !value.equals(actorNextURI)) {
                qname[0] = "http://schemas.xmlsoap.org/wsdl/soap/";
                qname[1] = "actor";
            }
        } else if (Constants.ENCODING_STYLE_PROPERTY.equals(propertyName) && value != null) {
            qname[0] = "http://schemas.xmlsoap.org/wsdl/soap/";
            qname[1] = "encodingStyle";
        }
    }

    public static final void createToken(QName headerName, Map properties, Token token, String actorNextURI) {
        token.localName = headerName.getLocalPart();
        token.uri = headerName.getNamespaceURI();
        ArrayList<Attribute> attributes = new ArrayList<Attribute>(properties.size());
        Iterator it = properties.entrySet().iterator();
        String[] qname = new String[2];
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            Object key = entry.getKey();
            String value = (String)entry.getValue();
            qname[1] = null;
            if (key instanceof QName) {
                QName qName = (QName)key;
                XmlRPCUtils.propertyNameToQName(qName, value, qname, actorNextURI);
            }
            if (qname[1] == null) continue;
            Attribute attr = new Attribute();
            attr.uri = qname[0];
            attr.localName = qname[1];
            attr.value = value;
            attributes.add(attr);
        }
        token.attArr = attributes.toArray(new Attribute[0]);
        token.attEnd = token.attArr.length;
        token.prefix = null;
        token.type = (byte)2;
    }
}

