/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.saaj.soap.bc;

import com.systinet.saaj.soap.ParseException;
import com.systinet.saaj.soap.SOAPBodyImpl;
import com.systinet.saaj.soap.SOAPElement2Tokenizer;
import com.systinet.saaj.soap.SOAPElementImpl;
import com.systinet.saaj.soap.SOAPHeaderImpl;
import com.systinet.saaj.soap.bc.AbstractMessagePart;
import com.systinet.saaj.soap.bc.XmlRPCUtils;
import com.systinet.saaj.soap.util.ReleaseListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import org.idoox.util.RuntimeWrappedException;
import org.idoox.xml.ElementFinalizingTokenizerWrapper;
import org.idoox.xml.TokenWriter;
import org.idoox.xml.Tokenizer;
import org.idoox.xml.XMLWriterReader;

public class BodyPartImpl
extends AbstractMessagePart {
    private boolean needsBody;
    private XMLWriterReader contentTokenWriter;
    private boolean isInput;

    public BodyPartImpl(ReleaseListener listener, SOAPBodyImpl element, boolean needsBody, boolean isInput) {
        super(listener, element);
        this.needsBody = needsBody;
        this.isInput = isInput;
        this.contentTokenWriter = null;
    }

    public TokenWriter getContentTokenWriter() throws IOException {
        try {
            if (this.isInput && !this.needsBody) {
                throw new RuntimeException("Error");
            }
            SOAPElementImpl element = this.getSOAPElement();
            SOAPEnvelope env = (SOAPEnvelope)element.getParentElement();
            SOAPHeaderImpl header = (SOAPHeaderImpl)env.getHeader();
            if (header != null) {
                header.parse(null, null, false, null);
            }
            if (this.contentTokenWriter == null) {
                Node soapNode;
                this.contentTokenWriter = new XMLWriterReader();
                Iterator it = element.getChildElements();
                ArrayList<Node> tmpList = new ArrayList<Node>(20);
                while (it.hasNext()) {
                    soapNode = (Node)it.next();
                    tmpList.add(soapNode);
                }
                it = tmpList.iterator();
                while (it.hasNext()) {
                    soapNode = (Node)it.next();
                    soapNode.detachNode();
                    soapNode.recycleNode();
                }
                Tokenizer content = XmlRPCUtils.setupElementStartingTokenWriter((TokenWriter)this.contentTokenWriter, (Tokenizer)this.contentTokenWriter, element);
                ElementFinalizingTokenizerWrapper bodyTokenizer = new ElementFinalizingTokenizerWrapper(content, (SOAPElement)((SOAPElementImpl)env.getBody()));
                ElementFinalizingTokenizerWrapper envelopeTokenzier = new ElementFinalizingTokenizerWrapper((Tokenizer)bodyTokenizer, (SOAPElement)((SOAPElementImpl)env));
                element.setTokenizer((Tokenizer)envelopeTokenzier);
            }
            return this.contentTokenWriter;
        }
        catch (SOAPException e) {
            throw new RuntimeWrappedException((Throwable)e);
        }
        catch (ParseException e) {
            throw new RuntimeWrappedException((Throwable)((Object)e));
        }
    }

    public Tokenizer getTokenizer() {
        if (!this.needsBody && !this.isInput) {
            return null;
        }
        SOAPElement2Tokenizer t = (SOAPElement2Tokenizer)super.getTokenizer();
        if (!this.needsBody) {
            t.stopBuild();
        }
        return t;
    }

    public void finalize() throws IOException {
        if (this.contentTokenWriter != null) {
            this.contentTokenWriter.leave();
        }
    }
}

