/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.saaj.soap;

import com.systinet.saaj.soap.NameImpl;
import com.systinet.saaj.soap.NodeImpl;
import com.systinet.saaj.soap.ParseException;
import com.systinet.saaj.soap.SOAPElementImpl;
import com.systinet.saaj.soap.common.SOAP11Constants;
import com.systinet.saaj.soap.pools.SAAJNodePool;
import com.systinet.wasp.soap.util.SAAJUtils;
import java.util.Iterator;
import javax.xml.namespace.QName;
import javax.xml.soap.Detail;
import javax.xml.soap.Name;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPFault;
import org.idoox.util.RuntimeWrappedException;

public class SOAPFaultImpl
extends SOAPElementImpl
implements SOAPFault {
    public void setFaultCode(String faultCode) throws SOAPException {
        Name faultCodeName = this.getFaultCodeName();
        SOAPElement faultCodeEl = SAAJUtils.getChildElement((SOAPElement)this, (Name)faultCodeName);
        if (faultCodeEl == null) {
            faultCodeEl = this.addChildElement(faultCodeName);
        } else {
            SAAJUtils.removeAllChildren((SOAPElement)faultCodeEl);
        }
        faultCodeEl.addTextNode(faultCode);
    }

    public String getFaultCode() {
        SOAPElement faultCodeEl = this.getFaultCodeElement();
        return SAAJUtils.getElementContent((SOAPElement)faultCodeEl);
    }

    public SOAPElement getFaultCodeElement() {
        return SAAJUtils.getChildElement((SOAPElement)this, (Name)this.getFaultCodeName());
    }

    public void setFaultActor(String faultActor) throws SOAPException {
        Name faultActorName = this.getFaultActorName();
        SOAPElement faultActorEl = SAAJUtils.getChildElement((SOAPElement)this, (Name)faultActorName);
        if (faultActorEl == null) {
            faultActorEl = this.addChildElement(faultActorName);
        } else {
            SAAJUtils.removeAllChildren((SOAPElement)faultActorEl);
        }
        faultActorEl.addTextNode(faultActor);
    }

    public String getFaultActor() {
        SOAPElement faultActorEl = SAAJUtils.getChildElement((SOAPElement)this, (Name)this.getFaultActorName());
        return SAAJUtils.getElementContent((SOAPElement)faultActorEl);
    }

    public void setFaultString(String faultString) throws SOAPException {
        Name faultStringName = this.getFaultStringName();
        SOAPElement faultStringEl = SAAJUtils.getChildElement((SOAPElement)this, (Name)faultStringName);
        if (faultStringEl == null) {
            faultStringEl = this.addChildElement(faultStringName);
        } else {
            SAAJUtils.removeAllChildren((SOAPElement)faultStringEl);
        }
        faultStringEl.addTextNode(faultString);
    }

    public String getFaultString() {
        SOAPElement faultStringEl = SAAJUtils.getChildElement((SOAPElement)this, (Name)this.getFaultStringName());
        return SAAJUtils.getElementContent((SOAPElement)faultStringEl);
    }

    public Detail getDetail() {
        return (Detail)SAAJUtils.getChildElement((SOAPElement)this, (Name)this.getDetailName());
    }

    public Detail addDetail() throws SOAPException {
        if (this.getDetail() != null) {
            throw new SOAPException("Can't add detail if other detail is present.");
        }
        return (Detail)this.addChildElement(this.getDetailName());
    }

    public SOAPElement addChildElement(SOAPElement element) throws SOAPException {
        ++this.elementModCount;
        try {
            this.readAllSubelements();
        }
        catch (ParseException e) {
            throw new RuntimeWrappedException((Throwable)((Object)e));
        }
        ((SOAPElementImpl)element).addPrefixMap(this.namespaces);
        int index = 0;
        int addTo = 0;
        if (element.getElementName().equals(this.getFaultCodeName())) {
            this.subelements.add(addTo, element);
        } else if (element.getElementName().equals(this.getFaultStringName())) {
            addTo = index;
            Iterator i = this.getChildElements();
            while (i.hasNext()) {
                Node node = (Node)i.next();
                ++index;
                if (!(node instanceof SOAPElement) || !(e = (SOAPElement)node).getElementName().equals(this.getFaultCodeName())) continue;
                addTo = index;
                break;
            }
            this.subelements.add(index, element);
        } else if (element.getElementName().equals(this.getFaultActorName())) {
            addTo = index;
            Iterator i = this.getChildElements();
            while (i.hasNext()) {
                Node node = (Node)i.next();
                ++index;
                if (!(node instanceof SOAPElement)) continue;
                SOAPElement e = (SOAPElement)node;
                if (e.getElementName().equals(this.getFaultCodeName())) {
                    addTo = index;
                    continue;
                }
                if (!e.getElementName().equals(this.getFaultStringName())) continue;
                addTo = index;
                break;
            }
            this.subelements.add(addTo, element);
        } else {
            this.subelements.add(element);
        }
        ((NodeImpl)element).setParentElementInternal(this);
        return element;
    }

    public SOAPElement getSOAPElement(Name name) {
        SOAPElementImpl element = null;
        if (!name.equals(this.getDetailName())) {
            return super.getSOAPElement(name);
        }
        element = this.newDetail();
        element.name = (Name)((NameImpl)name).clone();
        return element;
    }

    public void recycleNode() {
        super.recycleNode();
    }

    protected Name getFaultCodeName() {
        return SOAP11Constants.FAULT_CODE;
    }

    protected Name getFaultStringName() {
        return SOAP11Constants.FAULT_STRING;
    }

    protected Name getFaultActorName() {
        return SOAP11Constants.FAULT_ACTOR;
    }

    protected Name getDetailName() {
        return SOAP11Constants.DETAIL;
    }

    protected SOAPElementImpl newDetail() {
        return (SOAPElementImpl)SAAJNodePool.getNode(5);
    }

    public QName getFaultCodeQName() {
        SOAPElement fcode = this.getFaultCodeElement();
        return SAAJUtils.stringToQName((SOAPElement)fcode, (String)fcode.getValue());
    }
}

