/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.saaj.soap;

import com.systinet.saaj.soap.NameImpl;
import com.systinet.saaj.soap.SOAPBodyImpl;
import com.systinet.saaj.soap.SOAPElementImpl;
import com.systinet.saaj.soap.SOAPHeaderImpl;
import com.systinet.saaj.soap.common.IParsingNode;
import com.systinet.saaj.soap.common.SOAP11Constants;
import com.systinet.saaj.soap.factories.NameFactory;
import com.systinet.saaj.soap.pools.SAAJNodePool;
import java.util.Iterator;
import javax.xml.soap.Name;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPHeader;

public class SOAPEnvelopeImpl
extends SOAPElementImpl
implements SOAPEnvelope,
IParsingNode {
    private static final NameFactory NAME_FACTORY = new NameFactory();
    public boolean usedBody;
    public boolean usedHeader;
    SOAPBodyImpl body;
    SOAPHeaderImpl header;

    public Name createName(String localName, String prefix, String uri) throws SOAPException {
        NameImpl name = (NameImpl)NAME_FACTORY.getNewInstance();
        name.localName = localName;
        name.prefix = prefix;
        name.uri = uri;
        return name;
    }

    public Name createName(String localName) throws SOAPException {
        return this.createName(localName, "", "");
    }

    public SOAPHeader getHeader() throws SOAPException {
        if (this.readSubelements != 0 && this.header != null && this.usedHeader) {
            return this.header;
        }
        Name headerName = this.getHeaderName();
        Iterator it = this.getChildElements();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof SOAPElement)) continue;
            SOAPElement soapElement = (SOAPElement)o;
            if (headerName.equals(soapElement.getElementName())) {
                this.usedHeader = true;
                return (SOAPHeader)soapElement;
            }
            return null;
        }
        return null;
    }

    public SOAPHeader getHeaderInternal() throws SOAPException {
        Name headerName = this.getHeaderName();
        Iterator it = this.getChildElements();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof SOAPElement)) continue;
            SOAPElement soapElement = (SOAPElement)o;
            if (headerName.equals(soapElement.getElementName())) {
                this.usedHeader = true;
                return (SOAPHeader)soapElement;
            }
            return null;
        }
        return null;
    }

    public SOAPBody getBody() throws SOAPException {
        if (this.readSubelements == 1 && this.body != null && !this.usedHeader || this.readSubelements > 1 && this.body != null) {
            return this.body;
        }
        Name bodyName = this.getBodyName();
        Iterator it = this.getChildElements();
        while (it.hasNext()) {
            SOAPElement soapElement;
            Object o = it.next();
            if (!(o instanceof SOAPElement) || !bodyName.equals((soapElement = (SOAPElement)o).getElementName())) continue;
            this.usedBody = true;
            return (SOAPBody)soapElement;
        }
        return null;
    }

    public SOAPBody getBodyInternal() throws SOAPException {
        Name bodyName = this.getBodyName();
        Iterator it = this.getChildElements();
        while (it.hasNext()) {
            SOAPElement soapElement;
            Object o = it.next();
            if (!(o instanceof SOAPElement) || !bodyName.equals((soapElement = (SOAPElement)o).getElementName())) continue;
            this.usedBody = true;
            return (SOAPBody)soapElement;
        }
        return null;
    }

    public SOAPHeader addHeader() throws SOAPException {
        SOAPHeader header = this.getHeaderInternal();
        if (header != null) {
            throw new SOAPException("Can't add a header when one is already present.");
        }
        header = (SOAPHeader)this.addChildElement(0, (Name)((NameImpl)this.getHeaderName()).clone());
        this.header = (SOAPHeaderImpl)header;
        this.usedHeader = true;
        return header;
    }

    public SOAPBody addBody() throws SOAPException {
        SOAPBody body = this.getBodyInternal();
        if (body != null) {
            throw new SOAPException("Can't add a body when one is already present.");
        }
        body = (SOAPBody)this.addChildElement(1, (Name)((NameImpl)this.getBodyName()).clone());
        this.body = (SOAPBodyImpl)body;
        this.usedBody = true;
        return body;
    }

    public SOAPElement getSOAPElement(Name name) {
        SOAPElementImpl element = null;
        if (name.equals(this.getBodyName())) {
            if (!this.usedBody && this.body != null) {
                this.usedBody = true;
                return this.body;
            }
            this.usedBody = true;
            element = this.newBody();
            this.body = (SOAPBodyImpl)element;
        } else if (name.equals(this.getHeaderName())) {
            if (!this.usedHeader && this.header != null) {
                this.usedHeader = true;
                return this.header;
            }
            this.usedHeader = true;
            element = this.newHeader();
            this.header = (SOAPHeaderImpl)element;
        } else {
            throw new RuntimeException("Invalid element in SOAPEnvelope context: " + name.getQualifiedName());
        }
        element.name = (Name)((NameImpl)name).clone();
        return element;
    }

    public void recycleNode() {
        this.usedBody = false;
        this.usedHeader = false;
        this.header = null;
        this.body = null;
        super.recycleNode();
    }

    public boolean isUsedBody() {
        return this.usedBody;
    }

    public void setEmpty() {
        this.usedBody = false;
        this.usedHeader = false;
    }

    protected Name getHeaderName() {
        return SOAP11Constants.HEADER;
    }

    protected Name getBodyName() {
        return SOAP11Constants.BODY;
    }

    protected SOAPElementImpl newHeader() {
        return (SOAPElementImpl)SAAJNodePool.getNode(7);
    }

    protected SOAPElementImpl newBody() {
        return (SOAPElementImpl)SAAJNodePool.getNode(3);
    }

    public boolean hasFault() throws SOAPException {
        if (!this.usedBody) {
            return false;
        }
        return this.getBody().hasFault();
    }
}

