/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.saaj.soap;

import com.systinet.saaj.soap.ElementIterator;
import com.systinet.saaj.soap.NameImpl;
import com.systinet.saaj.soap.NodeImpl;
import com.systinet.saaj.soap.ParseException;
import com.systinet.saaj.soap.SOAPElement2Tokenizer;
import com.systinet.saaj.soap.TextImpl;
import com.systinet.saaj.soap.common.IParsingNode;
import com.systinet.saaj.soap.common.SOAP11Constants;
import com.systinet.saaj.soap.pools.ElementIteratorPool;
import com.systinet.saaj.soap.pools.NamePool;
import com.systinet.saaj.soap.pools.SAAJNodePool;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import javax.xml.soap.Name;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPException;
import org.idoox.util.RuntimeWrappedException;
import org.idoox.xml.Attribute;
import org.idoox.xml.DeclaredPrefixesStack;
import org.idoox.xml.Token;
import org.idoox.xml.Tokenizer;
import org.systinet.wasp.soap.SOAPElementContent;

public class SOAPElementImpl
extends NodeImpl
implements SOAPElement,
IParsingNode,
SOAPElementContent {
    Tokenizer tokenizer;
    List subelements = new ArrayList();
    DeclaredPrefixesStack dps = new DeclaredPrefixesStack();
    Map attributes = new HashMap();
    volatile transient int elementModCount;
    Map namespaces = new HashMap();
    Name name;
    int lastPartiallyLoaded = -1;
    int readSubelements = 0;
    protected int nsIterator = 0;
    private Token token = new Token();

    public SOAPElement addChildElement(Name name) throws SOAPException {
        SOAPElement element = this.getSOAPElement(name);
        return this.addChildElement(element);
    }

    public SOAPElement addChildElement(String localName) throws SOAPException {
        NameImpl name = (NameImpl)NamePool.getName();
        name.localName = localName;
        name.uri = this.getNamespaceURI("");
        if (name.uri == null) {
            name.uri = "";
        }
        name.prefix = "";
        return this.addChildElement(name);
    }

    public SOAPElement addChildElement(String localName, String prefix) throws SOAPException {
        NameImpl name = (NameImpl)NamePool.getName();
        name.localName = localName;
        name.uri = this.getNamespaceURI(prefix);
        if (name.uri == null) {
            throw new SOAPException("Unable to locate namespace for prefix " + prefix);
        }
        name.prefix = prefix;
        return this.addChildElement(name);
    }

    public SOAPElement addChildElement(String localName, String prefix, String uri) throws SOAPException {
        NameImpl name = (NameImpl)NamePool.getName();
        name.localName = localName;
        name.uri = uri;
        name.prefix = prefix;
        return this.addChildElement(name);
    }

    public SOAPElement addChildElement(int position, Tokenizer content, Token token, DeclaredPrefixesStack dpStack, boolean lazy) throws ParseException, SOAPException {
        NameImpl name = this.createName(token);
        SOAPElementImpl child = (SOAPElementImpl)this.addChildElement(name);
        child.parse(content, token, lazy, dpStack);
        return child;
    }

    public SOAPElement addChildElement(Tokenizer content, Token token, DeclaredPrefixesStack dpStack, boolean lazy) throws ParseException, SOAPException {
        NameImpl name = this.createName(token);
        SOAPElementImpl child = (SOAPElementImpl)this.addChildElement(name);
        child.parse(content, token, lazy, dpStack);
        return child;
    }

    private NameImpl createName(Token token) {
        NameImpl name = (NameImpl)NamePool.getName();
        name.localName = token.localName;
        name.uri = token.uri;
        name.prefix = token.prefix;
        return name;
    }

    public SOAPElement addChildElement(SOAPElement element) throws SOAPException {
        ((NodeImpl)element).setParentElementInternal(this);
        ++this.elementModCount;
        try {
            this.readAllSubelements();
        }
        catch (ParseException e) {
            throw new RuntimeWrappedException((Throwable)((Object)e));
        }
        SOAPElementImpl e = (SOAPElementImpl)element;
        e.resolveName();
        this.subelements.add(element);
        return element;
    }

    protected void resolveName() {
        NameImpl name = (NameImpl)this.getElementName();
        if (name.prefix != null && name.uri != null) {
            if (this.containsNamespace(name.uri)) {
                String prefix = this.getPrefix(name.uri);
                if (!name.prefix.equals(prefix)) {
                    this.namespaces.put(name.prefix, name.uri);
                }
            } else if (name.uri.length() != 0) {
                this.namespaces.put(name.prefix, name.uri);
            }
        } else if (name.prefix == null && name.uri != null) {
            String prefix;
            name.prefix = prefix = this.getPrefixForNamespace(name.uri);
        } else if (name.prefix != null && name.uri == null && this.containsPrefix(name.prefix)) {
            name.uri = this.getNamespaceURI(name.prefix);
        }
    }

    public SOAPElement addChildElement(int position, SOAPElement element) throws SOAPException {
        SOAPElementImpl e = (SOAPElementImpl)element;
        e.setParentElementInternal(this);
        ++this.elementModCount;
        if (position > 0) {
            try {
                this.readAllSubelements();
            }
            catch (ParseException ex) {
                throw new RuntimeWrappedException((Throwable)((Object)ex));
            }
            int i = this.subelements.size();
            if (position > i) {
                position = i;
            }
            this.subelements.add(position, element);
        } else {
            this.subelements.add(0, element);
            if (this.lastPartiallyLoaded != -1) {
                ++this.lastPartiallyLoaded;
            }
        }
        NameImpl name = (NameImpl)element.getElementName();
        if (name.prefix != null && name.uri != null) {
            e.namespaces.put(name.prefix, name.uri);
        } else if (name.prefix == null && name.uri != null) {
            String prefix;
            name.prefix = prefix = e.getPrefixForNamespace(name.uri);
        } else if (name.prefix != null && name.uri == null && e.containsPrefix(name.prefix)) {
            name.uri = e.getNamespaceURI(name.prefix);
        }
        return element;
    }

    public SOAPElement addChildElement(int position, Name name) throws SOAPException {
        SOAPElement child = this.getSOAPElement(name);
        return this.addChildElement(position, child);
    }

    public SOAPElement addTextNode(String text) throws SOAPException {
        TextImpl txt = (TextImpl)SAAJNodePool.getNode(10);
        txt.text = text;
        txt.parent = this;
        this.subelements.add(txt);
        return this;
    }

    public SOAPElement addAttribute(Name name, String value) throws SOAPException {
        NameImpl n = (NameImpl)name;
        if (!"".equals(n.prefix)) {
            if (n.prefix != null && n.uri != null) {
                if (this.containsNamespace(n.uri)) {
                    String prefix = this.getPrefix(n.uri);
                    if (!n.prefix.equals(prefix)) {
                        this.namespaces.put(n.prefix, n.uri);
                    }
                } else {
                    this.namespaces.put(n.prefix, n.uri);
                }
            } else if (n.prefix == null && n.uri != null) {
                String prefix;
                n.prefix = prefix = this.getPrefixForNamespace(n.uri);
            } else if (n.prefix != null && n.uri == null && this.containsPrefix(n.prefix)) {
                n.uri = this.getNamespaceURI(n.prefix);
            }
        }
        this.attributes.put(name, value);
        return this;
    }

    public SOAPElement addNamespaceDeclaration(String prefix, String uri) throws SOAPException {
        if (prefix == null) {
            prefix = "";
        }
        this.namespaces.put(prefix, uri);
        return this;
    }

    public String getAttributeValue(Name name) {
        return (String)this.attributes.get(name);
    }

    public Iterator getAllAttributes() {
        return this.attributes.keySet().iterator();
    }

    public String getNamespaceURI(String prefix) {
        if (prefix == null) {
            prefix = "";
        }
        if (this.namespaces.containsKey(prefix)) {
            return (String)this.namespaces.get(prefix);
        }
        if (this.parent != null) {
            return this.parent.getNamespaceURI(prefix);
        }
        return null;
    }

    public Iterator getNamespacePrefixes() {
        HashMap all = new HashMap();
        SOAPElementImpl node = this;
        while (node != null) {
            all.putAll(node.namespaces);
            node = (SOAPElementImpl)node.parent;
        }
        return all.keySet().iterator();
    }

    protected boolean containsPrefix(String prefix) {
        if (this.namespaces.containsKey(prefix)) {
            return true;
        }
        if (this.parent != null) {
            return ((SOAPElementImpl)this.parent).containsPrefix(prefix);
        }
        return false;
    }

    protected boolean containsNamespace(String uri) {
        if (this.namespaces.containsValue(uri)) {
            return true;
        }
        if (this.parent != null) {
            return ((SOAPElementImpl)this.parent).containsNamespace(uri);
        }
        return false;
    }

    public Map getPrefixMap() {
        return (Map)((HashMap)this.namespaces).clone();
    }

    public Name getElementName() {
        return this.name;
    }

    public boolean removeAttribute(Name name) {
        NameImpl removed = (NameImpl)name;
        String value = (String)this.attributes.remove(name);
        if (value != null) {
            removed.release();
            return true;
        }
        return false;
    }

    public boolean removeNamespaceDeclaration(String prefix) {
        if (this.namespaces.containsKey(prefix)) {
            Object removed = this.namespaces.remove(prefix);
            return removed != null;
        }
        return false;
    }

    public Iterator getChildElements() {
        ElementIterator iterator = new ElementIterator();
        iterator.init(this);
        return iterator;
    }

    public Iterator getPooledChildElements() {
        ElementIterator iterator = ElementIteratorPool.getElementIterator();
        iterator.init(this);
        return iterator;
    }

    public static void releaseElementIterator(Iterator iterator) {
        ((ElementIterator)iterator).release();
    }

    public Iterator getChildElements(Name name) {
        return new ElementNameIterator(name);
    }

    public void setParentElement(SOAPElement parent) throws SOAPException {
        this.setParentElementInternal(parent);
        this.parent.addChildElement((SOAPElement)this);
    }

    public void setEncodingStyle(String encodingStyle) throws SOAPException {
        this.addAttribute((Name)((NameImpl)this.getEncodingStyleName()).clone(), encodingStyle);
    }

    public String getEncodingStyle() {
        Iterator attrIt = this.getAllAttributes();
        while (attrIt.hasNext()) {
            Name attrName = (Name)attrIt.next();
            if (!attrName.equals(this.getEncodingStyleName())) continue;
            return this.getAttributeValue(attrName);
        }
        if (this.parent != null) {
            return this.parent.getEncodingStyle();
        }
        return null;
    }

    public Tokenizer getTokenizer() {
        return new SOAPElement2Tokenizer(this);
    }

    public Tokenizer getContent() {
        return this.getTokenizer();
    }

    protected void readAllSubelements() throws ParseException {
        this.ensureLoadedLastElement();
        while (this.tokenizer != null) {
            this.initNextSubelement(false);
        }
    }

    protected void addPrefixMap(Map prefixes) {
        Iterator i = prefixes.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry prefix = i.next();
            if (this.containsPrefix((String)prefix.getKey())) continue;
            this.namespaces.put(prefix.getKey(), prefix.getValue());
        }
    }

    public void setContent(Tokenizer tokenizer) {
        Iterator i = this.subelements.iterator();
        while (i.hasNext()) {
            Node node = (Node)i.next();
            node.recycleNode();
        }
        this.subelements.clear();
        this.tokenizer = tokenizer;
        this.dps.used = 0;
        this.nsIterator = 0;
        this.lastPartiallyLoaded = -1;
    }

    public void parse(Tokenizer tokenizer, Token thisElement, boolean lazy, DeclaredPrefixesStack dps) throws ParseException {
        if (tokenizer != null && this.tokenizer == null) {
            this.tokenizer = tokenizer;
            if (dps != null) {
                int i = 0;
                while (i < dps.used) {
                    try {
                        this.addNamespaceDeclaration(dps.prefixes[i], dps.prefixValues[i]);
                    }
                    catch (SOAPException e) {
                        // empty catch block
                    }
                    ++i;
                }
            }
            if (thisElement != null) {
                this.init(thisElement);
            }
        }
        if (!lazy) {
            while (this.tokenizer != null) {
                this.initNextSubelement(lazy);
            }
        }
    }

    public String getPrefixForNamespace(String uri) {
        if (!this.containsNamespace(uri)) {
            String prefix = "ns" + this.nsIterator++;
            while (this.containsNamespace(prefix)) {
                prefix = "ns" + this.nsIterator++;
            }
            this.namespaces.put("ns" + (this.nsIterator - 1), uri);
            return prefix;
        }
        return this.getPrefix(uri);
    }

    protected String getPrefix(String uri) {
        Iterator i = this.namespaces.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entery = i.next();
            if (!entery.getValue().equals(uri)) continue;
            return (String)entery.getKey();
        }
        if (this.parent != null) {
            return ((SOAPElementImpl)this.parent).getPrefix(uri);
        }
        return null;
    }

    protected Node initNextSubelement(boolean lazy) throws ParseException {
        try {
            byte state = this.tokenizer.currentState();
            switch (state) {
                case 2: {
                    this.tokenizer.readToken(this.token);
                    NameImpl name = (NameImpl)NamePool.getName();
                    name.localName = this.token.localName;
                    name.prefix = this.token.prefix;
                    name.uri = this.token.uri;
                    if (name.uri == null) {
                        name.uri = "";
                    }
                    SOAPElementImpl element = (SOAPElementImpl)this.getSOAPElement(name);
                    element.parent = this;
                    this.dps.used = 0;
                    this.tokenizer.pushNewlyDeclaredPrefixes(this.dps);
                    this.tokenizer.next();
                    element.parse(this.tokenizer, this.token, lazy, this.dps);
                    this.subelements.add(element);
                    this.lastPartiallyLoaded = this.subelements.size() - 1;
                    ++this.readSubelements;
                    return element;
                }
                case 4: {
                    TextImpl text = (TextImpl)SAAJNodePool.getNode(10);
                    text.text = this.tokenizer.readContent();
                    text.parent = this;
                    this.subelements.add(text);
                    this.tokenizer.next();
                    return text;
                }
                case 3: {
                    this.tokenizer.next();
                    this.tokenizer = null;
                    break;
                }
                case 0: {
                    this.tokenizer.next();
                    break;
                }
                case 1: {
                    this.tokenizer = null;
                    break;
                }
                default: {
                    throw new RuntimeException("Unknown tokenizer state: " + state);
                }
            }
            return null;
        }
        catch (Exception e) {
            throw new ParseException("Exception while parsing", e);
        }
    }

    private void init(Token token) {
        int attrCount = token.getAttributeCount();
        int i = 0;
        while (i < attrCount) {
            Attribute attr = token.getAttribute(i);
            Name attrName = NamePool.getName();
            NameImpl attrNameImpl = (NameImpl)attrName;
            attrNameImpl.localName = attr.localName;
            attrNameImpl.uri = attr.uri != null ? attr.uri : "";
            attrNameImpl.prefix = attr.prefix == null ? "" : attr.prefix;
            this.attributes.put(attrName, attr.value);
            ++i;
        }
    }

    public SOAPElement getSOAPElement(Name name) {
        SOAPElementImpl element = this.newElement();
        element.name = (Name)((NameImpl)name).clone();
        return element;
    }

    protected void removeChild(Node element) {
        this.subelements.remove(element);
        ++this.elementModCount;
    }

    public void recycleNode() {
        Iterator i = this.subelements.iterator();
        while (i.hasNext()) {
            Node node = (Node)i.next();
            node.recycleNode();
        }
        this.namespaces.clear();
        this.subelements.clear();
        this.tokenizer = null;
        this.dps.used = 0;
        this.nsIterator = 0;
        Iterator i2 = this.attributes.keySet().iterator();
        while (i2.hasNext()) {
            ((NameImpl)i2.next()).release();
        }
        this.attributes.clear();
        this.lastPartiallyLoaded = -1;
        this.readSubelements = 0;
        ((NameImpl)this.name).release();
        this.name = null;
        super.recycleNode();
    }

    public void detachNode() {
        if (this.tokenizer != null) {
            if (this.parent != null && this.parent instanceof SOAPElementImpl) {
                ((SOAPElementImpl)this.parent).ensureLoadedLastElement();
            }
            if (this.tokenizer != null) {
                throw new RuntimeException("Some inconsitency.");
            }
        }
        if (this.parent != null) {
            ((SOAPElementImpl)this.parent).removeChild(this);
        }
    }

    public String getValue() {
        Iterator i = this.getChildElements();
        while (i.hasNext()) {
            Node node = (Node)i.next();
            if (!(node instanceof TextImpl)) continue;
            return ((TextImpl)node).text;
        }
        return null;
    }

    protected void ensureLoadedLastElement() {
        if (this.lastPartiallyLoaded != -1) {
            Node last = (Node)this.subelements.get(this.lastPartiallyLoaded);
            if (last instanceof SOAPElementImpl) {
                ((SOAPElementImpl)last).ensureLoadedLastElement();
            }
            try {
                this.load(last);
                this.lastPartiallyLoaded = -1;
            }
            catch (ParseException e) {
                throw new RuntimeWrappedException((Throwable)((Object)e));
            }
        }
    }

    private Node load(Node node) throws ParseException {
        if (node instanceof SOAPElementImpl && ((SOAPElementImpl)node).tokenizer != null) {
            ((SOAPElementImpl)node).parse(null, null, false, null);
        }
        return node;
    }

    public void setTokenizer(Tokenizer tokenizer) {
        this.tokenizer = tokenizer;
    }

    protected Name getEncodingStyleName() {
        return SOAP11Constants.ENCODING_STYLE;
    }

    protected SOAPElementImpl newElement() {
        return (SOAPElementImpl)SAAJNodePool.getNode(9);
    }

    private class ElementNameIterator
    implements Iterator {
        Name elementName;
        Iterator iterator;
        SOAPElement next;

        ElementNameIterator(Name elementName) {
            this.elementName = elementName;
            this.iterator = SOAPElementImpl.this.getChildElements();
        }

        /*
         * Unable to fully structure code
         */
        public boolean hasNext() {
            aux = null;
            if (this.next == null) ** GOTO lbl8
            return true;
lbl-1000:
            // 1 sources

            {
                aux = (Node)this.iterator.next();
                if (!(aux instanceof SOAPElementImpl) || !((SOAPElementImpl)aux).name.equals(this.elementName)) continue;
                this.next = (SOAPElement)aux;
                return true;
lbl8:
                // 2 sources

                ** while (this.iterator.hasNext())
            }
lbl9:
            // 1 sources

            return false;
        }

        public Object next() {
            if (this.next != null || this.hasNext()) {
                SOAPElement ret = this.next;
                this.next = null;
                return ret;
            }
            throw new NoSuchElementException("Iterator has reached the last element.");
        }

        public void remove() {
            throw new UnsupportedOperationException("Remove is not supported, use Node.detachNode() inted.");
        }
    }
}

