/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.saaj.soap;

import com.systinet.saaj.soap.ElementIterator;
import com.systinet.saaj.soap.NameImpl;
import com.systinet.saaj.soap.SOAPElementImpl;
import com.systinet.saaj.soap.TextImpl;
import com.systinet.wasp.soap.StopableTokenizer;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.namespace.QName;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPHeader;
import javax.xml.soap.Text;
import org.idoox.util.RuntimeWrappedException;
import org.idoox.xml.Attribute;
import org.idoox.xml.DeclaredPrefixesStack;
import org.idoox.xml.Token;
import org.idoox.xml.Tokenizer;
import org.idoox.xml.TokenizerException;
import org.idoox.xml.TokenizerWrapper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SOAPElement2Tokenizer
implements StopableTokenizer {
    private static final int NSR_INITIAL_SIZE = 8;
    private static final int PATH_INITIAL_SIZE = 8;
    private static final int NSR_INCREMENT = 8;
    private static final int STACK_INITIAL_SIZE = 8;
    private static final int STACK_INCREMENT = 4;
    private SOAPElementImpl currentElement;
    private String localName;
    private String prefix;
    private String uri;
    private Iterator currentNode;
    private Iterator[] nodeStack;
    private int[] nsPosStack;
    private int depth;
    private byte state;
    private Node node;
    private Map prefixMap = new HashMap(11, 0.75f);
    private String[] localNamespaces;
    private int localNamespacesPos;
    private int localNamespacesPosOld;
    private String[] overwrittenNamespaces;
    private int overwrittenNamespacesPos;
    private boolean reportedEndOfDocument;
    private SOAPElement release;
    private boolean building = true;
    private Tokenizer tokenizer;
    private boolean restoreDeclaredNamespaces;

    public SOAPElement2Tokenizer(SOAPElement element) {
        SOAPElementImpl[] path = new SOAPElementImpl[8];
        if (element == null) {
            throw new IllegalArgumentException("Element cannot be null");
        }
        this.currentElement = (SOAPElementImpl)element;
        this.state = (byte)2;
        NameImpl name = (NameImpl)this.currentElement.name;
        this.localName = name.localName;
        this.prefix = name.prefix;
        this.uri = name.uri;
        this.localNamespaces = new String[16];
        this.overwrittenNamespaces = new String[16];
        this.nodeStack = new Iterator[8];
        this.nsPosStack = new int[8];
        this.node = element;
        SOAPElementImpl e = this.currentElement;
        this.currentNode = e.getPooledChildElements();
        this.restoreDeclaredNamespaces = false;
        int aux = 0;
        while (e != null) {
            if (aux >= path.length) {
                path = this.resizeElementArray(path, 2 * this.localNamespaces.length);
            }
            path[aux] = e;
            e = (SOAPElementImpl)e.parent;
            ++aux;
        }
        --aux;
        while (aux >= 0) {
            this.prefixMap.putAll(path[aux].namespaces);
            --aux;
        }
        Iterator i = this.prefixMap.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry entry = i.next();
            if (this.localNamespacesPos >= this.localNamespaces.length) {
                this.localNamespaces = this.resizeStringArray(this.localNamespaces, this.localNamespaces.length + 16);
            }
            this.localNamespaces[this.localNamespacesPos++] = (String)entry.getKey();
            this.localNamespaces[this.localNamespacesPos++] = (String)entry.getValue();
        }
    }

    public String getLocalName() throws TokenizerException {
        if (this.tokenizer != null) {
            return this.tokenizer.getLocalName();
        }
        if (this.state != 2 && this.state != 3) {
            throw new TokenizerException("No current element");
        }
        return this.localName;
    }

    public String getNamespace() throws TokenizerException {
        if (this.tokenizer != null) {
            return this.tokenizer.getNamespace();
        }
        if (this.state != 2 && this.state != 3) {
            throw new TokenizerException("No current element");
        }
        return this.uri;
    }

    public String getNamespaceForPrefix(String prefix) {
        if (this.tokenizer != null) {
            return this.tokenizer.getNamespaceForPrefix(prefix);
        }
        if (prefix == null) {
            prefix = "";
        }
        return (String)this.prefixMap.get(prefix);
    }

    public QName parseQName(String qName) {
        QName retval;
        if (this.tokenizer != null) {
            return this.tokenizer.parseQName(qName);
        }
        if (qName == null || "".equals(qName)) {
            return null;
        }
        if (qName.charAt(0) == '{') {
            return QName.valueOf(qName);
        }
        int pos = qName.indexOf(":");
        if (pos != -1) {
            String prefix = qName.substring(0, pos);
            String localName = qName.substring(pos + 1, qName.length());
            String uri = (String)this.prefixMap.get(prefix);
            if (uri == null) {
                throw new RuntimeWrappedException("Unknown prefix " + prefix);
            }
            retval = new QName(uri, localName);
        } else {
            String uri = (String)this.prefixMap.get("");
            retval = new QName(uri, qName);
        }
        return retval;
    }

    public byte next() throws TokenizerException, IOException {
        if (this.reportedEndOfDocument) {
            throw new TokenizerException("Already at the end of document");
        }
        if (this.depth == -1) {
            this.state = 1;
            this.reportedEndOfDocument = true;
            return this.state;
        }
        if (this.tokenizer != null) {
            byte ret = this.tokenizer.next();
            if (ret == 2) {
                ++this.depth;
            } else if (ret == 3) {
                --this.depth;
            }
            return ret;
        }
        if (this.restoreDeclaredNamespaces) {
            this.restoreDeclaredNamespaces = false;
            int i = this.nsPosStack[2 * this.depth];
            while (i < this.localNamespacesPosOld) {
                this.prefixMap.remove(this.localNamespaces[i]);
                i += 2;
            }
        }
        boolean nxt = this.currentNode.hasNext();
        if (!this.building) {
            this.tokenizer = ((ElementIterator)this.currentNode).getTokenizer();
            if (this.tokenizer != null) {
                byte ret = this.tokenizer.currentState();
                if (ret == 2) {
                    ++this.depth;
                } else if (ret == 3) {
                    --this.depth;
                }
                return ret;
            }
        }
        if (!nxt) {
            this.state = (byte)3;
            NameImpl name = (NameImpl)this.currentElement.name;
            this.localName = name.localName;
            this.prefix = name.prefix;
            this.uri = name.uri;
            if (this.release != null) {
                this.release.recycleNode();
                this.release = null;
            }
            --this.depth;
            if (this.depth == -1) {
                return this.state;
            }
            this.currentElement = (SOAPElementImpl)this.currentElement.parent;
            SOAPElementImpl.releaseElementIterator(this.currentNode);
            this.currentNode = this.nodeStack[this.depth];
            this.restoreDeclaredNamespaces = true;
            this.localNamespacesPosOld = this.localNamespacesPos;
            this.localNamespacesPos = this.nsPosStack[2 * this.depth];
            int i = this.nsPosStack[2 * this.depth + 1];
            while (i < this.overwrittenNamespacesPos) {
                this.prefixMap.put(this.overwrittenNamespaces[i], this.overwrittenNamespaces[i + 1]);
                i += 2;
            }
            this.overwrittenNamespacesPos = this.nsPosStack[2 * this.depth + 1];
        } else {
            SOAPHeader header;
            this.node = (Node)this.currentNode.next();
            if (this.node instanceof SOAPHeader && !(header = (SOAPHeader)this.node).getChildElements().hasNext()) {
                if (this.currentNode.hasNext()) {
                    this.node = (Node)this.currentNode.next();
                } else if (!this.building) {
                    this.tokenizer = ((ElementIterator)this.currentNode).getTokenizer();
                    if (this.tokenizer != null) {
                        byte ret = this.tokenizer.currentState();
                        if (ret == 2) {
                            ++this.depth;
                        } else if (ret == 3) {
                            --this.depth;
                        }
                        return ret;
                    }
                }
            }
            if (this.node instanceof SOAPElement) {
                this.state = (byte)2;
                SOAPElementImpl e = (SOAPElementImpl)this.node;
                if (this.depth == this.nodeStack.length) {
                    this.nodeStack = this.resizeIteratorArray(this.nodeStack, this.nodeStack.length + 4);
                }
                if (this.depth * 2 == this.nsPosStack.length) {
                    this.nsPosStack = this.resizeIntArray(this.nsPosStack, this.nsPosStack.length + 8);
                }
                this.nodeStack[this.depth] = this.currentNode;
                this.nsPosStack[2 * this.depth] = this.localNamespacesPos;
                this.nsPosStack[2 * this.depth + 1] = this.overwrittenNamespacesPos;
                this.currentNode = e.getPooledChildElements();
                if (!this.building) {
                    ((ElementIterator)this.currentNode).stop();
                }
                this.currentElement = e;
                Map attrs = e.namespaces;
                Iterator i = attrs.entrySet().iterator();
                while (i.hasNext()) {
                    Map.Entry entry = i.next();
                    String prefix = (String)entry.getKey();
                    String uri = (String)entry.getValue();
                    if (this.prefixMap.containsKey(prefix)) {
                        if (this.overwrittenNamespacesPos >= this.overwrittenNamespaces.length) {
                            this.overwrittenNamespaces = this.resizeStringArray(this.overwrittenNamespaces, this.overwrittenNamespaces.length + 16);
                        }
                        this.overwrittenNamespaces[this.overwrittenNamespacesPos++] = prefix;
                        this.overwrittenNamespaces[this.overwrittenNamespacesPos++] = (String)this.prefixMap.get(prefix);
                    }
                    this.prefixMap.put(prefix, uri);
                    if (this.localNamespacesPos >= this.localNamespaces.length) {
                        this.localNamespaces = this.resizeStringArray(this.localNamespaces, this.localNamespaces.length + 16);
                    }
                    this.localNamespaces[this.localNamespacesPos++] = prefix;
                    this.localNamespaces[this.localNamespacesPos++] = uri;
                }
                NameImpl name = (NameImpl)this.currentElement.name;
                this.localName = name.localName;
                this.prefix = name.prefix;
                this.uri = name.uri;
                ++this.depth;
            } else if (this.node instanceof Text) {
                this.state = (byte)4;
            }
        }
        return this.state;
    }

    public byte currentState() {
        if (this.tokenizer != null) {
            return this.tokenizer.currentState();
        }
        return this.state;
    }

    public String readContent() throws TokenizerException {
        if (this.tokenizer != null) {
            return this.tokenizer.readContent();
        }
        if (this.state != 4) {
            throw new TokenizerException("No content available");
        }
        return ((TextImpl)this.node).text;
    }

    public void readToken(Token stoken) throws TokenizerException, IOException {
        if (this.tokenizer != null) {
            this.tokenizer.readToken(stoken);
            return;
        }
        if (this.state == 2) {
            stoken.localName = this.localName;
            stoken.uri = this.uri;
            stoken.prefix = this.prefix;
            stoken.type = (byte)2;
            Map attrs = ((SOAPElementImpl)this.node).attributes;
            int count = attrs.size();
            stoken.ensureCapacity(count);
            stoken.attEnd = count;
            int j = 0;
            Iterator i = attrs.entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                NameImpl name = (NameImpl)entry.getKey();
                Attribute attribute = stoken.attArr[j];
                attribute.localName = name.localName;
                attribute.uri = name.uri;
                attribute.prefix = name.prefix;
                attribute.qName = name.getQualifiedName();
                attribute.value = (String)entry.getValue();
                ++j;
            }
        } else if (this.state == 3) {
            stoken.localName = this.localName;
            stoken.uri = this.uri;
            stoken.prefix = this.prefix;
            stoken.type = (byte)3;
        } else {
            throw new TokenizerException("No token available");
        }
    }

    public boolean whitespaceContent() throws TokenizerException {
        if (this.tokenizer != null) {
            return this.tokenizer.whitespaceContent();
        }
        if (this.state != 4) {
            throw new TokenizerException("No content available");
        }
        char[] content = ((TextImpl)this.node).text.toCharArray();
        int i = 0;
        while (i < content.length) {
            if (!this.isS(content[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Map getCurrentPrefixMap() {
        if (this.tokenizer != null) {
            return this.tokenizer.getCurrentPrefixMap();
        }
        return Collections.unmodifiableMap(this.prefixMap);
    }

    public int pushNewlyDeclaredPrefixes(DeclaredPrefixesStack prefixes) {
        if (this.tokenizer != null) {
            return this.tokenizer.pushNewlyDeclaredPrefixes(prefixes);
        }
        int localNamespacesStart = 0;
        int overwritenStart = 0;
        int previousLocalNamespacesStart = 0;
        int index = 0;
        if (this.depth > 0) {
            localNamespacesStart = this.nsPosStack[2 * (this.depth - 1)];
            overwritenStart = this.nsPosStack[2 * (this.depth - 1) + 1];
        }
        int localNamespacesSize = (this.localNamespacesPos - localNamespacesStart) / 2;
        int overwritenSize = (this.overwrittenNamespacesPos - overwritenStart) / 2;
        int previousLocalNamespacesSize = -1;
        if (this.depth > 1) {
            previousLocalNamespacesStart = this.nsPosStack[2 * (this.depth - 2)];
            previousLocalNamespacesSize = (localNamespacesStart - previousLocalNamespacesStart) / 2;
        }
        if (this.depth == 1) {
            previousLocalNamespacesStart = 0;
            previousLocalNamespacesSize = (localNamespacesStart - 0) / 2;
        }
        int used = prefixes.used;
        prefixes.enlarge(localNamespacesSize);
        int i = 0;
        while (i < localNamespacesSize) {
            boolean add = true;
            int k = 0;
            while (k < previousLocalNamespacesSize) {
                if (this.localNamespaces[localNamespacesStart + 2 * i].equals(this.localNamespaces[previousLocalNamespacesStart + 2 * k]) && this.localNamespaces[localNamespacesStart + 2 * i + 1].equals(this.localNamespaces[previousLocalNamespacesStart + 2 * k + 1])) {
                    add = false;
                    break;
                }
                ++k;
            }
            if (add) {
                prefixes.prefixes[index + used] = this.localNamespaces[localNamespacesStart + 2 * i];
                prefixes.prefixValues[index + used] = this.localNamespaces[localNamespacesStart + 2 * i + 1];
                prefixes.previousPrefixValues[index + used] = null;
                int j = 0;
                while (j < overwritenSize) {
                    if (this.overwrittenNamespaces[overwritenStart + 2 * j].equals(prefixes.prefixes[index + used]) && !this.overwrittenNamespaces[overwritenStart + 2 * j + 1].equals(prefixes.prefixValues[index + used])) {
                        prefixes.previousPrefixValues[index + used] = this.overwrittenNamespaces[overwritenStart + 2 * j + 1];
                        break;
                    }
                    ++j;
                }
                ++index;
            }
            ++i;
        }
        prefixes.used += index;
        return index;
    }

    public Element getDOMRepresentation(Document doc) throws TokenizerException {
        return TokenizerWrapper.getDOMRepresentation((Tokenizer)this, (Document)doc);
    }

    public void stopBuild() {
        this.building = false;
        ((ElementIterator)this.currentNode).stop();
    }

    private SOAPElementImpl[] resizeElementArray(SOAPElementImpl[] array, int newSize) {
        SOAPElementImpl[] newArr = new SOAPElementImpl[newSize];
        int oldSize = array.length;
        if (newSize < oldSize) {
            System.arraycopy(array, 0, newArr, 0, newSize);
        } else {
            System.arraycopy(array, 0, newArr, 0, oldSize);
        }
        return newArr;
    }

    private String[] resizeStringArray(String[] array, int newSize) {
        String[] newArr = new String[newSize];
        int oldSize = array.length;
        if (newSize < oldSize) {
            System.arraycopy(array, 0, newArr, 0, newSize);
        } else {
            System.arraycopy(array, 0, newArr, 0, oldSize);
        }
        return newArr;
    }

    private int[] resizeIntArray(int[] array, int newSize) {
        int[] newArr = new int[newSize];
        int oldSize = array.length;
        if (newSize < oldSize) {
            System.arraycopy(array, 0, newArr, 0, newSize);
        } else {
            System.arraycopy(array, 0, newArr, 0, oldSize);
        }
        return newArr;
    }

    private Iterator[] resizeIteratorArray(Iterator[] array, int newSize) {
        Iterator[] newArr = new Iterator[newSize];
        int oldSize = array.length;
        if (newSize < oldSize) {
            System.arraycopy(array, 0, newArr, 0, newSize);
        } else {
            System.arraycopy(array, 0, newArr, 0, oldSize);
        }
        return newArr;
    }

    private boolean isS(char ch) {
        return ch == ' ' || ch == '\n' || ch == '\t' || ch == '\r';
    }
}

