/*
 * Decompiled with CFR 0.152.
 */
package com.systinet.saaj.soap;

import com.idoox.soap.EnvelopeOutCache;
import com.idoox.util.Pool;
import com.systinet.saaj.soap.AttachmentPartImpl;
import com.systinet.saaj.soap.MimeHeadersImpl;
import com.systinet.saaj.soap.NameImpl;
import com.systinet.saaj.soap.PoolableObject;
import com.systinet.saaj.soap.SOAPPartImpl;
import com.systinet.saaj.soap.bc.MessageImpl;
import com.systinet.saaj.soap.pools.AttachmentPartPool;
import com.systinet.wasp.soap.MessagePartImpl;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.xml.namespace.QName;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.Name;
import javax.xml.soap.Node;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import javax.xml.soap.Text;
import javax.xml.transform.Source;
import org.idoox.transport.OutputMessage;
import org.idoox.util.RuntimeWrappedException;
import org.idoox.wasp.Context;
import org.idoox.wasp.wsdl.SOAPMethodInfo;
import org.idoox.xml.Tokenizer;
import org.idoox.xml.TokenizerException;
import org.idoox.xml.TokenizerSource;
import org.systinet.wasp.IWasp;
import org.systinet.wasp.soap.AttachmentPartInternal;
import org.systinet.wasp.soap.AutoCloseListener;
import org.systinet.wasp.soap.MessagePart;
import org.systinet.wasp.soap.MessageSource;
import org.systinet.wasp.soap.MimeHeadersSource;
import org.systinet.wasp.soap.WaspInternalSOAPMessage;
import org.systinet.wasp.soap.util.LazyFillingTokenizer;
import org.systinet.wasp.webservice.CallContext;

public class InitializableWaspSoapMessageImpl
extends WaspInternalSOAPMessage
implements PoolableObject {
    private MessageSource source;
    private Pool pool;
    private MimeHeadersImpl headers = new MimeHeadersImpl();
    private SOAPPartImpl soapPart = this.newSOAPPart();
    private TokenizerSource tokenizerSource = new TokenizerSource();
    private List attachments = new ArrayList();
    private boolean attachmentsMoved = false;
    private Iterator parts;
    volatile transient int attaModCount;
    private static final int BUFFER_SIZE = 1024;
    private MessageFactory messageFactory;
    private MessageImpl xmlRpcMessage;
    private String attachmentType;
    private static final String SOAP_ACTION = "SOAPAction";
    private static final String SOAP_ACTION_LC = "SOAPAction".toLowerCase();

    public InitializableWaspSoapMessageImpl() {
        this.setDefaultSOAPAction();
    }

    public void init(MessageSource source) throws SOAPException, IOException {
        this.source = source;
        this.headers.init((MimeHeadersSource)source);
        this.attachmentType = source.getAttachmentType();
        if (!this.getXMLProtocol().equals(source.getXMLProtocol())) {
            throw new SOAPException("Unable to initialize '" + this.getXMLProtocol() + "' WaspSOAPMessage from input which" + "contains " + source.getXMLProtocol() + " message!");
        }
        this.tokenizerSource.setTokenizer(source.getXMLPartTokenizer());
        this.soapPart.init(this.source.getXMLPart(), this.attachmentType, (Source)this.tokenizerSource);
        try {
            this.parts = source.getParts();
        }
        catch (IOException e) {
            throw new RuntimeWrappedException((Throwable)e);
        }
    }

    public String getXMLProtocol() {
        return "soap11";
    }

    public void release() {
        this.headers.removeAllHeaders();
        this.soapPart.clear();
        if (this.source != null) {
            if (!this.attachmentsMoved) {
                this.source.release();
            }
            this.source = null;
        }
        this.removeAllAttachments();
        this.parts = null;
        this.attachmentType = null;
        this.attachmentsMoved = false;
        this.setDefaultSOAPAction();
        if (this.pool != null) {
            Pool aux = this.pool;
            this.pool = null;
            aux.release((Object)this);
        }
        this.xmlRpcMessage = null;
    }

    public void setPool(Pool pool) {
        this.pool = pool;
    }

    public String getContentDescription() {
        try {
            return this.headers.getMimeHeader("content-description");
        }
        catch (IOException e) {
            throw new RuntimeWrappedException((Throwable)e);
        }
    }

    public void setContentDescription(String description) {
        this.headers.setHeader("Content-Description", description);
    }

    public SOAPPart getSOAPPart() {
        return this.soapPart;
    }

    public void removeAllAttachments() {
        if (!this.attachmentsMoved) {
            Iterator i = this.attachments.iterator();
            while (i.hasNext()) {
                AttachmentPartImpl part = (AttachmentPartImpl)i.next();
                part.release();
            }
        }
        this.attachments.clear();
    }

    public int countAttachments() {
        if (this.parts != null && this.parts.hasNext()) {
            Iterator i = this.getAttachments();
            while (i.hasNext()) {
                i.next();
            }
        }
        return this.attachments.size();
    }

    public Iterator getAttachments() {
        return new AttachmentPartIteraor(this.attaModCount);
    }

    public Iterator getAttachments(MimeHeaders headers) {
        return new NamedAttachmentPartIteraor(headers);
    }

    public void addAttachmentPart(AttachmentPart attachmentPart) {
        ++this.attaModCount;
        this.attachments.add(attachmentPart);
    }

    public AttachmentPart createAttachmentPart() {
        return AttachmentPartPool.getAttachmentPart();
    }

    public MimeHeaders getMimeHeaders() {
        return this.headers;
    }

    public void saveChanges() throws SOAPException {
    }

    public boolean saveRequired() {
        return false;
    }

    public void writeTo(OutputStream out) throws SOAPException, IOException {
        if (out instanceof OutputMessage) {
            OutputMessage om = (OutputMessage)out;
            if (this.attachmentType == null && this.attachments.size() > 0) {
                this.attachmentType = this.getDefaultAttachmentType();
                if (this.attachmentType == null) {
                    this.attachmentType = "multipart/related";
                }
            }
            this.headers.writeTo(om, false);
            if (this.attachmentType != null) {
                om.setMultipartType(this.attachmentType);
            }
            try {
                this.soapPart.writeTo(om, this.attachmentType);
            }
            catch (TokenizerException e) {
                throw new SOAPException((Throwable)e);
            }
            if (this.attachmentType != null) {
                byte[] buffer = new byte[1024];
                Iterator i = this.getAttachments();
                while (i.hasNext()) {
                    om.nextPart();
                    AttachmentPartImpl part = (AttachmentPartImpl)i.next();
                    part.writeTo(om, buffer);
                }
            }
            om.close();
        } else {
            try {
                this.soapPart.writeTo(out);
            }
            catch (TokenizerException e) {
                throw new SOAPException((Throwable)e);
            }
        }
    }

    private String getDefaultAttachmentType() {
        IWasp iwasp = (IWasp)Context.getInstance((String)"org.systinet.wasp.Wasp");
        return iwasp.getDefaultAttachmentType();
    }

    protected String getContentType() throws IOException {
        return this.headers.getMimeHeader(MimeHeadersSource.CONTENT_TYPE_HEADER_LC);
    }

    protected void setContentType(String contentType) {
        this.headers.setHeader(MimeHeadersSource.CONTENT_TYPE_HEADER_LC, contentType);
    }

    public String getSOAPAction() {
        try {
            String header = this.headers.getMimeHeader(SOAP_ACTION_LC);
            if (header == null || header.length() == 0) {
                return null;
            }
            if (header.charAt(0) == '\"' && header.charAt(header.length() - 1) == '\"') {
                return header.substring(1, header.length() - 1);
            }
            if ((header = header.trim()).charAt(0) == '\"' && header.charAt(header.length() - 1) == '\"') {
                return header.substring(1, header.length() - 1);
            }
            return header;
        }
        catch (IOException e) {
            throw new RuntimeWrappedException((Throwable)e);
        }
    }

    public void setSOAPAction(String soapAction) {
        if (soapAction == null) {
            soapAction = "";
        }
        StringBuffer sa = new StringBuffer();
        sa.append('\"');
        sa.append(soapAction);
        sa.append('\"');
        this.headers.setHeader(SOAP_ACTION, sa.toString());
    }

    public String getAttachmentType() {
        return this.attachmentType;
    }

    public void setAttachmentType(String attachmentType) {
        this.attachmentType = attachmentType;
    }

    public MessageFactory getMessageFactory() {
        return this.messageFactory;
    }

    public void setMessageFactory(MessageFactory messageFactory) {
        this.messageFactory = messageFactory;
    }

    public void setXmlRpcMessage(MessageImpl message) {
        this.xmlRpcMessage = message;
    }

    public MessageImpl getXmlRpcMessage() {
        return this.xmlRpcMessage;
    }

    public void setAutoClose(boolean close, AutoCloseListener listener) {
        if (this.source != null) {
            this.source.setAutoClose(close, listener);
        }
    }

    public Tokenizer getBodyTokenzier() throws TokenizerException, IOException, SOAPException {
        return this.soapPart.getBodyTokenizer();
    }

    public void startProcessing() throws SOAPException {
        this.soapPart.startProcessing();
    }

    public void setLazyFillingTokenizer(LazyFillingTokenizer tokenizer) {
        this.soapPart.setLazyFillingTokenizer(tokenizer);
    }

    public void writeNamespaces(SOAPMethodInfo methodInfo, Set namespaces, boolean writeNamespaces) throws SOAPException {
        SOAPEnvelope envelope = this.getSOAPPart().getEnvelope();
        if (writeNamespaces) {
            int pos = 0;
            Iterator i = namespaces.iterator();
            while (i.hasNext()) {
                String ns = (String)i.next();
                if ("".equals(ns) || "http://www.w3.org/XML/1998/namespace".equals(ns) || "http://www.w3.org/2001/XMLSchema-instance".equals(ns) || "http://www.w3.org/2001/XMLSchema".equals(ns)) continue;
                envelope.addNamespaceDeclaration("wn" + pos++, ns);
            }
        }
        envelope.addNamespaceDeclaration("d", "http://www.w3.org/2001/XMLSchema");
        envelope.addNamespaceDeclaration("i", "http://www.w3.org/2001/XMLSchema-instance");
    }

    public void setEnvelopeOutCache(EnvelopeOutCache envelopeOutCache) {
        this.soapPart.setEnvelopeOutCache(envelopeOutCache);
    }

    public boolean hasFault() throws SOAPException {
        return this.soapPart.hasFault();
    }

    public boolean hasFault(CallContext callContext) throws SOAPException {
        if (callContext != null && callContext.getContextData().get("MessageSourceImpl.faultNotPresent") != null) {
            return false;
        }
        return this.getSOAPPart().getEnvelope().getBody().hasFault();
    }

    public void setEnvelopePrefix(String prefix) throws SOAPException {
        if (prefix == null) {
            return;
        }
        this.soapPart.setEnvelopePrefix(prefix);
    }

    public void close() throws SOAPException {
        this.soapPart.load();
        if (this.source != null) {
            this.source.release();
            this.source = null;
        }
    }

    public void cache() {
        if (this.source != null) {
            this.source.cache();
        }
    }

    public Object clone() {
        try {
            SOAPMessage ret = this.messageFactory.createMessage();
            ret.getSOAPPart().getEnvelope().getHeader().detachNode();
            MimeHeaders hs = ret.getMimeHeaders();
            Iterator i = this.headers.getHeadersMap().entrySet().iterator();
            while (i.hasNext()) {
                Map.Entry entry = i.next();
                hs.addHeader((String)entry.getKey(), (String)entry.getValue());
            }
            this.cloneSOAPPart(ret.getSOAPPart());
            Iterator i2 = this.getAttachments();
            while (i2.hasNext()) {
                AttachmentPart attachmentPart = (AttachmentPart)i2.next();
                AttachmentPart retAttachmentPart = ret.createAttachmentPart();
                MessagePart messagePart = ((AttachmentPartInternal)attachmentPart).getMessagePart();
                if (messagePart != null) {
                    ((AttachmentPartInternal)retAttachmentPart).init(messagePart);
                } else {
                    Object content = attachmentPart.getContent();
                    String contentType = attachmentPart.getContentType();
                    if (content instanceof InputStream) {
                        InputStream inputStream = (InputStream)content;
                        int bufferSize = 1024;
                        byte[] buffer = new byte[bufferSize];
                        int l = 0;
                        try {
                            int read;
                            while ((read = inputStream.read(buffer, l, buffer.length - l)) >= 0) {
                                if ((l += read) != bufferSize) continue;
                                byte[] newBuffer = new byte[bufferSize *= 2];
                                System.arraycopy(buffer, 0, newBuffer, 0, buffer.length);
                                buffer = newBuffer;
                            }
                        }
                        catch (IOException e) {
                            throw new RuntimeWrappedException((Throwable)e);
                        }
                        attachmentPart.setContent((Object)new ByteArrayInputStream(buffer, 0, l), contentType);
                        content = new ByteArrayInputStream(buffer, 0, l);
                    }
                    retAttachmentPart.setContent(content, contentType);
                    Iterator allMimeHeaders = attachmentPart.getAllMimeHeaders();
                    while (allMimeHeaders.hasNext()) {
                        MimeHeader mimeHeader = (MimeHeader)allMimeHeaders.next();
                        retAttachmentPart.addMimeHeader(mimeHeader.getName(), mimeHeader.getValue());
                    }
                }
                ret.addAttachmentPart(retAttachmentPart);
            }
            return ret;
        }
        catch (SOAPException e) {
            e.printStackTrace();
            return null;
        }
    }

    private void cloneSOAPPart(SOAPPart soapPart) throws SOAPException {
        SOAPEnvelope envelopeFrom = this.soapPart.getEnvelope();
        SOAPEnvelope envelopeTo = soapPart.getEnvelope();
        ArrayList removeNodes = new ArrayList();
        Iterator i = envelopeTo.getChildElements();
        while (i.hasNext()) {
            removeNodes.add(i.next());
        }
        Iterator i2 = removeNodes.iterator();
        while (i2.hasNext()) {
            ((Node)i2.next()).detachNode();
        }
        this.cloneElement((SOAPElement)envelopeFrom, (SOAPElement)envelopeTo);
    }

    private void cloneElement(SOAPElement fromParent, SOAPElement toParent) throws SOAPException {
        Iterator i = fromParent.getNamespacePrefixes();
        while (i.hasNext()) {
            String prefix = (String)i.next();
            toParent.addNamespaceDeclaration(prefix, fromParent.getNamespaceURI(prefix));
        }
        Iterator i2 = fromParent.getChildElements();
        while (i2.hasNext()) {
            Node fromNode = (Node)i2.next();
            if (fromNode instanceof Text) {
                toParent.addTextNode(fromNode.getValue());
                continue;
            }
            SOAPElement fromElement = (SOAPElement)fromNode;
            Name elementName = fromElement.getElementName();
            SOAPElement toElement = toParent.addChildElement(elementName.getLocalName(), elementName.getPrefix(), elementName.getURI());
            this.cloneElement(fromElement, toElement);
        }
        Iterator i3 = fromParent.getAllAttributes();
        while (i3.hasNext()) {
            Name attribute = (Name)((NameImpl)i3.next()).clone();
            toParent.addAttribute(attribute, fromParent.getAttributeValue(attribute));
        }
    }

    protected SOAPPartImpl newSOAPPart() {
        return new SOAPPartImpl();
    }

    protected void setDefaultSOAPAction() {
        this.setSOAPAction("");
    }

    public QName getFaultCode() throws IllegalStateException, SOAPException {
        return this.soapPart.getFaultCode();
    }

    public void moveAttachments(WaspInternalSOAPMessage targetMessage) throws SOAPException {
        Iterator attachments = this.getAttachments();
        while (attachments.hasNext()) {
            AttachmentPart attachmentPart = (AttachmentPart)attachments.next();
            targetMessage.addAttachmentPart(attachmentPart);
        }
        this.attachmentsMoved = true;
    }

    static /* synthetic */ Iterator access$100(InitializableWaspSoapMessageImpl x0) {
        return x0.parts;
    }

    private class NamedAttachmentPartIteraor
    implements Iterator {
        private MimeHeaders headers;
        private Iterator all;
        private AttachmentPart next;

        public NamedAttachmentPartIteraor(MimeHeaders headers) {
            this.headers = headers;
            this.all = InitializableWaspSoapMessageImpl.this.getAttachments();
        }

        public boolean hasNext() {
            AttachmentPartImpl aux = null;
            while (this.all.hasNext()) {
                aux = (AttachmentPartImpl)this.all.next();
                if (!aux.hasAllHeaders(this.headers)) continue;
                this.next = aux;
                return true;
            }
            return false;
        }

        public Object next() {
            if (this.next != null || this.hasNext()) {
                AttachmentPart ret = this.next;
                this.next = null;
                return ret;
            }
            throw new NoSuchElementException("Interator has reached the last element.");
        }

        public void remove() {
            throw new IllegalStateException();
        }
    }

    private class AttachmentPartIteraor
    implements Iterator {
        private int version;
        private int index;

        public AttachmentPartIteraor(int version) {
            this.version = version;
        }

        /*
         * Unable to fully structure code
         */
        public boolean hasNext() {
            if (this.version != InitializableWaspSoapMessageImpl.this.attaModCount) {
                throw new ConcurrentModificationException();
            }
            if (InitializableWaspSoapMessageImpl.access$000(InitializableWaspSoapMessageImpl.this).size() > this.index) {
                return true;
            }
            if (InitializableWaspSoapMessageImpl.access$100(InitializableWaspSoapMessageImpl.this) == null) {
                return false;
            }
            if (InitializableWaspSoapMessageImpl.access$100(InitializableWaspSoapMessageImpl.this).hasNext()) ** GOTO lbl16
            return false;
lbl-1000:
            // 1 sources

            {
                part = (MessagePartImpl)InitializableWaspSoapMessageImpl.access$100(InitializableWaspSoapMessageImpl.this).next();
                if (!part.isXmlPart()) {
                    attachemnt = (AttachmentPartImpl)InitializableWaspSoapMessageImpl.this.createAttachmentPart();
                    attachemnt.init((MessagePart)part);
                    InitializableWaspSoapMessageImpl.access$000(InitializableWaspSoapMessageImpl.this).add(attachemnt);
                }
                if (!InitializableWaspSoapMessageImpl.access$100(InitializableWaspSoapMessageImpl.this).hasNext()) break;
lbl16:
                // 2 sources

                ** while (InitializableWaspSoapMessageImpl.access$000((InitializableWaspSoapMessageImpl)InitializableWaspSoapMessageImpl.this).size() <= this.index)
            }
lbl17:
            // 2 sources

            return InitializableWaspSoapMessageImpl.access$000(InitializableWaspSoapMessageImpl.this).size() > this.index;
        }

        public Object next() {
            if (InitializableWaspSoapMessageImpl.this.attachments.size() > this.index) {
                return InitializableWaspSoapMessageImpl.this.attachments.get(this.index++);
            }
            if (this.hasNext()) {
                return InitializableWaspSoapMessageImpl.this.attachments.get(this.index++);
            }
            throw new NoSuchElementException("Interator has reached the last element.");
        }

        public void remove() {
            throw new IllegalStateException();
        }
    }
}

