/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.serialization.xsdbuiltin;

import org.idoox.config.Configurable;
import org.idoox.wasp.serialization.DeserializationChain;
import org.idoox.wasp.serialization.DeserializationContext;
import org.idoox.wasp.serialization.Reference;
import org.idoox.wasp.serialization.XMLDeserializer;
import org.idoox.wasp.serialization.xsdbuiltin.DateTime;
import org.idoox.xml.Token;
import org.idoox.xml.Tokenizer;
import org.idoox.xml.schema.Type;
import org.idoox.xmlrpc.MessageProcessingException;

public class XMLDateDeserializer
implements XMLDeserializer {
    public String getMechanismType() {
        return "systinet:xmlser/1.0";
    }

    public Object deserialize(Tokenizer dataTokenizer, Token currentToken, Class targetClass, DeserializationContext context, DeserializationChain chain) throws MessageProcessingException {
        XMLDeserializer deserializer = (XMLDeserializer)chain.getNextDeserializerAs("systinet:xmlser/1.0");
        Object ret = deserializer.deserialize(dataTokenizer, currentToken, targetClass, context, chain);
        if (ret == null) {
            return null;
        }
        if (ret instanceof Reference) {
            return new DateReference((Reference)ret);
        }
        return ret;
    }

    public void init(Configurable conf) {
    }

    class DateReference
    implements Reference {
        Reference prev;
        Reference next;
        Class valueClass;
        Type schemaType;
        Object value;

        DateReference(Reference prev) {
            this.prev = prev;
            this.valueClass = prev.getValueClass();
            this.schemaType = prev.getSchemaType();
            prev.setNextReference((Reference)this);
        }

        public Type getSchemaType() {
            if (this.next != null) {
                return this.next.getSchemaType();
            }
            return this.schemaType;
        }

        public void setNextReference(Reference nextReference) {
            if (this.next != null) {
                this.next.setNextReference(nextReference);
            } else {
                this.next = nextReference;
            }
        }

        public Object getObjectValue() {
            if (this.next != null) {
                return this.next.getObjectValue();
            }
            return this.value;
        }

        public void setObjectValue(Object value) {
            this.value = ((DateTime)value).toJavaUtilDate();
            if (this.next != null) {
                this.next.setObjectValue(this.value);
            }
        }

        public Class getValueClass() {
            if (this.next != null) {
                return this.next.getValueClass();
            }
            return this.valueClass;
        }
    }
}

