/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.serialization.xml.msnet;

import com.idoox.wasp.serialization.SerializationHelper;
import java.util.Iterator;
import java.util.Set;
import javax.xml.namespace.QName;
import org.idoox.config.Configurable;
import org.idoox.wasp.serialization.SchemaContext;
import org.idoox.wasp.serialization.SerializationChain;
import org.idoox.wasp.serialization.SerializationContext;
import org.idoox.wasp.serialization.XMLSerializer;
import org.idoox.xml.TokenWriter;
import org.idoox.xml.schema.Member;
import org.idoox.xml.schema.SchemaConstruct;
import org.idoox.xmlrpc.MessageCreatingException;

public class XMLSetSerializer
implements XMLSerializer {
    public void serialize(TokenWriter dataWriter, Object data, SerializationContext context, SerializationChain next) throws MessageCreatingException {
        try {
            QName memberQName = null;
            Object id = null;
            String prefix = null;
            Member setMember = (Member)context.getCurrentSchemaConstruct();
            memberQName = setMember.getName();
            dataWriter.enter(memberQName.getNamespaceURI(), memberQName.getLocalPart());
            QName schemaTypeQName = context.getCurrentConstructSchemaType().getName();
            prefix = dataWriter.getPrefixForNamespace(schemaTypeQName.getNamespaceURI());
            if (prefix == null) {
                prefix = "msn";
                dataWriter.setPrefixForNamespace(prefix, schemaTypeQName.getNamespaceURI());
            }
            dataWriter.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "type", prefix + ":" + schemaTypeQName.getLocalPart());
            SchemaContext.State arrayState = context.enterCurrentMember();
            Member arrayMember = context.nextMember();
            memberQName = arrayMember.getName();
            dataWriter.enter(memberQName.getNamespaceURI(), memberQName.getLocalPart());
            SchemaContext.State itemState = context.enterCurrentMember();
            Member itemMember = context.nextMember();
            memberQName = itemMember.getName();
            Set set = (Set)data;
            Iterator setIter = set.iterator();
            Member fakeMember = new Member(memberQName, itemMember.getType(), true);
            while (setIter.hasNext()) {
                Object item = setIter.next();
                SchemaContext.State state = context.putSchemaConstruct((SchemaConstruct)fakeMember);
                SerializationHelper.serialize((TokenWriter)dataWriter, item, (SerializationContext)context);
                context.leave(state);
            }
            context.leave(itemState);
            dataWriter.leave();
            context.leave(arrayState);
            dataWriter.leave();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessageCreatingException((Throwable)e);
        }
    }

    public void grabReferences(Object data, SerializationContext context, SerializationChain next) throws MessageCreatingException {
        SchemaContext.State itemState;
        SchemaContext.State arrayState;
        Member member = (Member)context.getCurrentSchemaConstruct();
        if (context.registerReference(data, member.getType()) == null) {
            Set set = (Set)data;
            arrayState = context.enterCurrentMember();
            context.nextMember();
            itemState = context.enterCurrentMember();
            Member itemMember = context.nextMember();
            Iterator setIter = set.iterator();
            while (setIter.hasNext()) {
                SchemaContext.State state = context.putSchemaConstruct((SchemaConstruct)itemMember);
                SerializationHelper.grabReferences(setIter.next(), (SerializationContext)context);
                context.leave(state);
            }
        } else {
            throw new MessageCreatingException("In document/literal it is not allowed to have multireferences. Data already registered: " + data.getClass().getName());
        }
        context.leave(itemState);
        context.leave(arrayState);
    }

    public String getMechanismType() {
        return "systinet:xmlser/1.0";
    }

    public void init(Configurable conf) {
    }
}

