/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.serialization.xml.msnet;

import com.idoox.wasp.serialization.SerializationHelper;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.QName;
import org.idoox.config.Configurable;
import org.idoox.wasp.serialization.SchemaContext;
import org.idoox.wasp.serialization.SerializationChain;
import org.idoox.wasp.serialization.SerializationContext;
import org.idoox.wasp.serialization.XMLSerializer;
import org.idoox.xml.TokenWriter;
import org.idoox.xml.schema.Member;
import org.idoox.xml.schema.SchemaConstruct;
import org.idoox.xmlrpc.MessageCreatingException;

public class XMLListSerializer
implements XMLSerializer {
    public void serialize(TokenWriter dataWriter, Object data, SerializationContext context, SerializationChain next) throws MessageCreatingException {
        try {
            boolean memeber;
            QName memberQName = null;
            SchemaConstruct currentSchemaConstruct = context.getCurrentSchemaConstruct();
            if (currentSchemaConstruct instanceof Member) {
                memeber = true;
                Member listMember = (Member)currentSchemaConstruct;
                memberQName = listMember.getName();
                dataWriter.enter(memberQName.getNamespaceURI(), memberQName.getLocalPart());
                QName schemaTypeQName = context.getCurrentConstructSchemaType().getName();
                String prefix = dataWriter.getPrefixForNamespace(schemaTypeQName.getNamespaceURI());
                if (prefix == null) {
                    prefix = "msn";
                    dataWriter.setPrefixForNamespace(prefix, schemaTypeQName.getNamespaceURI());
                }
                dataWriter.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "type", prefix + ":" + schemaTypeQName.getLocalPart());
            } else {
                memeber = false;
            }
            SchemaContext.State arrayState = context.enterCurrentMember();
            Member arrayMember = context.nextMember();
            memberQName = arrayMember.getName();
            dataWriter.enter(memberQName.getNamespaceURI(), memberQName.getLocalPart());
            SchemaContext.State itemState = context.enterCurrentMember();
            Member itemMember = context.nextMember();
            memberQName = itemMember.getName();
            List list = (List)data;
            Member fakeMember = new Member(itemMember.getName(), itemMember.getType(), true);
            Iterator listIter = list.iterator();
            while (listIter.hasNext()) {
                SchemaContext.State state = context.putSchemaConstruct((SchemaConstruct)fakeMember);
                SerializationHelper.serialize((TokenWriter)dataWriter, listIter.next(), (SerializationContext)context);
                context.leave(state);
            }
            context.leave(itemState);
            dataWriter.leave();
            context.leave(arrayState);
            if (memeber) {
                dataWriter.leave();
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessageCreatingException((Throwable)e);
        }
    }

    public void grabReferences(Object data, SerializationContext context, SerializationChain next) throws MessageCreatingException {
        SchemaContext.State itemState;
        SchemaContext.State arrayState;
        Member member = (Member)context.getCurrentSchemaConstruct();
        if (context.registerReference(data, member.getType()) == null) {
            List list = (List)data;
            arrayState = context.enterCurrentMember();
            context.nextMember();
            itemState = context.enterCurrentMember();
            Member itemMember = context.nextMember();
            Iterator listIter = list.iterator();
            while (listIter.hasNext()) {
                SchemaContext.State state = context.putSchemaConstruct((SchemaConstruct)itemMember);
                SerializationHelper.grabReferences(listIter.next(), (SerializationContext)context);
                context.leave(state);
            }
        } else {
            throw new MessageCreatingException("In document/literal it is not allowed to have multireferences. Data already registered: " + data.getClass().getName());
        }
        context.leave(itemState);
        context.leave(arrayState);
    }

    public String getMechanismType() {
        return "systinet:xmlser/1.0";
    }

    public void init(Configurable conf) {
    }
}

