/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.serialization.xml;

import com.idoox.wasp.Constants;
import com.idoox.wasp.serialization.ChoiceHelper;
import com.idoox.wasp.serialization.DuplicateAccessException;
import com.idoox.wasp.serialization.EnumHelper;
import com.idoox.wasp.serialization.PrimitiveTypeAccessor;
import com.idoox.wasp.serialization.SerializationChainImpl;
import com.idoox.wasp.serialization.SerializationException;
import com.idoox.wasp.serialization.WaspSerializationHelper;
import com.idoox.xml.schema.util.XMLSchemaUtil;
import java.beans.IntrospectionException;
import java.beans.PropertyDescriptor;
import java.io.IOException;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.idoox.config.Configurable;
import org.idoox.wasp.serialization.SchemaContext;
import org.idoox.wasp.serialization.SerializationChain;
import org.idoox.wasp.serialization.SerializationContext;
import org.idoox.wasp.serialization.XMLSerializer;
import org.idoox.xml.TokenWriter;
import org.idoox.xml.schema.Attribute;
import org.idoox.xml.schema.AttributeGroup;
import org.idoox.xml.schema.Member;
import org.idoox.xml.schema.RepeatableSchemaConstruct;
import org.idoox.xml.schema.SchemaConstruct;
import org.idoox.xml.schema.SimpleTypeEnumExtension;
import org.idoox.xml.schema.Type;
import org.idoox.xmlrpc.MessageCreatingException;
import org.systinet.wasp.webservice.CallContext;
import org.systinet.wasp.webservice.Current;
import org.systinet.xml.schema.validation.ValidationConfig;
import org.systinet.xml.schema.validation.ValidationException;

public class XMLReflectionSerializer
implements XMLSerializer {
    private static Set base64SchemaTypes = new HashSet(19);
    static /* synthetic */ Class class$java$lang$Object;

    public void serialize(TokenWriter dataWriter, Object data, SerializationContext context, SerializationChain next) throws MessageCreatingException {
        block14: {
            try {
                SchemaConstruct.ConstructType typeCt = context.getCurrentConstructType();
                Type type = context.getCurrentConstructSchemaType();
                if (typeCt == SchemaConstruct.ConstructType.ATTRIBUTE) {
                    if (data == null) break block14;
                    String toWrite = type.getKind() == 20 ? (String)this.getValue(data) : (type.getKind() == 17 ? this.getListValue(data) : PrimitiveTypeAccessor.writePrimitiveObject((Object)data));
                    if (toWrite != null) {
                        QName name = context.getCurrentConstructName();
                        dataWriter.writeAttribute(name.getNamespaceURI(), name.getLocalPart(), toWrite);
                        break block14;
                    }
                    throw new MessageCreatingException("No mapping for " + data + " into an attribute");
                }
                if (typeCt == SchemaConstruct.ConstructType.MEMBER) {
                    if (data == null) {
                        if (type.getMinOccurs() != 0 && type.getMaxOccurs() == 1) {
                            this.writeNil(dataWriter, context.getCurrentConstructName());
                        }
                        return;
                    }
                    if (data.getClass().isArray()) {
                        this.writeArray(dataWriter, data, context);
                    } else {
                        this.writeStructure(dataWriter, data, context, next);
                    }
                    break block14;
                }
                if (typeCt == SchemaConstruct.ConstructType.TYPE) {
                    if (data.getClass().isArray()) {
                        this.writeArrayContent(dataWriter, data, context);
                    } else {
                        this.writeStructureContent(dataWriter, data, context, next);
                    }
                    break block14;
                }
                throw new MessageCreatingException("Can not serialize " + data.getClass().getName() + ", unsupported schema construct on context stack: " + context.toString());
            }
            catch (MessageCreatingException e) {
                throw e;
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new MessageCreatingException("Failed to serialize a class " + data.getClass().getName(), (Throwable)e);
            }
        }
    }

    public void grabReferences(Object data, SerializationContext context, SerializationChain next) throws MessageCreatingException {
    }

    public String getMechanismType() {
        return "systinet:xmlser/1.0";
    }

    public void init(Configurable conf) {
    }

    private void writeNil(TokenWriter dataWriter, QName elementName) throws IOException {
        dataWriter.enter(elementName.getNamespaceURI(), elementName.getLocalPart());
        dataWriter.writeAttribute(Constants.XSI_NIL_QNAME.getNamespaceURI(), Constants.XSI_NIL_QNAME.getLocalPart(), "1");
        dataWriter.leave();
    }

    private void writeArray(TokenWriter dataWriter, Object data, SerializationContext context) throws MessageCreatingException, IOException {
        Member member = (Member)context.getCurrentSchemaConstruct();
        if (member.getMaxOccurs() > 1 || member.getMaxOccurs() == -1) {
            this.writeArrayContent(dataWriter, data, context);
        } else {
            Type t;
            QName typeName = member.getType().getName();
            if (typeName != null && base64SchemaTypes.contains(typeName)) {
                this.writeBase64(dataWriter, member, typeName, data);
                return;
            }
            QName elementName = member.getName();
            dataWriter.enter(elementName.getNamespaceURI(), elementName.getLocalPart());
            if (typeName != null) {
                dataWriter.writeAttribute(Constants.XSI_TYPE_QNAME.getNamespaceURI(), Constants.XSI_TYPE_QNAME.getLocalPart(), dataWriter.getPrefixForNamespace(typeName.getNamespaceURI()) + ":" + typeName.getLocalPart());
            }
            if ((t = member.getType()).getMaxOccurs() > 1 || t.getMaxOccurs() == -1) {
                this.writeRepeatedSequence(dataWriter, data, context);
            } else if (this.extendsBase64(t)) {
                dataWriter.writeContent(PrimitiveTypeAccessor.writePrimitiveObject((Object)data));
            } else {
                SchemaConstruct[] subconstructs = XMLSchemaUtil.getAllSubconstructs((Type)t);
                if (subconstructs == null || subconstructs.length != 1) {
                    throw new MessageCreatingException("Do not know how to serialize array to " + member.toIndentedString(0, new HashSet()));
                }
                SchemaContext.State state = context.putSchemaConstruct(subconstructs[0]);
                this.writeArrayContent(dataWriter, data, context);
                context.leave(state);
            }
            dataWriter.leave();
        }
    }

    private boolean extendsBase64(Type t) {
        while ((t = t.getBaseType()) != null) {
            QName name = t.getName();
            if (name == null || !base64SchemaTypes.contains(name)) continue;
            return true;
        }
        return false;
    }

    private void writeArrayContent(TokenWriter dataWriter, Object data, SerializationContext context) throws MessageCreatingException {
        Type type = context.getCurrentConstructSchemaType();
        SchemaConstruct.ConstructType typeCt = context.getCurrentConstructType();
        if (typeCt == SchemaConstruct.ConstructType.MEMBER || typeCt == SchemaConstruct.ConstructType.TYPE) {
            SchemaConstruct arraySchemaConstruct = (SchemaConstruct)context.getCurrentSchemaConstruct().clone();
            RepeatableSchemaConstruct repeatableSchemaConstruct = (RepeatableSchemaConstruct)arraySchemaConstruct;
            if (data != null && repeatableSchemaConstruct.getMinOccurs() > Array.getLength(data) && this.shouldValidateMinOccursOut()) {
                throw new ValidationException("Unable to serialize array according to schema type " + repeatableSchemaConstruct + ". It declares minOccurs=" + repeatableSchemaConstruct.getMinOccurs() + " but length of an array is " + Array.getLength(data));
            }
            repeatableSchemaConstruct.setMinOccurs(1);
            repeatableSchemaConstruct.setMaxOccurs(1);
            SerializationChain chain = null;
            XMLSerializer itemSerializer = null;
            Class previousObjectClass = null;
            int i = 0;
            while (i < Array.getLength(data)) {
                Object object = Array.get(data, i);
                Class objectClass = object != null ? object.getClass() : (class$java$lang$Object == null ? XMLReflectionSerializer.class$("java.lang.Object") : class$java$lang$Object);
                SchemaContext.State state = context.putSchemaConstruct(arraySchemaConstruct);
                if (objectClass != previousObjectClass || chain == null) {
                    if (chain != null) {
                        context.releaseSerializationChain(chain);
                    }
                    chain = context.getSerializationChain(objectClass);
                    itemSerializer = (XMLSerializer)chain.getNextSerializerAs("systinet:xmlser/1.0");
                    previousObjectClass = objectClass;
                }
                int chainState = ((SerializationChainImpl)chain).getSerializerState();
                itemSerializer.serialize(dataWriter, object, context, chain);
                ((SerializationChainImpl)chain).setSerializerState(chainState);
                context.leave(state);
                ++i;
            }
            if (chain != null) {
                context.releaseSerializationChain(chain);
            }
        } else {
            throw new UnsupportedOperationException("Unhandler construct type in schema context: " + type.toString());
        }
    }

    private void writeRepeatedSequence(TokenWriter dataWriter, Object data, SerializationContext context) throws MessageCreatingException {
        Type currentType = context.getCurrentConstructSchemaType();
        Type memberType = (Type)currentType.clone();
        memberType.setMinOccurs(1);
        memberType.setMaxOccurs(1);
        SerializationChain chain = null;
        XMLSerializer schemaConstructSerializer = null;
        Class previousObjectClass = null;
        int i = 0;
        while (i < Array.getLength(data)) {
            Object object = Array.get(data, i);
            Class objectClass = object != null ? object.getClass() : (class$java$lang$Object == null ? XMLReflectionSerializer.class$("java.lang.Object") : class$java$lang$Object);
            SchemaContext.State state = context.putSchemaConstruct((SchemaConstruct)memberType);
            if (objectClass != previousObjectClass || chain == null) {
                if (chain != null) {
                    context.releaseSerializationChain(chain);
                }
                chain = context.getSerializationChain(objectClass);
                schemaConstructSerializer = (XMLSerializer)chain.getNextSerializerAs("systinet:xmlser/1.0");
                previousObjectClass = objectClass;
            }
            schemaConstructSerializer.serialize(dataWriter, object, context, chain);
            context.leave(state);
            ++i;
        }
        if (chain != null) {
            context.releaseSerializationChain(chain);
        }
    }

    private void writeAttributes(TokenWriter dataWriter, Object data, SerializationContext context, SerializationChain next, Type type) throws MessageCreatingException, IOException, DuplicateAccessException, IntrospectionException, IllegalAccessException, InvocationTargetException {
        this.writeAttributes(dataWriter, data, context, type.getAttributes());
        this.writeAttributeGroups(dataWriter, data, context, next, type.getAttributeGroups());
    }

    private void writeAttributeGroups(TokenWriter dataWriter, Object data, SerializationContext context, SerializationChain next, AttributeGroup[] attributeGroups) throws MessageCreatingException, IOException, DuplicateAccessException, IntrospectionException, IllegalAccessException, InvocationTargetException {
        if (attributeGroups == null) {
            return;
        }
        int i = 0;
        while (i < attributeGroups.length) {
            this.writeAttributes(dataWriter, data, context, attributeGroups[i].getAttributes());
            this.writeAttributeGroups(dataWriter, data, context, next, attributeGroups[i].getAttributeGroups());
            ++i;
        }
    }

    private void writeAttributes(TokenWriter dataWriter, Object data, SerializationContext context, Attribute[] attributes) throws MessageCreatingException, DuplicateAccessException, IntrospectionException, IllegalAccessException, InvocationTargetException {
        if (attributes == null) {
            return;
        }
        Map props = WaspSerializationHelper.getProperties(data.getClass());
        int i = 0;
        while (i < attributes.length) {
            SchemaConstruct attributeConstruct = attributes[i].getReferencedConstruct();
            if (attributeConstruct == null) {
                attributeConstruct = attributes[i];
            }
            SchemaContext.State state = context.putSchemaConstruct(attributeConstruct);
            String javaName = WaspSerializationHelper.getConstructJavaMemberName((SchemaConstruct)context.getCurrentSchemaConstruct());
            Object toSerialize = data;
            if (javaName != null) {
                toSerialize = this.getSerializedObject(data, props, javaName);
            }
            SerializationChain chain = context.getSerializationChain(toSerialize != null ? toSerialize.getClass() : (class$java$lang$Object == null ? XMLReflectionSerializer.class$("java.lang.Object") : class$java$lang$Object));
            XMLSerializer attrSerializer = (XMLSerializer)chain.getNextSerializerAs("systinet:xmlser/1.0");
            attrSerializer.serialize(dataWriter, toSerialize, context, chain);
            context.releaseSerializationChain(chain);
            context.leave(state);
            ++i;
        }
    }

    private void writeStructure(TokenWriter dataWriter, Object data, SerializationContext context, SerializationChain next) throws MessageCreatingException {
        try {
            QName elementName = context.getCurrentConstructName();
            Type elementType = context.getCurrentConstructSchemaType();
            dataWriter.enter(elementName.getNamespaceURI(), elementName.getLocalPart());
            QName typeQName = elementType.getName();
            if (typeQName == null && context.typeOfCurrentConstructReplaced()) {
                Type type = elementType;
                while (typeQName == null) {
                    if ((type = type.getBaseType()) == null) break;
                    typeQName = type.getName();
                }
            }
            if (typeQName != null) {
                dataWriter.writeAttribute(Constants.XSI_TYPE_QNAME.getNamespaceURI(), Constants.XSI_TYPE_QNAME.getLocalPart(), dataWriter.getPrefixForNamespace(typeQName.getNamespaceURI()) + ":" + typeQName.getLocalPart());
            }
            this.writeAttributes(dataWriter, data, context, next, elementType);
            if ((elementType.getKind() & 0x10) != 0) {
                String toWrite = null;
                StringBuffer buffer = new StringBuffer();
                if (this.writeSimpleTypeObject(elementType, data, buffer)) {
                    toWrite = buffer.toString();
                } else {
                    QName ptype = PrimitiveTypeAccessor.getPrimitiveType(data.getClass());
                    if (ptype == null) {
                        Object dataValue = this.getValue(data);
                        if (dataValue == null) {
                            dataWriter.writeAttribute("http://www.w3.org/2001/XMLSchema-instance", "nil", "true");
                        } else {
                            Type baseType;
                            boolean primitiveComplex = false;
                            if (elementType.getKind() == 19 && (baseType = elementType.getBaseType()) != null && this.writeSimpleTypeObject(baseType, dataValue, buffer)) {
                                primitiveComplex = true;
                                toWrite = buffer.toString();
                            }
                            if (!primitiveComplex) {
                                toWrite = PrimitiveTypeAccessor.writePrimitiveObject((Object)dataValue);
                            }
                        }
                    } else {
                        String nsURI = ptype.getNamespaceURI();
                        if ("QName".equals(ptype.getLocalPart()) && "http://www.w3.org/2001/XMLSchema".equals(nsURI) || "http://www.w3.org/2000/10/XMLSchema".equals(nsURI) || "http://www.w3.org/1999/XMLSchema".equals(nsURI)) {
                            QName qName = (QName)data;
                            String prefix = dataWriter.getPrefixForNamespace(qName.getNamespaceURI());
                            if (prefix != null && prefix.length() > 0) {
                                dataWriter.writeContent(prefix + ":" + qName.getLocalPart());
                            } else {
                                dataWriter.writeContent(qName.getLocalPart());
                            }
                            toWrite = null;
                        } else {
                            toWrite = PrimitiveTypeAccessor.writePrimitiveObject((Object)data);
                        }
                    }
                }
                if (toWrite != null) {
                    dataWriter.writeContent(toWrite);
                }
            } else if (elementType.getKind() == 38) {
                this.serializeChoice(data, elementType, context, dataWriter, next);
            } else {
                this.writeStructureContent(dataWriter, data, context, next);
            }
            dataWriter.leave();
        }
        catch (MessageCreatingException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessageCreatingException((Throwable)e);
        }
    }

    private boolean writeSimpleTypeObject(Type elementType, Object data, StringBuffer buffer) throws IllegalAccessException, MessageCreatingException {
        if (elementType.getKind() == 17) {
            buffer.append(this.getListValue(data));
            return true;
        }
        if (elementType.getKind() == 20) {
            SimpleTypeEnumExtension ste = (SimpleTypeEnumExtension)elementType.getExtension("SimpleTypeEnumExtension");
            String toWrite = ste.getXMLValue(EnumHelper.getEnumField((Object)data));
            if (toWrite == null) {
                throw new MessageCreatingException("Failed to serialize enumerated class " + data.getClass().getName() + ", type: " + elementType);
            }
            buffer.append(toWrite);
            return true;
        }
        return false;
    }

    private void writeStructureContent(TokenWriter dataWriter, Object data, SerializationContext context, SerializationChain next) throws MessageCreatingException {
        try {
            if (context.getCurrentConstructSchemaType().getKind() == 38) {
                this.serializeChoice(data, context.getCurrentConstructSchemaType(), context, dataWriter, next);
                return;
            }
            Map props = WaspSerializationHelper.getProperties(data.getClass());
            SchemaContext.State state = context.enterCurrentMember();
            while (context.nextSchemaConstruct() != null) {
                String javaName = WaspSerializationHelper.getConstructJavaMemberName((SchemaConstruct)context.getCurrentSchemaConstruct());
                Object toSerialize = data;
                if (javaName != null) {
                    toSerialize = this.getSerializedObject(data, props, javaName);
                    SerializationChain chain = context.getSerializationChain(toSerialize != null ? toSerialize.getClass() : (class$java$lang$Object == null ? XMLReflectionSerializer.class$("java.lang.Object") : class$java$lang$Object));
                    XMLSerializer schemaConstructSerializer = (XMLSerializer)chain.getNextSerializerAs("systinet:xmlser/1.0");
                    schemaConstructSerializer.serialize(dataWriter, toSerialize, context, chain);
                    context.releaseSerializationChain(chain);
                    continue;
                }
                this.serialize(dataWriter, data, context, next);
            }
            context.leave(state);
        }
        catch (MessageCreatingException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessageCreatingException("Couldn't serialize a class: " + data.getClass().getName(), (Throwable)e);
        }
    }

    private boolean shouldValidateMinOccursOut() {
        CallContext callContext = Current.getCallContext();
        if (callContext == null) {
            return false;
        }
        ValidationConfig conf = (ValidationConfig)callContext.getContextData().get("validation.config.key");
        return conf != null && (conf.getDirection() & 2) > 0 && (conf.getValidationType() & 4) > 0;
    }

    private void serializeChoice(Object data, Type elementType, SerializationContext context, TokenWriter dataWriter, SerializationChain next) throws MessageCreatingException {
        try {
            if (elementType.getBaseType() != null) {
                SchemaContext.State baseState = context.putSchemaConstruct((SchemaConstruct)elementType.getBaseType());
                this.serialize(dataWriter, data, context, null);
                context.leave(baseState);
            }
            String javaName = context.getType(elementType);
            Class<?> choiceClass = null;
            try {
                choiceClass = javaName != null ? data.getClass().getClassLoader().loadClass(javaName) : data.getClass();
            }
            catch (ClassNotFoundException e) {
                choiceClass = data.getClass();
            }
            if (!ChoiceHelper.isChoiceEmpty((Object)data, (String)javaName)) {
                String discrString = ChoiceHelper.getChoiceDiscriminatorString((Object)data, choiceClass);
                SchemaConstruct choiceConstruct = ChoiceHelper.getChoiceConstruct((Type)elementType, (String)discrString);
                Object choiceObject = ChoiceHelper.getChoiceValue((Object)data, (String)WaspSerializationHelper.getConstructJavaMemberName((SchemaConstruct)choiceConstruct));
                SchemaContext.State state = context.putSchemaConstruct(choiceConstruct);
                next = context.getSerializationChain(choiceObject != null ? choiceObject.getClass() : (class$java$lang$Object == null ? (class$java$lang$Object = XMLReflectionSerializer.class$("java.lang.Object")) : class$java$lang$Object));
                XMLSerializer serializer = (XMLSerializer)next.getNextSerializerAs("systinet:xmlser/1.0");
                serializer.serialize(dataWriter, choiceObject, context, next);
                context.releaseSerializationChain(next);
                context.leave(state);
            }
        }
        catch (MessageCreatingException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessageCreatingException("Couldn't serialize a choosable class", (Throwable)e);
        }
    }

    private void writeBase64(TokenWriter dataWriter, Member member, QName typeName, Object data) throws IOException, MessageCreatingException {
        dataWriter.enter(member.getName().getNamespaceURI(), member.getName().getLocalPart());
        dataWriter.writeAttribute(Constants.XSI_TYPE_QNAME.getNamespaceURI(), Constants.XSI_TYPE_QNAME.getLocalPart(), dataWriter.getPrefixForNamespace(typeName.getNamespaceURI()) + ":" + typeName.getLocalPart());
        String toWrite = PrimitiveTypeAccessor.writePrimitiveObject((Object)data);
        if (toWrite == null) {
            throw new MessageCreatingException("not a supported primitive type : " + data.getClass().getName());
        }
        dataWriter.writeContent(toWrite);
        dataWriter.leave();
    }

    private Object getSerializedObject(Object data, Map props, String javaName) throws SerializationException, InvocationTargetException, IllegalAccessException {
        Object memberObject;
        Object fieldOrMethod = props.get(javaName);
        if (fieldOrMethod == null) {
            fieldOrMethod = props.get(WaspSerializationHelper.mapElementName((String)javaName));
            if (fieldOrMethod == null && !((fieldOrMethod = props.get(WaspSerializationHelper.decapitalizeName((String)javaName))) instanceof PropertyDescriptor)) {
                fieldOrMethod = null;
            }
            if (fieldOrMethod == null) {
                char[] chars = javaName.toCharArray();
                chars[0] = Character.toUpperCase(chars[0]);
                fieldOrMethod = props.get(WaspSerializationHelper.mapElementName((String)new String(chars)));
                if (fieldOrMethod == null) {
                    throw new SerializationException("Member " + javaName + " not found within " + data.getClass());
                }
            }
        }
        if (fieldOrMethod instanceof PropertyDescriptor) {
            PropertyDescriptor pd = (PropertyDescriptor)fieldOrMethod;
            Method readMethod = pd.getReadMethod();
            if (readMethod == null) {
                throw new SerializationException("Don't have access to a read method for property " + javaName + " in " + data.getClass());
            }
            memberObject = readMethod.invoke(data, new Object[0]);
        } else {
            memberObject = this.getField(data, (Field)fieldOrMethod);
        }
        return memberObject;
    }

    private Object getField(Object data, Field field) throws IllegalAccessException {
        if (WaspSerializationHelper.serializePrivateFields() && !field.isAccessible()) {
            Object memberObject;
            Field field2 = field;
            synchronized (field2) {
                ((AccessibleObject)field).setAccessible(true);
                memberObject = field.get(data);
                ((AccessibleObject)field).setAccessible(false);
            }
            return memberObject;
        }
        return field.get(data);
    }

    private Object getValue(Object data) {
        if (data == null) {
            return null;
        }
        try {
            Map props = WaspSerializationHelper.getProperties(data.getClass());
            return this.getSerializedObject(data, props, "value");
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception exception) {
            return null;
        }
    }

    private String getListValue(Object data) {
        if (data == null) {
            return null;
        }
        if (data instanceof String) {
            return (String)data;
        }
        int len = Array.getLength(data);
        StringBuffer ret = new StringBuffer();
        int i = 0;
        while (i < len) {
            if (i > 0) {
                ret.append(' ');
            }
            ret.append(this.getValue(Array.get(data, i)));
            ++i;
        }
        return ret.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        base64SchemaTypes.add(new QName("http://www.w3.org/2001/XMLSchema", "base64Binary"));
        base64SchemaTypes.add(new QName("http://www.w3.org/2000/10/XMLSchema", "binary"));
        base64SchemaTypes.add(new QName("http://www.w3.org/2000/10/XMLSchema", "base64Binary"));
        base64SchemaTypes.add(new QName("http://www.w3.org/1999/XMLSchema", "base64Binary"));
        base64SchemaTypes.add(new QName("http://www.w3.org/1999/XMLSchema", "binary"));
    }
}

