/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.serialization;

import com.idoox.debug.Category;
import com.idoox.debug.IndentCategory;
import com.idoox.wasp.ClassSpace;
import com.idoox.wasp.ClassSpaceHelper;
import com.idoox.wasp.config.ReflectionDeserializerConfig;
import com.idoox.wasp.serialization.ArrayItemReference;
import com.idoox.wasp.serialization.DefaultDeserializedObjectFactory;
import com.idoox.wasp.serialization.DeserializationChainImpl;
import com.idoox.wasp.serialization.DeserializationException;
import com.idoox.wasp.serialization.DeserializedObjectFactory;
import com.idoox.wasp.serialization.EnumHelper;
import com.idoox.wasp.serialization.FieldReference;
import com.idoox.wasp.serialization.MethodReference;
import com.idoox.wasp.serialization.PrimitiveTypeAccessor;
import com.idoox.wasp.serialization.SerializationHelper;
import com.idoox.wasp.serialization.WaspSerializationHelper;
import com.idoox.xml.schema.util.XMLSchemaUtil;
import java.beans.PropertyDescriptor;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.Map;
import javax.xml.namespace.QName;
import org.idoox.config.Configurable;
import org.idoox.wasp.serialization.DeserializationChain;
import org.idoox.wasp.serialization.DeserializationContext;
import org.idoox.wasp.serialization.Deserializer;
import org.idoox.wasp.serialization.Reference;
import org.idoox.wasp.serialization.SchemaContext;
import org.idoox.xml.schema.Member;
import org.idoox.xml.schema.SchemaConstruct;
import org.idoox.xml.schema.SchemaException;
import org.idoox.xml.schema.SchemaHolder;
import org.idoox.xml.schema.Type;
import org.idoox.xmlrpc.MessageProcessingException;
import org.idoox.xmlrpc.encoding.EncodingToken;
import org.idoox.xmlrpc.encoding.EncodingTokenizer;

public class ReflectionDeserializer
implements Deserializer {
    private static final IndentCategory cat = new IndentCategory(Category.getCategory((String)"com.idoox.serialization.ReflectionDeserializer"));
    private DeserializedObjectFactory objectFactory;
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$com$idoox$wasp$config$ReflectionDeserializerConfig;
    static /* synthetic */ Class class$com$idoox$wasp$serialization$DeserializedObjectFactory;

    public String getMechanismType() {
        return Deserializer.MECHANISM_TYPE;
    }

    public Object deserialize(EncodingTokenizer dataTokenizer, Class targetClass, DeserializationContext context, DeserializationChain chain) throws MessageProcessingException {
        try {
            int token = dataTokenizer.getCurrentToken();
            try {
                if (PrimitiveTypeAccessor.isPrimitive((String)targetClass.getName())) {
                    Class primitiveClass = PrimitiveTypeAccessor.getPrimitiveClass((String)dataTokenizer.getTokenTypeNamespaceURI(), (String)dataTokenizer.getTokenTypeName());
                    if (primitiveClass == null) {
                        primitiveClass = targetClass;
                    }
                    if (!targetClass.isAssignableFrom(primitiveClass)) {
                        primitiveClass = targetClass;
                    }
                    if (token != 3) {
                        return PrimitiveTypeAccessor.getPrimitiveObject((Class)primitiveClass, (EncodingTokenizer)dataTokenizer);
                    }
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            if (token == 4) {
                Type currentConstructSchemaType = context.getCurrentConstructSchemaType();
                if (currentConstructSchemaType.getKind() == 20) {
                    String value = dataTokenizer.getPrimitiveTokenValue();
                    return EnumHelper.deserializeEnumeration((Class)targetClass, (String)value, (Type)currentConstructSchemaType);
                }
                Class primitiveClass = PrimitiveTypeAccessor.getPrimitiveClass((String)dataTokenizer.getTokenTypeNamespaceURI(), (String)dataTokenizer.getTokenTypeName());
                if (primitiveClass == null) {
                    primitiveClass = targetClass;
                }
                if (!targetClass.isAssignableFrom(primitiveClass)) {
                    primitiveClass = targetClass;
                }
                return PrimitiveTypeAccessor.getPrimitiveObject((Class)primitiveClass, (EncodingTokenizer)dataTokenizer);
            }
            if (targetClass.isArray() && targetClass != (array$B == null ? (array$B = ReflectionDeserializer.class$("[B")) : array$B)) {
                if (token != 3) {
                    throw new DeserializationException("The incoming token " + dataTokenizer.getTokenName() + "[" + dataTokenizer.getTokenNamespaceURI() + "] is not an array");
                }
                int[] dims = dataTokenizer.getArrayDimensions();
                dims = this.duplicatePosition(dims, dims.length);
                return this.processArray(dataTokenizer, targetClass, dims, context);
            }
            if (token == 1) {
                if (targetClass == (array$B == null ? (array$B = ReflectionDeserializer.class$("[B")) : array$B)) {
                    dataTokenizer.next();
                    return new byte[0];
                }
                Map properties = WaspSerializationHelper.getProperties((Class)targetClass);
                return this.processStructure(targetClass, properties, dataTokenizer, context);
            }
            throw new DeserializationException("Can not deserialize " + EncodingToken.tokenNames[token] + ", type {" + dataTokenizer.getTokenTypeNamespaceURI() + "}" + dataTokenizer.getTokenTypeName() + " to " + targetClass + ": not supported");
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            if (e instanceof DeserializationException) {
                throw (DeserializationException)e;
            }
            throw new DeserializationException((Throwable)e);
        }
    }

    protected static Object addIntoArray(Object into, Object object, int linearPosition, int[] dimensionalPosition, int[] dims, boolean performAdding) {
        Object ret = into;
        Object intoParent = null;
        int intoParentPos = 0;
        if (dimensionalPosition != null) {
            Object newArray;
            int s = dims.length - 1;
            int i = 0;
            while (i < s) {
                if (dimensionalPosition[i] >= Array.getLength(into)) {
                    newArray = Array.newInstance(into.getClass().getComponentType(), dimensionalPosition[i] + 1);
                    System.arraycopy(into, 0, newArray, 0, Array.getLength(into));
                    if (intoParent == null) {
                        ret = into = newArray;
                    } else {
                        into = newArray;
                        Array.set(intoParent, intoParentPos, into);
                    }
                    dims[i] = dimensionalPosition[i] + 1;
                }
                intoParent = into;
                intoParentPos = dimensionalPosition[i];
                into = Array.get(into, dimensionalPosition[i]);
                ++i;
            }
            if (dimensionalPosition[s] >= Array.getLength(into)) {
                newArray = Array.newInstance(into.getClass().getComponentType(), dimensionalPosition[s] + 1);
                System.arraycopy(into, 0, newArray, 0, Array.getLength(into));
                if (intoParent == null) {
                    ret = into = newArray;
                } else {
                    into = newArray;
                    Array.set(intoParent, intoParentPos, into);
                }
                dims[s] = dimensionalPosition[s] + 1;
            }
            if (performAdding) {
                Array.set(into, dimensionalPosition[s], object);
            }
        } else {
            int s = dims.length - 1;
            int i = 0;
            while (i < s) {
                int lpd = 1;
                int lpdp = i + 1;
                while (lpdp <= s) {
                    lpd *= dims[lpdp];
                    ++lpdp;
                }
                int pos = linearPosition / lpd;
                if (pos >= Array.getLength(into)) {
                    Object newArray = Array.newInstance(into.getClass().getComponentType(), pos + 1);
                    System.arraycopy(into, 0, newArray, 0, Array.getLength(into));
                    if (intoParent == null) {
                        ret = into = newArray;
                    } else {
                        into = newArray;
                        Array.set(intoParent, intoParentPos, into);
                    }
                    dims[i] = pos + 1;
                }
                intoParent = into;
                intoParentPos = pos;
                into = Array.get(into, pos);
                linearPosition %= lpd;
                ++i;
            }
            if (linearPosition >= Array.getLength(into)) {
                Object newArray = Array.newInstance(into.getClass().getComponentType(), linearPosition + 1);
                System.arraycopy(into, 0, newArray, 0, Array.getLength(into));
                if (intoParent == null) {
                    ret = into = newArray;
                } else {
                    into = newArray;
                    Array.set(intoParent, intoParentPos, into);
                }
                dims[s] = linearPosition + 1;
            }
            if (performAdding) {
                Array.set(into, linearPosition, object);
            }
        }
        return ret;
    }

    protected Object checkArraySize(Object array, int[] dims, int pos) {
        if (Array.getLength(array) > dims[pos]) {
            Object newArray = Array.newInstance(array.getClass().getComponentType(), dims[pos]);
            System.arraycopy(array, 0, newArray, 0, dims[pos]);
            array = newArray;
        }
        if (pos >= dims.length - 1) {
            return array;
        }
        int i = 0;
        while (i < dims[pos]) {
            Array.set(array, i, this.checkArraySize(Array.get(array, i), dims, pos + 1));
            ++i;
        }
        return array;
    }

    private Object processArray(EncodingTokenizer dataTokenizer, Class arrayClass, int[] dims, DeserializationContext context) throws MessageProcessingException, SchemaException {
        int token;
        SchemaContext.State state = context.enterCurrentMember();
        int[] offset = dataTokenizer.getArrayOffset();
        int linearOffset = this.getLinearOffset(dims, offset);
        int dimsCount = dims.length;
        Class<?> componentType = arrayClass;
        int i = 0;
        while (i < dims.length) {
            componentType = componentType.getComponentType();
            ++i;
        }
        Object arrayObject = this.allocateArray(componentType, dims);
        ArrayItemReference.ArrayHolder holder = null;
        Type arrayMemberType = null;
        context.nextSchemaConstruct();
        if (dataTokenizer.getTokenTypeName() != null) {
            QName typeName = new QName(dataTokenizer.getTokenTypeNamespaceURI(), dataTokenizer.getTokenTypeName());
            arrayMemberType = XMLSchemaUtil.getSchemaType((SchemaHolder)context.getSchema(), (QName)typeName);
        } else {
            arrayMemberType = context.getCurrentConstructSchemaType();
        }
        Member componentMember = new Member(new QName(null, "item"), arrayMemberType);
        DeserializationChain chain = null;
        Deserializer deserializer = null;
        while ((token = dataTokenizer.nextToken()) != 2) {
            int[] dimensionalPosition = this.duplicatePosition(dataTokenizer.getArrayPosition(dimsCount), dimsCount);
            if (token == 5) {
                arrayObject = ReflectionDeserializer.addIntoArray(arrayObject, null, linearOffset, dimensionalPosition, dims, false);
                if (holder == null) {
                    holder = new ArrayItemReference.ArrayHolder();
                }
                context.addReference(dataTokenizer.getReference(), (Reference)new ArrayItemReference(arrayMemberType, holder, componentType, linearOffset, dimensionalPosition, dims));
            } else {
                String id = dataTokenizer.getID();
                SchemaContext.State memberState = context.putSchemaConstruct((SchemaConstruct)componentMember);
                if (chain == null) {
                    chain = context.getDeserializationChain(componentType);
                    deserializer = (Deserializer)chain.getNextDeserializerAs(Deserializer.MECHANISM_TYPE);
                }
                int chainState = ((DeserializationChainImpl)chain).getDeserializerState();
                Object component = deserializer.deserialize(dataTokenizer, componentType, context, chain);
                ((DeserializationChainImpl)chain).setDeserializerState(chainState);
                context.leave(memberState);
                if (id != null) {
                    context.setReferencedValue(id, component);
                }
                if (component != null && component instanceof Reference) {
                    if (holder == null) {
                        holder = new ArrayItemReference.ArrayHolder();
                    }
                    Reference rComp = (Reference)component;
                    rComp.setNextReference((Reference)new ArrayItemReference(rComp.getSchemaType(), holder, componentType, linearOffset, dimensionalPosition, dims));
                } else {
                    arrayObject = ReflectionDeserializer.addIntoArray(arrayObject, component, linearOffset, dimensionalPosition, dims, true);
                }
            }
            if (dimensionalPosition != null) continue;
            ++linearOffset;
        }
        if (chain != null) {
            context.releaseDeserializationChain(chain);
        }
        if (holder != null) {
            holder.heldArray = arrayObject;
        }
        context.leave(state);
        return arrayObject;
    }

    private final Object allocateArray(Class componentType, int[] dims) {
        Object ret = dims.length == 1 && dims[0] < 0 ? Array.newInstance(componentType, new int[]{1}) : Array.newInstance(componentType, dims);
        int l = dims.length;
        if (l > 1) {
            int[] newdims = new int[l - 1];
            System.arraycopy(dims, 1, newdims, 0, l - 1);
            int i = 0;
            while (i < dims[0]) {
                Array.set(ret, i, this.allocateArray(componentType, newdims));
                ++i;
            }
        }
        return ret;
    }

    private int getLinearOffset(int[] dims, int[] offset) {
        int lpos = 0;
        int l = dims.length;
        if (offset != null) {
            int i = 0;
            while (i < l) {
                lpos = lpos * dims[i] + offset[i];
                ++i;
            }
        }
        return lpos;
    }

    private final Object processStructure(Class targetClass, Map properties, EncodingTokenizer dataTokenizer, DeserializationContext context) throws MessageProcessingException, NoSuchFieldException, SchemaException {
        int token;
        SchemaContext.State state = context.enterCurrentMember();
        Object structure = this.objectFactory.createObject(targetClass, context.getDeserializedObjects(), context.getDeserializedObjectsCount() - 1, null, dataTokenizer);
        while ((token = dataTokenizer.nextToken()) != 2) {
            Method writeMethod;
            String name = dataTokenizer.getTokenName();
            Object o = properties.get(name);
            PropertyDescriptor prop = null;
            Field field = null;
            if (o == null) {
                o = properties.get(WaspSerializationHelper.mapElementName((String)name));
                if (o == null && !((o = properties.get(WaspSerializationHelper.decapitalizeName((String)name))) instanceof PropertyDescriptor)) {
                    o = null;
                }
                if (o == null) {
                    throw new NoSuchFieldException("Don't know how to map <" + name + "> in " + targetClass);
                }
            }
            if (o instanceof PropertyDescriptor) {
                prop = (PropertyDescriptor)o;
            } else {
                field = (Field)o;
            }
            Class<?> memberClass = prop == null ? field.getType() : prop.getPropertyType();
            if (token == 5) {
                if (context.nextSchemaConstruct(dataTokenizer.getTokenNamespaceURI(), dataTokenizer.getTokenName()) == null) {
                    throw new MessageProcessingException("Unexpected element {" + dataTokenizer.getTokenNamespaceURI() + "}" + dataTokenizer.getTokenName());
                }
                Type compType = context.getCurrentConstructSchemaType();
                if (dataTokenizer.getTokenTypeName() != null) {
                    QName typeName = new QName(dataTokenizer.getTokenTypeNamespaceURI(), dataTokenizer.getTokenTypeName());
                    compType = XMLSchemaUtil.getSchemaType((SchemaHolder)context.getSchema(), (QName)typeName);
                }
                if (prop != null) {
                    writeMethod = prop.getWriteMethod();
                    if (writeMethod == null) {
                        throw new DeserializationException("No write method for property " + prop.getName() + ", class " + targetClass);
                    }
                    context.addReference(dataTokenizer.getReference(), (Reference)new MethodReference(compType, structure, writeMethod, memberClass));
                    continue;
                }
                context.addReference(dataTokenizer.getReference(), (Reference)new FieldReference(compType, structure, field, memberClass));
                continue;
            }
            Object member = SerializationHelper.deserialize((EncodingTokenizer)dataTokenizer, memberClass, (DeserializationContext)context, (Object)structure);
            if (member != null && member instanceof Reference) {
                Reference rMember = (Reference)member;
                if (prop != null) {
                    Method writeMethod2 = prop.getWriteMethod();
                    if (writeMethod2 == null) {
                        throw new DeserializationException("No write method for property " + prop.getName() + ", class " + targetClass);
                    }
                    rMember.setNextReference((Reference)new MethodReference(rMember.getSchemaType(), structure, writeMethod2, memberClass));
                    continue;
                }
                rMember.setNextReference((Reference)new FieldReference(rMember.getSchemaType(), structure, field, memberClass));
                continue;
            }
            if (prop != null) {
                writeMethod = prop.getWriteMethod();
                if (writeMethod == null) {
                    throw new DeserializationException("No write method for property " + prop.getName() + ", class " + targetClass);
                }
                String excMessage = null;
                try {
                    excMessage = "Exception thrown while setting value of class " + (member != null ? member.getClass().getName() : "<null>") + " into " + writeMethod;
                    writeMethod.invoke(structure, member);
                    continue;
                }
                catch (IllegalAccessException e) {
                    throw new MessageProcessingException(excMessage, (Throwable)e);
                }
                catch (IllegalArgumentException e) {
                    throw new MessageProcessingException(excMessage, (Throwable)e);
                }
                catch (InvocationTargetException e) {
                    throw new MessageProcessingException(excMessage, (Throwable)e);
                }
            }
            String excMessage = null;
            try {
                excMessage = "Exception thrown while setting value of class " + (member != null ? member.getClass().getName() : "<null>") + " into " + field;
                ReflectionDeserializer.setField(structure, field, member);
            }
            catch (IllegalAccessException e) {
                throw new MessageProcessingException(excMessage, (Throwable)e);
            }
            catch (MessageProcessingException e) {
                throw new MessageProcessingException(excMessage, (Throwable)e);
            }
        }
        context.leave(state);
        return structure;
    }

    private int[] duplicatePosition(int[] position, int positionSize) {
        if (position == null) {
            return null;
        }
        int[] newArr = new int[positionSize];
        System.arraycopy(position, 0, newArr, 0, positionSize);
        return newArr;
    }

    public void init(Configurable config) {
        ReflectionDeserializerConfig cfg = (ReflectionDeserializerConfig)config.narrow(class$com$idoox$wasp$config$ReflectionDeserializerConfig == null ? (class$com$idoox$wasp$config$ReflectionDeserializerConfig = ReflectionDeserializer.class$("com.idoox.wasp.config.ReflectionDeserializerConfig")) : class$com$idoox$wasp$config$ReflectionDeserializerConfig);
        ReflectionDeserializerConfig.DeserializedObjectFactoryConfig factoryCfg = cfg.getDeserializedObjectFactory();
        if (factoryCfg == null) {
            this.objectFactory = new DefaultDeserializedObjectFactory();
        } else {
            try {
                ClassSpace classSpace = ClassSpaceHelper.getClassSpace((String)factoryCfg.getClassSpace(), (String)config.getReferenceLocation());
                this.objectFactory = null;
                this.objectFactory = (DeserializedObjectFactory)classSpace.createInstance(class$com$idoox$wasp$serialization$DeserializedObjectFactory == null ? (class$com$idoox$wasp$serialization$DeserializedObjectFactory = ReflectionDeserializer.class$("com.idoox.wasp.serialization.DeserializedObjectFactory")) : class$com$idoox$wasp$serialization$DeserializedObjectFactory, factoryCfg.getClassName());
            }
            catch (MalformedURLException e) {
                cat.error("", (Throwable)e);
            }
            catch (ClassNotFoundException e) {
                cat.error("", (Throwable)e);
            }
            catch (InstantiationException e) {
                cat.error("", (Throwable)e);
            }
            catch (IllegalAccessException e) {
                cat.error("", (Throwable)e);
            }
            if (this.objectFactory == null) {
                this.objectFactory = new DefaultDeserializedObjectFactory();
            }
        }
    }

    static void setField(Object data, Field field, Object value) throws IllegalAccessException, MessageProcessingException {
        try {
            if (WaspSerializationHelper.serializePrivateFields()) {
                boolean accessible = field.isAccessible();
                ((AccessibleObject)field).setAccessible(true);
                field.set(data, value);
                ((AccessibleObject)field).setAccessible(accessible);
            } else {
                field.set(data, value);
            }
        }
        catch (IllegalArgumentException e) {
            throw new MessageProcessingException("Error setting field " + field + " to " + (value != null ? value.getClass().getName() : "<null>") + " : " + e.getMessage(), (Throwable)e);
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

