/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.serialization;

import com.idoox.wasp.serialization.PolymorphismHelper;
import org.idoox.config.Configurable;
import org.idoox.wasp.serialization.SerializationChain;
import org.idoox.wasp.serialization.SerializationContext;
import org.idoox.wasp.serialization.Serializer;
import org.idoox.xml.schema.Type;
import org.idoox.xmlrpc.MessageCreatingException;
import org.idoox.xmlrpc.encoding.EncodingTokenWriter;

public class BasicConstructSerializer
implements Serializer {
    PolymorphismHelper helper = new PolymorphismHelper();

    public void serialize(EncodingTokenWriter dataWriter, Object data, int[] arrayPos, SerializationContext context, SerializationChain chain) throws MessageCreatingException {
        Serializer nextSerializer;
        Type polymorphismType;
        if (data == null) {
            dataWriter.writeNil(context.getCurrentConstructName(), arrayPos);
            return;
        }
        if (!context.isSerializingMultirefs()) {
            if (!context.isMultirefsInline() || context.isReferenceSerialized(data)) {
                String ref = context.getMultirefRef(data);
                if (ref != null) {
                    dataWriter.writeReference(context.getCurrentConstructName(), arrayPos, ref);
                    return;
                }
            } else if (context.isMultirefsInline()) {
                context.setReferenceSerialized(data);
            }
        } else if (context.isMultirefsInline()) {
            context.setReferenceSerialized(data);
        }
        if ((polymorphismType = context.getMultirefType(data)) == null) {
            polymorphismType = this.helper.getClassSchemaType(context, data.getClass());
        }
        Type currentType = context.getCurrentConstructSchemaType();
        Type previousType = null;
        if (polymorphismType != null && polymorphismType != currentType) {
            if (PolymorphismHelper.isExtendedFrom((Type)polymorphismType, (Type)currentType)) {
                previousType = currentType;
                context.replaceTopMemberType(polymorphismType);
                chain = context.getSerializationChain(data.getClass());
                chain.removeSerializer((javax.xml.rpc.encoding.Serializer)this);
            }
        }
        if ((nextSerializer = (Serializer)chain.getNextSerializerAs(Serializer.MECHANISM_TYPE)) == null) {
            throw new MessageCreatingException("No serializer found for xml schema " + context.getCurrentSchemaConstruct() + ", java class " + data.getClass());
        }
        nextSerializer.serialize(dataWriter, data, arrayPos, context, chain);
        if (previousType != null) {
            context.releaseSerializationChain(chain);
            context.replaceTopMemberType(previousType);
        }
    }

    public void grabReferences(Object data, SerializationContext context, SerializationChain chain) throws MessageCreatingException {
        Serializer nextSerializer;
        if (data == null) {
            return;
        }
        Type polymorphismType = context.getMultirefType(data);
        Type currentType = context.getCurrentConstructSchemaType();
        Type previousType = null;
        if (polymorphismType == null) {
            polymorphismType = this.helper.getClassSchemaType(context, data.getClass());
        }
        if (polymorphismType != null && polymorphismType != context.getCurrentConstructSchemaType()) {
            if (PolymorphismHelper.isExtendedFrom((Type)polymorphismType, (Type)currentType)) {
                previousType = currentType;
                context.replaceTopMemberType(polymorphismType);
                chain = context.getSerializationChain(data.getClass());
                chain.removeSerializer((javax.xml.rpc.encoding.Serializer)this);
            }
        }
        if ((nextSerializer = (Serializer)chain.getNextSerializerAs(Serializer.MECHANISM_TYPE)) == null) {
            throw new MessageCreatingException("No serializer found for xml schema " + context.getCurrentSchemaConstruct() + ", java class " + data.getClass());
        }
        nextSerializer.grabReferences(data, context, chain);
        if (previousType != null) {
            context.releaseSerializationChain(chain);
            context.replaceTopMemberType(previousType);
        }
    }

    public String getMechanismType() {
        return Serializer.MECHANISM_TYPE;
    }

    public void init(Configurable conf) {
    }
}

