/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.security;

import com.idoox.wasp.serialization.SerializationHelper;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.NoSuchAlgorithmException;
import java.security.spec.EncodedKeySpec;
import java.security.spec.InvalidKeySpecException;
import java.util.Hashtable;
import java.util.Properties;
import org.idoox.config.Configurable;
import org.idoox.wasp.serialization.DeserializationChain;
import org.idoox.wasp.serialization.DeserializationContext;
import org.idoox.wasp.serialization.SchemaContext;
import org.idoox.wasp.serialization.XMLDeserializer;
import org.idoox.xml.Token;
import org.idoox.xml.Tokenizer;
import org.idoox.xmlrpc.MessageProcessingException;

public class XMLKeyDeserializer
implements XMLDeserializer {
    private static Properties keyFormats = new Properties();
    private static Class[] constructorParams = new Class[]{array$B == null ? (array$B = XMLKeyDeserializer.class$("[B")) : array$B};
    static /* synthetic */ Class array$B;
    static /* synthetic */ Class class$java$lang$String;

    public Object deserialize(Tokenizer tokenizer, Token currentToken, Class targetClass, DeserializationContext context, DeserializationChain chain) throws MessageProcessingException {
        try {
            SchemaContext.State state = context.enterCurrentMember();
            tokenizer.next();
            tokenizer.readToken(currentToken);
            String format = (String)SerializationHelper.deserialize((Tokenizer)tokenizer, (Token)currentToken, (Class)(class$java$lang$String == null ? (class$java$lang$String = XMLKeyDeserializer.class$("java.lang.String")) : class$java$lang$String), (DeserializationContext)context);
            tokenizer.next();
            tokenizer.readToken(currentToken);
            String algorithm = (String)SerializationHelper.deserialize((Tokenizer)tokenizer, (Token)currentToken, (Class)(class$java$lang$String == null ? (class$java$lang$String = XMLKeyDeserializer.class$("java.lang.String")) : class$java$lang$String), (DeserializationContext)context);
            tokenizer.next();
            tokenizer.readToken(currentToken);
            byte[] encoded = (byte[])SerializationHelper.deserialize((Tokenizer)tokenizer, (Token)currentToken, (Class)(array$B == null ? (array$B = XMLKeyDeserializer.class$("[B")) : array$B), (DeserializationContext)context);
            tokenizer.next();
            tokenizer.readToken(currentToken);
            context.leave(state);
            return this.createKey(algorithm, format, encoded);
        }
        catch (MessageProcessingException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessageProcessingException((Throwable)e);
        }
    }

    public void init(Configurable conf) {
    }

    public String getMechanismType() {
        return "systinet:xmlser/1.0";
    }

    private Key createKey(String algorithm, String format, byte[] encoded) throws NoSuchAlgorithmException, ClassNotFoundException, NoSuchMethodException, InstantiationException, IllegalAccessException, InvocationTargetException, InvalidKeySpecException {
        Key key;
        KeyFactory keyFactory = KeyFactory.getInstance(algorithm);
        String specClassName = (String)((Hashtable)keyFormats).get(format);
        Class<?> specClass = Class.forName(specClassName);
        Constructor<?> cons = specClass.getConstructor(constructorParams);
        EncodedKeySpec encKeySpec = (EncodedKeySpec)cons.newInstance(new Object[]{encoded});
        try {
            key = keyFactory.generatePrivate(encKeySpec);
        }
        catch (InvalidKeySpecException e) {
            key = keyFactory.generatePublic(encKeySpec);
        }
        return key;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        ((Hashtable)keyFormats).put("PKCS8", "java.security.spec.PKCS8EncodedKeySpec");
        ((Hashtable)keyFormats).put("PKCS#8", "java.security.spec.PKCS8EncodedKeySpec");
        ((Hashtable)keyFormats).put("X.509", "java.security.spec.X509EncodedKeySpec");
        ((Hashtable)keyFormats).put("X509", "java.security.spec.X509EncodedKeySpec");
    }
}

