/*
 * Decompiled with CFR 0.152.
 */
package com.idoox.wasp.security;

import com.idoox.wasp.serialization.SerializationHelper;
import java.security.cert.Certificate;
import javax.xml.namespace.QName;
import org.idoox.config.Configurable;
import org.idoox.wasp.serialization.SchemaContext;
import org.idoox.wasp.serialization.SerializationChain;
import org.idoox.wasp.serialization.SerializationContext;
import org.idoox.wasp.serialization.XMLSerializer;
import org.idoox.xml.TokenWriter;
import org.idoox.xml.schema.Member;
import org.idoox.xmlrpc.MessageCreatingException;

public class XMLCertificateSerializer
implements XMLSerializer {
    private static QName schemaType = new QName("http://idoox.com/security", "Certificate");

    public void serialize(TokenWriter dataWriter, Object data, SerializationContext context, SerializationChain next) throws MessageCreatingException {
        try {
            Certificate certificate = (Certificate)data;
            String type = certificate.getType();
            byte[] encoded = certificate.getEncoded();
            Member member = (Member)context.getCurrentSchemaConstruct();
            dataWriter.enter(member.getName().getNamespaceURI(), member.getName().getLocalPart());
            SerializationHelper.writeXsiType((TokenWriter)dataWriter, (QName)schemaType);
            SchemaContext.State state = context.enterCurrentMember();
            member = (Member)context.nextSchemaConstruct();
            SerializationHelper.serialize((TokenWriter)dataWriter, (Object)type, (SerializationContext)context);
            SerializationHelper.serialize((TokenWriter)dataWriter, (Object)encoded, (SerializationContext)context);
            context.leave(state);
            dataWriter.leave();
        }
        catch (MessageCreatingException e) {
            throw e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new MessageCreatingException((Throwable)e);
        }
    }

    public void grabReferences(Object data, SerializationContext context, SerializationChain next) throws MessageCreatingException {
    }

    public void init(Configurable conf) {
    }

    public String getMechanismType() {
        return "systinet:xmlser/1.0";
    }
}

