/*
 * Decompiled with CFR 0.152.
 */
package com.verisign.messaging;

import com.verisign.datatypes.Base64;
import com.verisign.datatypes.DateTime;
import com.verisign.datatypes.QName;
import com.verisign.domutil.DOMCursor;
import com.verisign.domutil.DOMWriteCursor;
import com.verisign.messaging.MessageSecurity;
import com.verisign.messaging.MessageValidity;
import com.verisign.messaging.SOAPMessage;
import com.verisign.messaging.XmlMessageException;
import com.verisign.util.InternalRuntimeException;
import com.verisign.util.Namespaces;
import com.verisign.uuid.UUID;
import com.verisign.xmlenc.AlgorithmType;
import com.verisign.xmlenc.Decryptor;
import com.verisign.xmlenc.Encryptor;
import com.verisign.xmlenc.KeyResolver;
import com.verisign.xmlsig.KeyInfo;
import com.verisign.xmlsig.Signer;
import com.verisign.xmlsig.SigningKey;
import com.verisign.xmlsig.Verifier;
import com.verisign.xmlsig.VerifyingKey;
import com.verisign.xmlsig.VerifyingKeyFactory;
import com.verisign.xpath.XPath;
import com.verisign.xpath.XPathException;
import java.io.ByteArrayInputStream;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.KeyFactory;
import java.security.MessageDigest;
import java.security.PublicKey;
import java.security.SignatureException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.X509EncodedKeySpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.w3c.dom.Document;
import org.xmltrustcenter.verifier.TrustVerificationException;
import org.xmltrustcenter.verifier.TrustVerifier;

public class WSSecurity
implements MessageSecurity {
    private static final String WSSE_URI = "http://schemas.xmlsoap.org/ws/2002/07/secext";
    private static final String WSSE_PREFIX = "wsse";
    private static final String WSU_URI = "http://schemas.xmlsoap.org/ws/2002/07/utility";
    private static final String WSU_PREFIX = "wsu";
    private static final String SOAP_URI;
    private static final String SOAP_PREFIX;
    private static final String XMLSIG_URI;
    private static final String XMLSIG_PREFIX;
    private static final String XMLENC_URI;
    private static final String XMLENC_PREFIX;
    private static final String SOAP_ENVELOPE = "Envelope";
    private static final String SOAP_HEADER = "Header";
    private static final String SOAP_BODY = "Body";
    private static final String SOAP_FAULT = "Fault";
    private static final boolean USE_WSU_FOR_SECURITY_TOKEN_ID = false;
    private static final Map NS_MAPPINGS;
    private static final QName X509_QNAME;
    private static final QName BASE64_QNAME;
    private static final QName HEX_QNAME;
    private String soapActor;
    private long validityMillis;
    private boolean signBeforeEncrypt = true;

    public void setSOAPActor(String soapActor) {
        this.soapActor = soapActor;
    }

    public String getSOAPActor() {
        return this.soapActor;
    }

    public void setSignBeforeEncrypt(boolean signBeforeEncrypt) {
        this.signBeforeEncrypt = signBeforeEncrypt;
    }

    public boolean getSignBeforeEncrypt() {
        return this.signBeforeEncrypt;
    }

    public long getValidityInterval() {
        return this.validityMillis;
    }

    public void setValidityInterval(long validityMillis) {
        this.validityMillis = validityMillis;
    }

    public XPath getSigningLocation() {
        return null;
    }

    public void setSigningLocation(XPath signingLocation) {
        if (signingLocation != null) {
            throw new IllegalArgumentException("explicit signing locations are not currently supported");
        }
    }

    public boolean getSigningLocationInsertBefore() {
        return false;
    }

    public void setSigningLocationInsertBefore(boolean signInsertBefore) {
    }

    public void setUseExclusiveCanonicalization(boolean useExclusiveC14N) {
        if (!useExclusiveC14N) {
            throw new IllegalArgumentException("only useExclusiveC14N=true is currently supported");
        }
    }

    public boolean getUseExclusiveCanonicalization() {
        return true;
    }

    public XPath[] getVerifyingLocations() {
        return null;
    }

    public void setVerifyingLocations(XPath[] verifyingLocations) {
        if (verifyingLocations != null && verifyingLocations.length > 0) {
            throw new IllegalArgumentException("explicit verifying locations are not currently supported");
        }
    }

    public void sign(Document message, SigningKey signingKey, KeyInfo keyInfo) throws GeneralSecurityException {
        String keyInfoID;
        this.addEnvelope(message);
        if (signingKey == null) {
            return;
        }
        DOMWriteCursor c = new DOMWriteCursor(message);
        boolean insertBefore = this.moveToInsertPosition(c);
        XPath relativeLoc = c.createXPath();
        String[] timestampIDs = this.addTimestamps(c);
        Signer signer = new Signer(c.getDocument(), signingKey);
        signer.useExclusiveCanonicalizer(Collections.EMPTY_LIST);
        signer.addReference(XPath.fromID((String)this.makeBodyID(c)));
        if (timestampIDs[0] != null) {
            signer.addReference(XPath.fromID((String)timestampIDs[0]));
        }
        if (timestampIDs[1] != null) {
            signer.addReference(XPath.fromID((String)timestampIDs[1]));
        }
        try {
            signer.signInPlace(relativeLoc, insertBefore);
        }
        catch (XPathException e) {
            throw new InternalRuntimeException((Throwable)e);
        }
        if (keyInfo != null && (keyInfoID = this.insertKeyInfo(c, keyInfo)) != null) {
            this.moveToInsertPosition(c);
            c.moveToSibling(1);
            c = c.addUnder(XMLSIG_URI, XMLSIG_PREFIX, "KeyInfo");
            c = c.addUnder(WSSE_URI, WSSE_PREFIX, "SecurityTokenReference");
            c = c.addUnder(WSSE_URI, WSSE_PREFIX, "Reference");
            c.setAttribute("URI", "#" + keyInfoID);
        }
    }

    public void encrypt(Document message, Key dataEncryptionKey, AlgorithmType dataEncryptionAlgorithm, Key keyEncryptionKey, AlgorithmType keyEncryptionAlgorithm, KeyInfo keyInfo) throws GeneralSecurityException {
        boolean insertRefListBefore;
        Encryptor encryptor;
        this.addEnvelope(message);
        if (dataEncryptionKey == null) {
            return;
        }
        DOMWriteCursor c = new DOMWriteCursor(message);
        if (dataEncryptionAlgorithm == null) {
            dataEncryptionAlgorithm = AlgorithmType.TRIPLEDES;
        }
        if (keyEncryptionAlgorithm == null) {
            keyEncryptionAlgorithm = AlgorithmType.RSA1_5;
        }
        XPath bodyLoc = XPath.fromID((String)this.makeBodyID(c));
        if (keyEncryptionKey != null) {
            byte[] spki;
            X509Certificate cert;
            boolean insertBefore = this.moveToInsertPosition(c);
            encryptor = new Encryptor(c.getDocument(), keyEncryptionKey, keyEncryptionAlgorithm);
            try {
                encryptor.encryptKeyInPlace(dataEncryptionKey, c.createXPath(), insertBefore);
            }
            catch (XPathException e) {
                throw new InternalRuntimeException((Throwable)e);
            }
            this.moveToInsertPosition(c);
            if (keyInfo != null && (cert = keyInfo.getCertificate()) != null && (spki = cert.getExtensionValue("2.5.29.14")) != null) {
                byte[] temp = new byte[spki.length - 4];
                System.arraycopy(spki, 4, temp, 0, temp.length);
                spki = temp;
                DOMWriteCursor c2 = c.cloneWriteCursor();
                if (!c2.moveToChild(XMLENC_URI, "CipherData")) {
                    throw this.isInvalid((DOMCursor)c2);
                }
                c2 = c2.addBefore(XMLSIG_URI, XMLSIG_PREFIX, "KeyInfo");
                c2 = c2.addUnder(WSSE_URI, WSSE_PREFIX, "SecurityTokenReference");
                c2 = c2.addUnder(WSSE_URI, WSSE_PREFIX, "KeyIdentifier");
                this.setBinaryValue(c2, spki);
            }
            insertRefListBefore = false;
        } else {
            insertRefListBefore = this.moveToInsertPosition(c);
        }
        DOMWriteCursor refList = insertRefListBefore ? c.addBefore(XMLENC_URI, XMLENC_PREFIX, "ReferenceList") : c.addUnder(XMLENC_URI, XMLENC_PREFIX, "ReferenceList");
        encryptor = new Encryptor(c.getDocument(), dataEncryptionKey, dataEncryptionAlgorithm);
        try {
            encryptor.setContentEncryption(true);
            encryptor.encryptInPlace(bodyLoc);
        }
        catch (XPathException e) {
            throw new InternalRuntimeException((Throwable)e);
        }
        this.moveToBody((DOMCursor)c);
        c.moveToChild(1);
        String encID = this.makeID(c);
        c = refList.addUnder(XMLENC_URI, XMLENC_PREFIX, "DataReference");
        c.setAttribute("URI", "#" + encID);
    }

    public void signAndEncrypt(Document message, SigningKey signingKey, KeyInfo signingKeyInfo, Key dataEncryptionKey, AlgorithmType dataEncryptionAlgorithm, Key keyEncryptionKey, AlgorithmType keyEncryptionAlgorithm, KeyInfo encryptingKeyInfo) throws GeneralSecurityException {
        if (this.signBeforeEncrypt) {
            this.sign(message, signingKey, signingKeyInfo);
            this.encrypt(message, dataEncryptionKey, dataEncryptionAlgorithm, keyEncryptionKey, keyEncryptionAlgorithm, encryptingKeyInfo);
        } else {
            this.encrypt(message, dataEncryptionKey, dataEncryptionAlgorithm, keyEncryptionKey, keyEncryptionAlgorithm, encryptingKeyInfo);
            this.sign(message, signingKey, signingKeyInfo);
        }
    }

    public MessageValidity[] verify(Document message, TrustVerifier trustVerifier, VerifyingKey verifyingKey) throws SignatureException, TrustVerificationException, GeneralSecurityException, XmlMessageException {
        return this.verifyAndDecrypt(message, trustVerifier, verifyingKey, null, null);
    }

    public void decrypt(Document message, Key decryptionKey, KeyResolver keyResolver) throws GeneralSecurityException, XmlMessageException {
        try {
            this.verifyAndDecrypt(message, null, null, decryptionKey, keyResolver);
        }
        catch (TrustVerificationException e) {
            throw new InternalRuntimeException((Throwable)e);
        }
    }

    public MessageValidity[] verifyAndDecrypt(Document message, TrustVerifier trustVerifier, VerifyingKey verifyingKey, Key decryptionKey, KeyResolver keyResolver) throws SignatureException, TrustVerificationException, GeneralSecurityException, XmlMessageException {
        DOMCursor c = new DOMCursor(message);
        this.checkEnvelope(c);
        if (!c.moveToXPath(this.getSecurityXPath())) {
            return new MessageValidity[0];
        }
        ArrayList<MessageValidity> validityList = new ArrayList<MessageValidity>();
        HashMap<String, Object> references = new HashMap<String, Object>();
        boolean more = c.moveToChild(1);
        while (more) {
            String id;
            if (c.atElement(WSSE_URI, "BinarySecurityToken")) {
                id = this.getID(c);
                if (id != null) {
                    references.put(id, this.securityTokenToKeyInfo(c));
                }
            } else if (c.atElement(WSSE_URI, "SecurityTokenReference")) {
                id = this.getID(c);
                if (id != null) {
                    references.put(id, this.securityTokenReferenceToKeyInfo(c, references));
                }
            } else if (c.atElement(XMLSIG_URI, "KeyInfo")) {
                id = this.getID(c);
                if (id != null) {
                    references.put(id, this.keyInfoToKeyInfo(c));
                }
            } else if (c.atElement(XMLSIG_URI, "Signature")) {
                MessageValidity validity = this.verifySignature(c, references, verifyingKey, trustVerifier);
                validityList.add(validity);
            } else if (c.atElement(XMLENC_URI, "ReferenceList")) {
                this.processEncryptedList(c, references, decryptionKey);
            } else if (c.atElement(XMLENC_URI, "EncryptedKey")) {
                Key key = this.processEncryptedKey(c, references, decryptionKey);
                String id2 = this.getID(c);
                if (id2 != null) {
                    references.put(id2, key);
                }
            } else if (c.atElement(XMLENC_URI, "EncryptedData")) {
                c = this.processEncryptedData(c, references, decryptionKey);
            }
            more = c.moveToSibling(1);
        }
        MessageValidity[] v = new MessageValidity[validityList.size()];
        validityList.toArray(v);
        return v;
    }

    private String[] addTimestamps(DOMWriteCursor c) {
        this.addAndMoveToSoapHeader(c);
        String[] ids = new String[2];
        if (c.moveToChild(WSU_URI, "Timestamp")) {
            if (c.moveToChild(WSU_URI, "Created")) {
                return ids;
            }
            if (c.moveToChild(WSU_URI, "Expires")) {
                return ids;
            }
        } else {
            c = c.addUnder(WSU_URI, WSU_PREFIX, "Timestamp");
        }
        Date time = new Date();
        c = c.moveToChild(1) ? c.addBefore(WSU_URI, WSU_PREFIX, "Created") : c.addUnder(WSU_URI, WSU_PREFIX, "Created");
        c.setText(DateTime.formatISODateTime((Date)time));
        ids[0] = this.makeID(c, WSU_URI, WSU_PREFIX);
        if (this.validityMillis > 0L) {
            time = new Date(time.getTime() + this.validityMillis);
            if (c.moveToSibling(1)) {
                c = c.addBefore(WSU_URI, WSU_PREFIX, "Expires");
            } else {
                c.moveToParent();
                c = c.addUnder(WSU_URI, WSU_PREFIX, "Expires");
            }
            c.setText(DateTime.formatISODateTime((Date)time));
            ids[1] = this.makeID(c, WSU_URI, WSU_PREFIX);
        }
        return ids;
    }

    private String getID(DOMCursor c) throws XmlMessageException {
        String id = c.getAttribute("Id");
        String id2 = null;
        try {
            id2 = c.getAttribute(WSU_URI, "Id");
        }
        catch (NullPointerException e) {
            // empty catch block
        }
        if (id != null && id2 != null) {
            throw new XmlMessageException("two IDs not supported");
        }
        if (id != null) {
            return id;
        }
        if (id2 != null) {
            return id2;
        }
        return null;
    }

    private MessageValidity verifySignature(DOMCursor c, Map references, VerifyingKey verifyingKey, TrustVerifier trustVerifier) throws GeneralSecurityException, XmlMessageException {
        DOMCursor c2;
        MessageValidity validity = null;
        KeyInfo keyInfo = null;
        if (verifyingKey == null && (c2 = c.cloneCursor()).moveToChild(XMLSIG_URI, "KeyInfo") && c2.moveToChild(WSSE_URI, "SecurityTokenReference") && (keyInfo = this.securityTokenReferenceToKeyInfo(c2, references)) != null) {
            verifyingKey = VerifyingKeyFactory.makeVerifyingKey((KeyInfo)keyInfo);
        }
        try {
            Verifier sigVerifier = new Verifier(c.getDocument(), c.createXPath());
            if (verifyingKey == null) {
                PublicKey publicKey = sigVerifier.getVerifyingKey();
                if (publicKey == null) {
                    throw this.isInvalid(c, "no verifying key is available");
                }
                verifyingKey = VerifyingKeyFactory.makeVerifyingKey((Key)publicKey);
                keyInfo = this.verifierToKeyInfo(sigVerifier);
            }
            validity = new MessageValidity(c.getDocument(), "signature", keyInfo, null, c.getElement(), sigVerifier.getReferencedElements());
            if (!sigVerifier.verify(verifyingKey)) {
                validity.setInvalid((Exception)new SignatureException("signature value does not verify"));
            } else if (trustVerifier != null && keyInfo != null) {
                keyInfo.verifyTrust(trustVerifier);
            }
        }
        catch (Exception e) {
            if (validity != null) {
                validity.setInvalid(e);
            }
            validity = new MessageValidity(c.getDocument(), "signature", null, e, c.getElement(), null);
        }
        return validity;
    }

    private void processEncryptedList(DOMCursor c, Map references, Key decryptionKey) throws XmlMessageException {
        c = c.cloneCursor();
        boolean more = c.moveToChild(1);
        while (more) {
            if (c.atElement(XMLENC_URI, "DataReference")) {
                XPath loc = c.getXPathAttribute("URI");
                if (loc == null) {
                    throw this.isInvalid(c, "missing URI");
                }
                DOMCursor c2 = c.cloneCursor();
                if (!c2.moveToXPath(loc)) {
                    throw this.isInvalid(c, "URI not found: " + loc);
                }
                this.processEncryptedData(c2, references, decryptionKey);
            }
            more = c.moveToSibling(1);
        }
    }

    private Key processEncryptedKey(DOMCursor c, Map references, Key decryptionKey) throws XmlMessageException {
        Key key;
        if (decryptionKey == null) {
            throw new XmlMessageException("EncryptedKey cannot be decrypted -- no decryptionKey param specified");
        }
        try {
            Decryptor decryptor = new Decryptor(c.getDocument(), decryptionKey, c.createXPath());
            key = decryptor.decryptKey();
        }
        catch (Exception e) {
            throw this.cannotProcess(c, (Throwable)e);
        }
        c = c.cloneCursor();
        if (c.moveToChild(XMLENC_URI, "ReferenceList")) {
            this.processEncryptedList(c, references, key);
        }
        return key;
    }

    private DOMCursor processEncryptedData(DOMCursor c, Map references, Key decryptionKey) throws XmlMessageException {
        if (decryptionKey == null) {
            throw new XmlMessageException("EncryptedData cannot be decrypted -- no decryptionKey param specified");
        }
        DOMCursor saved = c.cloneCursor();
        boolean savedSibling = true;
        if (!saved.moveToSibling(-1)) {
            savedSibling = false;
            saved.moveToParent();
        }
        XPath xpath = c.createXPath();
        try {
            Decryptor decryptor = new Decryptor(c.getDocument(), decryptionKey, xpath);
            decryptor.decryptInPlace();
            if (savedSibling) {
                saved.moveToSibling(1);
            } else {
                saved.moveToChild(1);
            }
            return saved;
        }
        catch (Exception e) {
            throw this.cannotProcess(xpath, (Throwable)e);
        }
    }

    private KeyInfo keyInfoToKeyInfo(DOMCursor c) throws XmlMessageException {
        return KeyInfo.fromXML((DOMCursor)c);
    }

    private KeyInfo securityTokenToKeyInfo(DOMCursor c) throws XmlMessageException {
        try {
            X509Certificate cert = this.securityTokenToCert(c);
            return this.certToKeyInfo(c, cert);
        }
        catch (Exception e) {
            throw new InternalRuntimeException((Throwable)e);
        }
    }

    private KeyInfo securityTokenReferenceToKeyInfo(DOMCursor c, Map references) throws GeneralSecurityException, XmlMessageException {
        String valueType;
        if ((c = c.cloneCursor()).moveToChild(WSSE_URI, "Reference")) {
            KeyInfo ki;
            String id;
            String ref = c.getAttribute("URI");
            if (ref == null || !ref.startsWith("#")) {
                throw new XmlMessageException("external references not supported " + c);
            }
            XPath xpath = XPath.fromXPointer((String)ref);
            if (xpath != null && (id = xpath.toID()) != null && (ki = (KeyInfo)references.get(id)) != null) {
                return ki;
            }
        } else if (c.moveToChild(WSSE_URI, "KeyIdentifier") && (valueType = c.getAttribute("ValueType")) != null && X509_QNAME.equals((Object)c.getQNameInContext(valueType))) {
            PublicKey key;
            byte[] bytes = this.getBinaryValue(c);
            X509EncodedKeySpec spec = new X509EncodedKeySpec(bytes);
            try {
                KeyFactory factory = KeyFactory.getInstance("RSA");
                key = factory.generatePublic(spec);
            }
            catch (Exception e) {
                KeyFactory factory = KeyFactory.getInstance("DSA");
                key = factory.generatePublic(spec);
            }
            KeyInfo ki = new KeyInfo();
            ki.setKeyValue(key);
            return ki;
        }
        throw this.isInvalid(c);
    }

    private X509Certificate securityTokenToCert(DOMCursor c) throws GeneralSecurityException {
        if (!c.atElement(WSSE_URI, "BinarySecurityToken")) {
            return null;
        }
        String valueType = c.getAttribute("ValueType");
        if (valueType == null) {
            return null;
        }
        if (!X509_QNAME.equals((Object)c.getQNameInContext(valueType))) {
            return null;
        }
        byte[] bytes = this.getBinaryValue(c);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
        return (X509Certificate)cf.generateCertificate(bais);
    }

    private DOMWriteCursor certToSecurityToken(X509Certificate cert, DOMWriteCursor c, boolean insertBefore) throws GeneralSecurityException {
        c = insertBefore ? c.addBefore(WSSE_URI, WSSE_PREFIX, "BinarySecurityToken") : c.addUnder(WSSE_URI, WSSE_PREFIX, "BinarySecurityToken");
        this.setBinaryValue(c, cert.getEncoded());
        return c;
    }

    private void setBinaryValue(DOMWriteCursor c, byte[] value) {
        c.setAttribute("ValueType", X509_QNAME.toString());
        c.setAttribute("EncodingType", BASE64_QNAME.toString());
        c.setText(Base64.encode((byte[])value));
    }

    private byte[] getBinaryValue(DOMCursor c) {
        String encodingType = c.getAttribute("EncodingType");
        if (encodingType == null) {
            return null;
        }
        QName qname = c.getQNameInContext(encodingType);
        if (BASE64_QNAME.equals((Object)qname)) {
            return Base64.decode((String)c.getText());
        }
        if (HEX_QNAME.equals((Object)qname)) {
            return new BigInteger(c.getText(), 16).toByteArray();
        }
        return null;
    }

    private KeyInfo certToKeyInfo(DOMCursor c, X509Certificate cert) throws XmlMessageException {
        if (cert == null) {
            throw this.isInvalid(c);
        }
        KeyInfo ki = new KeyInfo();
        ki.setCertificate(cert);
        return ki;
    }

    private KeyInfo verifierToKeyInfo(Verifier verifier) throws TrustVerificationException, GeneralSecurityException {
        try {
            KeyInfo keyInfo = new KeyInfo();
            X509Certificate[] chain = verifier.getCertificateChain();
            if (chain != null && chain.length > 0) {
                keyInfo.setCertificateChain(chain);
            } else {
                PublicKey key = verifier.getVerifyingKey();
                if (key != null) {
                    keyInfo.setKeyValue(key);
                } else {
                    return null;
                }
            }
            return keyInfo;
        }
        catch (XPathException e) {
            throw new InternalRuntimeException((Throwable)e);
        }
    }

    private String insertKeyInfo(DOMWriteCursor c, KeyInfo keyInfo) throws GeneralSecurityException {
        boolean insertBefore = this.moveToInsertPosition(c);
        XPath relativeLoc = c.createXPath();
        X509Certificate[] certs = keyInfo.getCertificateChain();
        if (certs.length == 1) {
            c = this.certToSecurityToken(certs[0], c, insertBefore);
            return this.makeID(c);
        }
        if ((c = keyInfo.toXML(c, insertBefore)) != null) {
            return this.makeID(c);
        }
        return null;
    }

    private String makeBodyID(DOMWriteCursor c) {
        c = c.cloneWriteCursor();
        this.moveToBody((DOMCursor)c);
        return this.makeID(c, WSU_URI, WSU_PREFIX);
    }

    private String makeID(DOMWriteCursor c) {
        return this.makeID(c, null, null);
    }

    private String makeID(DOMWriteCursor c, String nsURI, String nsPrefix) {
        String id = c.getAttribute("Id");
        if (id == null && (id = c.getAttribute(WSU_URI, "Id")) == null) {
            id = "wsse-" + UUID.generate();
            c.setAttribute(nsURI, nsPrefix, "Id", id);
        }
        return id;
    }

    private XmlMessageException notSupported(DOMCursor c) {
        return this.isInvalid(c, "XML security element not supported");
    }

    private XmlMessageException isInvalid(DOMCursor c) {
        return this.isInvalid(c, "XML security element is invalid");
    }

    private XmlMessageException isInvalid(DOMCursor c, String msg) {
        return new XmlMessageException(msg + ' ' + c);
    }

    private XmlMessageException cannotProcess(DOMCursor c, Throwable e) {
        return this.cannotProcess(c.createXPath(), e);
    }

    private XmlMessageException cannotProcess(XPath xpath, Throwable e) {
        return new XmlMessageException("Error processing XML security element, see cause exception " + xpath.getXPath(), e);
    }

    private XPath getSigLocation() {
        return new XPath(this.getSecurityExpr() + "/ds:Signature", NS_MAPPINGS);
    }

    private XPath getSecurityXPath() {
        return new XPath(this.getSecurityExpr(), NS_MAPPINGS);
    }

    private String getSecurityExpr() {
        return "/s:Envelope/s:Header/wsse:Security[" + (this.soapActor != null ? "@s:actor='" + this.soapActor + "']" : "not(@s:actor)]");
    }

    private void moveToBody(DOMCursor c) {
        c.moveToTop();
        if (!c.moveToChild(SOAP_URI, SOAP_BODY)) {
            throw new IllegalStateException("No SOAP Body element");
        }
    }

    private void addAndMoveToSoapHeader(DOMWriteCursor c) {
        c.moveToTop();
        if (c.moveToChild(1)) {
            if (!c.atElement(SOAP_URI, SOAP_HEADER)) {
                c.addBefore(SOAP_URI, SOAP_PREFIX, SOAP_HEADER);
                c.moveToSibling(-1);
            }
        } else {
            c.addUnder(SOAP_URI, SOAP_PREFIX, SOAP_HEADER);
            c.moveToChild(-1);
        }
    }

    private boolean moveToInsertPosition(DOMWriteCursor c) {
        boolean insertBefore = false;
        XPath relativeLoc = this.getSecurityXPath();
        if (c.moveToXPath(relativeLoc)) {
            if (c.moveToChild(1)) {
                insertBefore = true;
            }
        } else {
            this.addAndMoveToSoapHeader(c);
            if (c.moveToChild(1)) {
                c.addBefore(WSSE_URI, WSSE_PREFIX, "Security");
                c.moveToSibling(-1);
            } else {
                c.addUnder(WSSE_URI, WSSE_PREFIX, "Security");
                c.moveToChild(-1);
            }
            c.setAttribute(SOAP_URI, SOAP_PREFIX, "mustUnderstand", "1");
            if (this.soapActor != null) {
                c.setAttribute(SOAP_URI, SOAP_PREFIX, "actor", this.soapActor);
            }
        }
        return insertBefore;
    }

    private void addEnvelope(Document message) {
        SOAPMessage sOAPMessage = new SOAPMessage(message);
    }

    private void checkEnvelope(DOMCursor c) throws XmlMessageException {
        c.moveToTop();
        if (!c.atElement(SOAP_URI, SOAP_ENVELOPE)) {
            throw new XmlMessageException("Missing SOAP envelope");
        }
    }

    private byte[] sha1(byte[] data) throws GeneralSecurityException {
        MessageDigest md = MessageDigest.getInstance("SHA1");
        return md.digest(data);
    }

    static {
        WSSE_URI = WSSE_URI;
        WSSE_PREFIX = WSSE_PREFIX;
        WSU_URI = WSU_URI;
        WSU_PREFIX = WSU_PREFIX;
        SOAP_URI = Namespaces.SOAPENV.getUri();
        SOAP_PREFIX = Namespaces.SOAPENV.getPrefix();
        XMLSIG_URI = Namespaces.XMLSIG.getUri();
        XMLSIG_PREFIX = Namespaces.XMLSIG.getPrefix();
        XMLENC_URI = Namespaces.XMLENC.getUri();
        XMLENC_PREFIX = Namespaces.XMLENC.getPrefix();
        SOAP_ENVELOPE = SOAP_ENVELOPE;
        SOAP_HEADER = SOAP_HEADER;
        SOAP_BODY = SOAP_BODY;
        SOAP_FAULT = SOAP_FAULT;
        USE_WSU_FOR_SECURITY_TOKEN_ID = false;
        NS_MAPPINGS = new HashMap();
        NS_MAPPINGS.put(SOAP_PREFIX, SOAP_URI);
        NS_MAPPINGS.put(WSSE_PREFIX, WSSE_URI);
        NS_MAPPINGS.put(WSU_PREFIX, WSU_URI);
        NS_MAPPINGS.put(XMLSIG_PREFIX, XMLSIG_URI);
        X509_QNAME = new QName(WSSE_URI, WSSE_PREFIX, "X509v3");
        BASE64_QNAME = new QName(WSSE_URI, WSSE_PREFIX, "Base64Binary");
        HEX_QNAME = new QName(WSSE_URI, WSSE_PREFIX, "HexBinary");
    }
}

