/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.uddi.client.v3.ext.serialization;

import java.io.IOException;
import java.util.Map;
import javax.xml.namespace.QName;
import org.idoox.config.Configurable;
import org.idoox.wasp.serialization.SerializationChain;
import org.idoox.wasp.serialization.SerializationContext;
import org.idoox.wasp.serialization.XMLSerializer;
import org.idoox.xml.TokenWriter;
import org.idoox.xmlrpc.MessageCreatingException;
import org.systinet.uddi.client.serialization.SerializationMappingKey;
import org.systinet.uddi.client.serialization.SerializationMappingValue;
import org.systinet.uddi.client.serialization.Serializer;
import org.systinet.uddi.client.v3.ext.struct.ExtensionMapping;
import org.systinet.uddi.client.v3.ext.struct.ServiceInfoExt;
import org.systinet.uddi.client.v3.ext.util.Helper;
import org.systinet.uddi.client.v3.serialization.BindingTemplateSerializer;
import org.systinet.uddi.client.v3.serialization.DescriptionSerializer;
import org.systinet.uddi.client.v3.serialization.ServiceInfoSerializer;
import org.systinet.uddi.client.v3.struct.BindingTemplate;
import org.systinet.uddi.client.v3.struct.BindingTemplateArrayList;
import org.systinet.uddi.client.v3.struct.BindingTemplateArrayListIterator;
import org.systinet.uddi.client.v3.struct.Description;
import org.systinet.uddi.client.v3.struct.DescriptionArrayList;
import org.systinet.uddi.client.v3.struct.DescriptionArrayListIterator;
import org.systinet.wasp.webservice.Current;
import org.systinet.wasp.webservice.ServiceClientContext;
import org.systinet.wasp.webservice.ServiceEndpointContext;

public class ServiceInfoExtSerializer
implements XMLSerializer,
Serializer {
    public static final ServiceInfoExtSerializer serializer = new ServiceInfoExtSerializer();

    public static ServiceInfoExtSerializer getInstance() {
        return serializer;
    }

    public void serialize(TokenWriter dataWriter, Object data, SerializationContext context, SerializationChain next) throws MessageCreatingException {
        ServiceClientContext serviceClientContext;
        Map mapping = null;
        ServiceEndpointContext serviceEndpointContext = Current.getServiceEndpointContext();
        if (serviceEndpointContext != null) {
            mapping = (Map)serviceEndpointContext.getContextData().get("serializationMapping");
        }
        if ((serviceClientContext = Current.getServiceClientContext()) != null) {
            mapping = (Map)serviceClientContext.getContextData().get("serializationMapping");
        }
        if (mapping == null) {
            mapping = ExtensionMapping.serializationMapping;
        }
        SerializationMappingValue serializationMappingValue = null;
        serializationMappingValue = (SerializationMappingValue)mapping.get(new SerializationMappingKey(data.getClass().getName(), new QName("http://systinet.com/uddi/api/v3/ext/5.0", "serviceInfoExt")));
        if (serializationMappingValue != null) {
            Serializer serializer = serializationMappingValue.getSerializer();
            String namespaceURI = serializationMappingValue.getElement().getNamespaceURI();
            String localPart = serializationMappingValue.getElement().getLocalPart();
            serializer.serialize(dataWriter, data, namespaceURI, localPart, mapping);
        } else {
            this.serialize(dataWriter, data, "http://systinet.com/uddi/api/v3/ext/5.0", "serviceInfoExt", mapping);
        }
    }

    public void serialize(TokenWriter dataWriter, Object data, String namespace, String localName, Map mapping) throws MessageCreatingException {
        ServiceInfoExt uddiObject = (ServiceInfoExt)data;
        try {
            dataWriter.enter(namespace, localName);
            ServiceInfoSerializer.getInstance().serializeAttribute(dataWriter, uddiObject, namespace, localName, mapping);
            this.serializeAttribute(dataWriter, uddiObject, namespace, localName, mapping);
            ServiceInfoSerializer.getInstance().serializeBody(dataWriter, uddiObject, namespace, localName, mapping);
            this.serializeBody(dataWriter, uddiObject, namespace, localName, mapping);
            dataWriter.leave();
        }
        catch (IOException e) {
            throw new MessageCreatingException((Throwable)e);
        }
    }

    public void serializeAttribute(TokenWriter dataWriter, ServiceInfoExt uddiObject, String namespace, String localName, Map mapping) throws MessageCreatingException {
    }

    public void serializeBody(TokenWriter dataWriter, ServiceInfoExt uddiObject, String namespace, String localName, Map mapping) throws MessageCreatingException, IOException {
        BindingTemplateArrayList bindingTemplateArrayList;
        DescriptionArrayList descriptionArrayList = uddiObject.getDescriptionArrayList();
        if (!Helper.isNull(descriptionArrayList) && descriptionArrayList.size() > 0) {
            Serializer serializer = null;
            String namespaceURI = null;
            String localPart = null;
            SerializationMappingValue serializationMappingValue = null;
            DescriptionArrayListIterator iterator = descriptionArrayList.descriptionArrayListIterator();
            while (iterator.hasNext()) {
                Description item = iterator.next();
                serializationMappingValue = (SerializationMappingValue)mapping.get(new SerializationMappingKey(item.getClass().getName(), new QName("urn:uddi-org:api_v3", "description")));
                if (serializationMappingValue != null) {
                    serializer = serializationMappingValue.getSerializer();
                    namespaceURI = serializationMappingValue.getElement().getNamespaceURI();
                    localPart = serializationMappingValue.getElement().getLocalPart();
                    serializer.serialize(dataWriter, (Object)item, namespaceURI, localPart, mapping);
                    continue;
                }
                DescriptionSerializer.getInstance().serialize(dataWriter, item, "urn:uddi-org:api_v3", "description", mapping);
            }
        }
        if (!Helper.isNull(bindingTemplateArrayList = uddiObject.getBindingTemplateArrayList()) && bindingTemplateArrayList.size() > 0) {
            dataWriter.enter("urn:uddi-org:api_v3", "bindingTemplates");
            Serializer serializer = null;
            String namespaceURI = null;
            String localPart = null;
            SerializationMappingValue serializationMappingValue = null;
            BindingTemplateArrayListIterator iterator = bindingTemplateArrayList.bindingTemplateArrayListIterator();
            while (iterator.hasNext()) {
                BindingTemplate item = iterator.next();
                serializationMappingValue = (SerializationMappingValue)mapping.get(new SerializationMappingKey(item.getClass().getName(), new QName("urn:uddi-org:api_v3", "bindingTemplate")));
                if (serializationMappingValue != null) {
                    serializer = serializationMappingValue.getSerializer();
                    namespaceURI = serializationMappingValue.getElement().getNamespaceURI();
                    localPart = serializationMappingValue.getElement().getLocalPart();
                    serializer.serialize(dataWriter, (Object)item, namespaceURI, localPart, mapping);
                    continue;
                }
                BindingTemplateSerializer.getInstance().serialize(dataWriter, item, "urn:uddi-org:api_v3", "bindingTemplate", mapping);
            }
            dataWriter.leave();
        }
    }

    public void grabReferences(Object data, SerializationContext context, SerializationChain next) throws MessageCreatingException {
    }

    public void init(Configurable configurable) {
    }

    public String getMechanismType() {
        return "systinet:xmlser/1.0";
    }
}

