/*
 * Decompiled with CFR 0.152.
 */
package org.systinet.uddi.client.v3.ext.serialization;

import java.io.IOException;
import java.util.Map;
import javax.xml.namespace.QName;
import org.idoox.config.Configurable;
import org.idoox.wasp.serialization.SerializationChain;
import org.idoox.wasp.serialization.SerializationContext;
import org.idoox.wasp.serialization.XMLSerializer;
import org.idoox.xml.TokenWriter;
import org.idoox.xmlrpc.MessageCreatingException;
import org.systinet.uddi.client.serialization.SerializationMappingKey;
import org.systinet.uddi.client.serialization.SerializationMappingValue;
import org.systinet.uddi.client.serialization.Serializer;
import org.systinet.uddi.client.v3.ext.serialization.ContactInfoSerializer;
import org.systinet.uddi.client.v3.ext.struct.ContactInfo;
import org.systinet.uddi.client.v3.ext.struct.ContactInfoArrayList;
import org.systinet.uddi.client.v3.ext.struct.ContactInfoArrayListIterator;
import org.systinet.uddi.client.v3.ext.struct.ContactInfos;
import org.systinet.uddi.client.v3.ext.struct.ExtensionMapping;
import org.systinet.uddi.client.v3.ext.util.Helper;
import org.systinet.wasp.webservice.Current;
import org.systinet.wasp.webservice.ServiceClientContext;
import org.systinet.wasp.webservice.ServiceEndpointContext;

public class ContactInfosSerializer
implements XMLSerializer,
Serializer {
    public static final ContactInfosSerializer serializer = new ContactInfosSerializer();

    public static ContactInfosSerializer getInstance() {
        return serializer;
    }

    public void serialize(TokenWriter dataWriter, Object data, SerializationContext context, SerializationChain next) throws MessageCreatingException {
        ServiceClientContext serviceClientContext;
        Map mapping = null;
        ServiceEndpointContext serviceEndpointContext = Current.getServiceEndpointContext();
        if (serviceEndpointContext != null) {
            mapping = (Map)serviceEndpointContext.getContextData().get("serializationMapping");
        }
        if ((serviceClientContext = Current.getServiceClientContext()) != null) {
            mapping = (Map)serviceClientContext.getContextData().get("serializationMapping");
        }
        if (mapping == null) {
            mapping = ExtensionMapping.serializationMapping;
        }
        SerializationMappingValue serializationMappingValue = null;
        serializationMappingValue = (SerializationMappingValue)mapping.get(new SerializationMappingKey(data.getClass().getName(), new QName("http://systinet.com/uddi/api/v3/ext/5.0", "contactInfos")));
        if (serializationMappingValue != null) {
            Serializer serializer = serializationMappingValue.getSerializer();
            String namespaceURI = serializationMappingValue.getElement().getNamespaceURI();
            String localPart = serializationMappingValue.getElement().getLocalPart();
            serializer.serialize(dataWriter, data, namespaceURI, localPart, mapping);
        } else {
            this.serialize(dataWriter, data, "http://systinet.com/uddi/api/v3/ext/5.0", "contactInfos", mapping);
        }
    }

    public void serialize(TokenWriter dataWriter, Object data, String namespace, String localName, Map mapping) throws MessageCreatingException {
        ContactInfos uddiObject = (ContactInfos)data;
        try {
            dataWriter.enter(namespace, localName);
            this.serializeAttribute(dataWriter, uddiObject, namespace, localName, mapping);
            this.serializeBody(dataWriter, uddiObject, namespace, localName, mapping);
            dataWriter.leave();
        }
        catch (IOException e) {
            throw new MessageCreatingException((Throwable)e);
        }
    }

    public void serializeAttribute(TokenWriter dataWriter, ContactInfos uddiObject, String namespace, String localName, Map mapping) throws MessageCreatingException {
    }

    public void serializeBody(TokenWriter dataWriter, ContactInfos uddiObject, String namespace, String localName, Map mapping) throws MessageCreatingException, IOException {
        ContactInfoArrayList contactInfoArrayList = uddiObject.getContactInfoArrayList();
        if (!Helper.isNull(contactInfoArrayList) && contactInfoArrayList.size() > 0) {
            Serializer serializer = null;
            String namespaceURI = null;
            String localPart = null;
            SerializationMappingValue serializationMappingValue = null;
            ContactInfoArrayListIterator iterator = contactInfoArrayList.contactInfoArrayListIterator();
            while (iterator.hasNext()) {
                ContactInfo item = iterator.next();
                serializationMappingValue = (SerializationMappingValue)mapping.get(new SerializationMappingKey(item.getClass().getName(), new QName("http://systinet.com/uddi/api/v3/ext/5.0", "contactInfo")));
                if (serializationMappingValue != null) {
                    serializer = serializationMappingValue.getSerializer();
                    namespaceURI = serializationMappingValue.getElement().getNamespaceURI();
                    localPart = serializationMappingValue.getElement().getLocalPart();
                    serializer.serialize(dataWriter, (Object)item, namespaceURI, localPart, mapping);
                    continue;
                }
                ContactInfoSerializer.getInstance().serialize(dataWriter, item, "http://systinet.com/uddi/api/v3/ext/5.0", "contactInfo", mapping);
            }
        }
    }

    public void grabReferences(Object data, SerializationContext context, SerializationChain next) throws MessageCreatingException {
    }

    public void init(Configurable configurable) {
    }

    public String getMechanismType() {
        return "systinet:xmlser/1.0";
    }
}

